/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.util;

import gov.nasa.giss.util.DescribedItem;

public enum PanAnimationFormat implements DescribedItem
{
    MP4("MP4", "MP4 Video", true, false),
    JPEG("JPEG", "JPEG Frames", false, true),
    PNG("PNG", "PNG Frames", false, false),
    TIFF("TIFF", "TIFF Frames", false, false);

    private final String extension_;
    private final String description_;
    private final boolean video_;
    private final boolean compressible_;

    private PanAnimationFormat(String extension, String description, boolean video, boolean compressible) {
        this.extension_ = extension;
        this.description_ = description;
        this.video_ = video;
        this.compressible_ = compressible;
    }

    public String getExtension() {
        return this.extension_;
    }

    @Override
    public String getDescription() {
        return this.description_;
    }

    public String toString() {
        return this.description_;
    }

    public boolean isVideo() {
        return this.video_;
    }

    public boolean canReduceQuality() {
        return this.compressible_;
    }

    @Override
    public boolean matches(String text) {
        return this.name().equalsIgnoreCase(text) || this.extension_.equalsIgnoreCase(text);
    }
}

