/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.util;

import gov.nasa.giss.util.DescribedItem;

public enum PanColorbarLocation implements DescribedItem
{
    BELOW("Below Plot", true),
    RIGHT("At Right of Plot", false);

    private final String description_;
    private boolean horizontal_;

    private PanColorbarLocation(String description, boolean horizontal) {
        this.description_ = description;
        this.horizontal_ = horizontal;
    }

    @Override
    public String getDescription() {
        return this.description_;
    }

    public String toString() {
        return this.description_;
    }

    public boolean isHorizontal() {
        return this.horizontal_;
    }

    public boolean isVertical() {
        return !this.horizontal_;
    }

    @Override
    public boolean matches(String text) {
        if (text == null) {
            return false;
        }
        return this.name().equalsIgnoreCase(text) || this.description_.equalsIgnoreCase(text);
    }

    public static PanColorbarLocation matching(String str) {
        for (PanColorbarLocation item : PanColorbarLocation.values()) {
            if (!item.matches(str)) continue;
            return item;
        }
        return BELOW;
    }
}

