/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.time.planet;

import gov.nasa.giss.time.planet.AbstractPlanetTime;
import gov.nasa.giss.time.planet.PlanetID;

public class PlanetTime
extends AbstractPlanetTime {
    private static final double DEG_DAY = 0.9856262833675564;
    private static final double[] MARS_PBS_A = new double[]{0.0, 0.0071, 0.0057, 0.0039, 0.0037, 0.0021, 0.002, 0.0018, 0.0};
    private static final double[] MARS_PBS_PHI = new double[]{0.0, 49.409, 168.173, 191.837, 21.736, 15.704, 95.528, 49.095, 0.0};
    private static final double[] MARS_PBS_TAU_INV = new double[]{0.9856262833675564, 0.4409369137778179, 0.3578500102993706, 0.8818343771741581, 0.062434361000313965, 0.4615651790613264, 0.399135937218578, 0.03000448360749107};
    private static final double[] SATURN_PBS_A = new double[]{0.0, 0.015, 0.012, 0.008, 0.005, 0.002, 0.001};
    private static final double[] SATURN_PBS_PHI = new double[]{0.0, 294.2, 180.0, 342.7, 288.6, 168.1, 328.4};
    private static final double[] SATURN_PBS_N = new double[]{0.0, 1182.43, 0.0, 1812.79, 591.22, 3913.98, 362558.36};
    private double e1_;
    private double e2_;
    private double e3_;
    private double e4_;
    private PlanetID planetID_;

    public PlanetTime(PlanetID pid) {
        this(pid, System.currentTimeMillis());
    }

    public PlanetTime(PlanetID pid, long millis) {
        this.planetID_ = pid;
        switch (this.planetID_) {
            case MERCURY: {
                this.semimajorAxisAU_ = 0.387098;
                this.flattening_ = 0.0;
                break;
            }
            case VENUS: {
                this.semimajorAxisAU_ = 0.72333;
                this.flattening_ = 0.0;
                break;
            }
            case EARTH: {
                this.semimajorAxisAU_ = 1.000001;
                this.flattening_ = 0.0;
                break;
            }
            case MARS: {
                this.semimajorAxisAU_ = 1.523679;
                this.flattening_ = 0.0064763;
                break;
            }
            case JUPITER: {
                this.semimajorAxisAU_ = 5.202603;
                this.flattening_ = 0.065;
                break;
            }
            case SATURN: {
                this.semimajorAxisAU_ = 9.554909;
                this.flattening_ = 0.09796;
                break;
            }
            case URANUS: {
                this.semimajorAxisAU_ = 19.218446;
                this.flattening_ = 0.023;
                break;
            }
            case NEPTUNE: {
                this.semimajorAxisAU_ = 30.110387;
                this.flattening_ = 0.017;
                break;
            }
            case PLUTO: {
                this.semimajorAxisAU_ = 39.543;
                this.flattening_ = 0.0;
                break;
            }
            default: {
                throw new IllegalArgumentException("No switch case for Planet " + pid);
            }
        }
        this.oneMinusFlatten_ = 1.0 - this.flattening_;
        this.setMillis(millis);
    }

    @Override
    protected void calculate() {
        if (this.planetID_ == null) {
            return;
        }
        double jmil2 = this.jmil_ * this.jmil_;
        switch (this.planetID_) {
            case MERCURY: {
                this.obliquity_ = 0.011;
                break;
            }
            case VENUS: {
                this.obliquity_ = 2.638 + 0.045 * this.jmil_;
                break;
            }
            case EARTH: {
                this.obliquity_ = 23.4393 - 0.13 * this.jmil_ + 6.0E-4 * jmil2;
                break;
            }
            case MARS: {
                this.obliquity_ = 25.1919 + 0.127 * this.jmil_ + 0.006 * jmil2;
                break;
            }
            case JUPITER: {
                this.obliquity_ = 3.125 + 0.011 * this.jmil_ + 0.003 * jmil2;
                break;
            }
            case SATURN: {
                this.obliquity_ = 26.728 + 0.084 * this.jmil_ + 0.005 * jmil2;
                break;
            }
            case URANUS: {
                this.obliquity_ = 82.23 + 0.011 * this.jmil_ + 4.0E-4 * jmil2;
                break;
            }
            case NEPTUNE: {
                this.obliquity_ = 27.85 - 0.002 * this.jmil_ + 9.51 * Math.cos(Math.PI / 180 * (336.7 + 523.16 * this.jmil_));
                break;
            }
            case PLUTO: {
                this.obliquity_ = 57.465 - 0.025 * this.jmil_ + 1.0E-5 * jmil2;
                break;
            }
            default: {
                throw new IllegalArgumentException("No switch case for Planet " + this.planetID_);
            }
        }
        double obliquityRad = this.obliquity_ * (Math.PI / 180);
        double cosObliquity = Math.cos(obliquityRad);
        double sinObliquity = Math.sin(obliquityRad);
        switch (this.planetID_) {
            case MERCURY: {
                this.eccentricity_ = 0.205632 + 2.0E-4 * this.jmil_;
                break;
            }
            case VENUS: {
                this.eccentricity_ = 0.006722 - 4.8E-4 * this.jmil_;
                break;
            }
            case EARTH: {
                this.eccentricity_ = 0.016709 - 4.2E-4 * this.jmil_;
                break;
            }
            case MARS: {
                this.eccentricity_ = 0.093401 + 9.0E-4 * this.jmil_;
                break;
            }
            case JUPITER: {
                this.eccentricity_ = 0.048498 + 0.00163 * this.jmil_;
                break;
            }
            case SATURN: {
                this.eccentricity_ = 0.055548 - 0.00347 * this.jmil_;
                break;
            }
            case URANUS: {
                this.eccentricity_ = 0.046381 - 2.7E-4 * this.jmil_;
                break;
            }
            case NEPTUNE: {
                this.eccentricity_ = 0.009456 + 6.0E-5 * this.jmil_;
                break;
            }
            case PLUTO: {
                this.eccentricity_ = 0.249 - 2.0E-5 * this.jmil_;
                break;
            }
            default: {
                throw new IllegalArgumentException("No switch case for Planet " + this.planetID_);
            }
        }
        this.e1_ = this.eccentricity_;
        this.e2_ = this.e1_ * this.e1_;
        this.e3_ = this.e1_ * this.e2_;
        this.e4_ = this.e1_ * this.e3_;
        double e5 = this.e1_ * this.e4_;
        double e6 = this.e1_ * e5;
        switch (this.planetID_) {
            case MERCURY: {
                this.meanAnomaly_ = 174.795 + 1494725.158 * this.jmil_ + 0.001 * jmil2;
                break;
            }
            case VENUS: {
                this.meanAnomaly_ = 50.416 + 585178.108 * this.jmil_ + 0.139 * jmil2 + 0.001 * Math.cos(Math.PI / 180 * (297.1 + 1504.0 * this.jmil_));
                break;
            }
            case EARTH: {
                this.meanAnomaly_ = 357.529 + 359990.503 * this.jmil_ - 0.015 * jmil2 + 0.002 * Math.cos(Math.PI / 180 * (162.1 + 206.0 * this.jmil_));
                break;
            }
            case MARS: {
                this.meanAnomaly_ = 19.373 + 191398.554 * this.jmil_ + 0.018 * jmil2 + 0.014 * Math.cos(Math.PI / 180 * (339.4 + 193.7 * this.jmil_));
                break;
            }
            case JUPITER: {
                this.meanAnomaly_ = 20.02 + 30346.901 * this.jmil_ - 0.081 * jmil2 + (0.329 - 0.017 * this.jmil_) * Math.cos(Math.PI / 180 * (82.4 + 384.9 * this.jmil_));
                break;
            }
            case SATURN: {
                this.meanAnomaly_ = 317.02 + 12215.473 * this.jmil_ - 0.032 * jmil2 + (0.801 - 0.041 * this.jmil_) * Math.cos(Math.PI / 180 * (262.4 + 384.9 * this.jmil_));
                break;
            }
            case URANUS: {
                this.meanAnomaly_ = 141.05 + 4283.777 * this.jmil_ + 0.0 * jmil2 + (0.876 - 0.005 * this.jmil_) * Math.cos(Math.PI / 180 * (207.8 + 84.2 * this.jmil_));
                break;
            }
            case NEPTUNE: {
                this.meanAnomaly_ = 256.228 + 2184.57 * this.jmil_ - 0.008 * jmil2 + (0.583 - 0.003 * this.jmil_) * Math.cos(Math.PI / 180 * (27.9 + 84.2 * this.jmil_));
                break;
            }
            case PLUTO: {
                this.meanAnomaly_ = 14.885 + 1449.6 * this.jmil_;
                break;
            }
            default: {
                throw new IllegalArgumentException("No switch case for Planet " + this.planetID_);
            }
        }
        this.meanAnomalyRad_ = this.meanAnomaly_ * (Math.PI / 180);
        double sin1M = Math.sin(this.meanAnomalyRad_);
        double sin2M = Math.sin(2.0 * this.meanAnomalyRad_);
        double sin3M = Math.sin(3.0 * this.meanAnomalyRad_);
        double sin4M = Math.sin(4.0 * this.meanAnomalyRad_);
        double sin5M = Math.sin(5.0 * this.meanAnomalyRad_);
        double sin6M = Math.sin(6.0 * this.meanAnomalyRad_);
        switch (this.planetID_) {
            case MERCURY: {
                this.veeM_ = 47.762 + 6.1385216 * this.delta2000_;
                break;
            }
            case VENUS: {
                this.veeM_ = 104.907 - 1.4813594 * this.delta2000_;
                break;
            }
            case EARTH: {
                this.veeM_ = 280.461 + 360.9856474 * this.delta2000_;
                break;
            }
            case MARS: {
                this.veeM_ = 313.383 + 350.8919849 * this.delta2000_;
                break;
            }
            case JUPITER: {
                this.veeM_ = 145.942 + 870.536642 * this.delta2000_;
                break;
            }
            case SATURN: {
                this.veeM_ = 174.351 + 810.7939009 * this.delta2000_;
                break;
            }
            case URANUS: {
                this.veeM_ = 29.647 - 501.1600928 * this.delta2000_;
                break;
            }
            case NEPTUNE: {
                this.veeM_ = 52.785 + 536.3128492 * this.delta2000_;
                break;
            }
            case PLUTO: {
                this.veeM_ = 57.23 - 56.3623195 * this.delta2000_;
                break;
            }
            default: {
                throw new IllegalArgumentException("No switch case for Planet " + this.planetID_);
            }
        }
        switch (this.planetID_) {
            case MERCURY: {
                this.ellSP_ = 325.749 + 8.86 * this.jmil_;
                break;
            }
            case VENUS: {
                this.ellSP_ = 253.751 + 3.495 * this.jmil_ - 0.138 * jmil2;
                break;
            }
            case EARTH: {
                this.ellSP_ = 282.932 + 17.195 * this.jmil_ + 0.046 * jmil2;
                break;
            }
            case MARS: {
                this.ellSP_ = 251.0 + 6.452 * this.jmil_ - 0.009 * jmil2;
                break;
            }
            case JUPITER: {
                this.ellSP_ = 57.074 + 2.245 * this.jmil_ + 0.08 * jmil2;
                break;
            }
            case SATURN: {
                this.ellSP_ = 279.457 + 5.64 * this.jmil_ + 0.064 * jmil2;
                break;
            }
            case URANUS: {
                this.ellSP_ = 185.462 + 0.891 * this.jmil_ - 0.009 * jmil2;
                break;
            }
            case NEPTUNE: {
                this.ellSP_ = 2.203 + 0.296 * this.jmil_ + 1.087 * Math.cos(Math.PI / 180 * (67.15 + 523.16 * this.jmil_));
                break;
            }
            case PLUTO: {
                this.ellSP_ = 184.544 - 0.135 * this.jmil_ - 2.0E-5 * jmil2;
                break;
            }
            default: {
                throw new IllegalArgumentException("No switch case for Planet " + this.planetID_);
            }
        }
        double pbs = 0.0;
        if (this.planetID_ == PlanetID.MARS) {
            for (int k = 1; k < 8; ++k) {
                pbs += MARS_PBS_A[k] * Math.cos(Math.PI / 180 * (MARS_PBS_TAU_INV[k] * this.delta2000_ + MARS_PBS_PHI[k]));
            }
        }
        double equationOfCenter = 57.29577951308232 * (sin1M * (2.0 * this.e1_ - 0.25 * this.e3_ + 0.052083333333333336 * e5) + sin2M * (1.25 * this.e2_ - 0.4583333333333333 * this.e4_ + 0.08854166666666667 * e6) + sin3M * (1.0833333333333333 * this.e3_ - 0.6825396825396826 * e5) + sin4M * (1.0729166666666667 * this.e4_ - 0.9395833333333333 * e6) + sin5M * (1.1427083333333334 * e5) + sin6M * (1.2739583333333333 * e6)) + pbs;
        this.trueAnomaly_ = equationOfCenter + this.meanAnomaly_;
        this.ellS_ = this.meanAnomaly_ + this.ellSP_ + equationOfCenter;
        this.ellSRad_ = this.ellS_ * (Math.PI / 180);
        this.cosEllS_ = Math.cos(this.ellSRad_);
        this.sinEllS_ = Math.sin(this.ellSRad_);
        this.alphaFMS_ = this.ellS_ - equationOfCenter;
        double alphaS = 57.29577951308232 * Math.atan(cosObliquity * Math.tan(this.ellSRad_));
        double declinSPC = 57.29577951308232 * Math.asin(sinObliquity * this.sinEllS_);
        this.declinSPG_ = this.transformLat2PG(declinSPC);
        this.subsolarLonPG_ = (this.veeM_ - alphaS) % 360.0;
        this.tst0_ = PlanetTime.normalize24(this.subsolarLonPG_ * 0.06666666666666667 + 12.0);
        this.mst0_ = PlanetTime.normalize24((this.veeM_ - this.alphaFMS_) % 360.0 * 0.06666666666666667 + 12.0);
        this.eotHours_ = this.tst0_ - this.mst0_;
        this.eotDegrees_ = this.eotHours_ * 15.0;
        this.gotOrbitParams_ = false;
        this.gotEarthParams_ = false;
    }

    @Override
    protected void calculateOrbitParams() {
        double jmil2 = this.jmil_ * this.jmil_;
        double jmil3 = jmil2 * this.jmil_;
        double betaPole = 0.0;
        switch (this.planetID_) {
            case MERCURY: {
                betaPole = 82.995 + 0.0595 * this.jmil_ - 1.0E-4 * jmil2 - 4.0E-5 * jmil3;
                this.lambdaRot_ = 318.41 - 1.2665 * this.jmil_ - 0.0102 * jmil2 + 4.0E-5 * jmil3;
                this.betaRot_ = 82.99 + 0.059 * this.jmil_ - 0.0012 * jmil2 - 1.0E-5 * jmil3;
                break;
            }
            case VENUS: {
                betaPole = 86.6053 + 0.0086 * this.jmil_ + 0.0032 * jmil2 - 9.0E-6 * jmil3;
                this.lambdaRot_ = 30.186;
                this.betaRot_ = 88.761;
                break;
            }
            case EARTH: {
                betaPole = 90.0 - 0.1305 * this.jmil_ + 9.0E-4 * jmil2 + 3.0E-5 * jmil3;
                this.lambdaRot_ = 90.0 - 13.9958 * this.jmil_ + 0.0298 * jmil2 + 3.0E-4 * jmil3;
                this.betaRot_ = 66.5607 + 7.0E-5 * this.jmil_ - 0.0014 * jmil2 + 0.0021 * jmil3;
                break;
            }
            case MARS: {
                betaPole = 88.1503 + 0.0815 * this.jmil_ + 0.0023 * jmil2 + 3.0E-5 * jmil3;
                this.lambdaRot_ = 352.9076 - 1.9631 * this.jmil_ - 0.0054 * jmil2 + 1.0E-4 * jmil3;
                this.betaRot_ = 63.282 - 0.0418 * this.jmil_ - 0.004 * jmil2 - 8.0E-5 * jmil3;
                break;
            }
            case JUPITER: {
                betaPole = 88.6967 + 0.0199 * this.jmil_ - 0.0033 * jmil2 - 1.0E-4 * jmil3;
                this.lambdaRot_ = 247.797 - 1.2607 * this.jmil_ - 0.0071 * jmil2 + 1.0E-4 * jmil3;
                this.betaRot_ = 87.778 + 0.0146 * this.jmil_ + 5.0E-4 * jmil2 + 3.0E-6 * jmil3;
                break;
            }
            case SATURN: {
                betaPole = 87.5111 - 0.0255 * this.jmil_ + 0.0049 * jmil2 - 2.0E-5 * jmil3;
                this.lambdaRot_ = 79.5275 - 0.1207 * this.jmil_ - 2.0E-4 * jmil2 + 7.0E-7 * jmil3;
                this.betaRot_ = 61.9478 - 0.0046 * this.jmil_ + 2.0E-4 * jmil2 + 2.0E-7 * jmil3;
                break;
            }
            case URANUS: {
                this.lambdaRot_ = 257.6467;
                this.betaRot_ = 7.7218;
                break;
            }
            case NEPTUNE: {
                betaPole = 0.0;
                break;
            }
            case PLUTO: {
                betaPole = 0.0;
                break;
            }
            default: {
                throw new RuntimeException("No switch case for PlanetID " + this.planetID_);
            }
        }
        double inclination = 90.0 - betaPole;
        this.rHeliocentricAU_ = this.semimajorAxisAU_ * (1.0 + 0.5 * this.e2_ - (this.e1_ - 0.375 * this.e3_) * Math.cos(this.meanAnomalyRad_) - (0.5 * this.e2_ - 0.3333333333333333 * this.e4_) * Math.cos(2.0 * this.meanAnomalyRad_) - 0.375 * this.e3_ * Math.cos(3.0 * this.meanAnomalyRad_) - 0.3333333333333333 * this.e4_ * Math.cos(4.0 * this.meanAnomalyRad_));
        if (this.planetID_ == PlanetID.SATURN) {
            for (int k = 1; k < 7; ++k) {
                this.rHeliocentricAU_ += SATURN_PBS_A[k] * Math.cos(Math.PI / 180 * (SATURN_PBS_N[k] * this.jcent_ + SATURN_PBS_PHI[k]));
            }
        }
        double myChi = 0.0;
        double myOmega = 0.0;
        switch (this.planetID_) {
            case MERCURY: {
                myChi = 116.633 + 6.017 * this.jmil_ + 6.49 * jmil2;
                myOmega = 77.456 + 1.589 * this.jmil_ - 0.001 * jmil2;
                break;
            }
            case VENUS: {
                myChi = 18.874 + 0.666 * this.jmil_ - 0.014 * jmil2;
                myOmega = 131.564 + 0.049 * this.jmil_ - 0.138 * jmil2;
                break;
            }
            case EARTH: {
                myChi = 174.873 + 11.937 * this.jmil_ + 0.035 * jmil2;
                myOmega = 102.937 + 3.226 * this.jmil_ + 0.015 * jmil2;
                break;
            }
            case MARS: {
                myChi = 144.502 - 0.937 * this.jmil_ - 0.056 * jmil2;
                myOmega = 336.06 + 4.439 * this.jmil_ - 0.017 * jmil2;
                break;
            }
            case JUPITER: {
                myChi = 323.21 + 1.857 * this.jmil_ + 0.098 * jmil2;
                myOmega = 14.331 + 2.155 * this.jmil_ + 0.072 * jmil2;
                break;
            }
            case SATURN: {
                myChi = 120.067 - 2.592 * this.jmil_ - 0.007 * jmil2;
                myOmega = 93.057 + 5.665 * this.jmil_ + 0.053 * jmil2;
                break;
            }
            case URANUS: {
                myChi = 266.464 + 0.739 * this.jmil_ + 0.041 * jmil2;
                myOmega = 173.005 + 0.893 * this.jmil_ - 0.009 * jmil2;
                break;
            }
            case NEPTUNE: {
                break;
            }
            case PLUTO: {
                break;
            }
            default: {
                throw new IllegalArgumentException("No switch case for Planet " + this.planetID_);
            }
        }
        double tanTerm = Math.tan(Math.PI / 360 * inclination);
        this.lonEcliptic_ = this.ellS_ - this.ellSP_ + myOmega - 57.29577951308232 * tanTerm * tanTerm * Math.sin(Math.PI / 90 * (this.ellS_ - myChi));
        this.lonEcliptic_ = PlanetTime.normalize360(this.lonEcliptic_);
        this.latEcliptic_ = -57.29577951308232 * Math.asin(Math.sin(Math.PI / 180 * inclination) * Math.sin(Math.PI / 180 * (this.ellS_ - myChi)));
        this.gotOrbitParams_ = true;
    }

    @Override
    public double getVernalEquinox() {
        return this.getHeliocentricLongitude() + 180.0 - this.getSolarLongitude();
    }

    @Override
    public double getHeliocentricLongitudeAtPerihelion() {
        return this.ellSP_ + this.getVernalEquinox();
    }
}

