/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array;

import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcTimeAxis;
import gov.nasa.giss.data.nc.NcUtils;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArray2D;
import gov.nasa.giss.data.nc.exc.NcNullException;
import gov.nasa.giss.data.nc.gridder.NcGridder;
import gov.nasa.giss.data.nc.gridder.NcGridderLonTime;
import gov.nasa.giss.text.PrintfFormat;
import java.util.Objects;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.VariableDS;

public class NcArrayLonTime
extends NcArray2D {
    public NcArrayLonTime(NcVariable ncvar) throws NcException {
        super(ncvar);
        this.createAxes();
        this.measureAxes();
    }

    @Override
    protected void createAxes() {
        VariableDS cv;
        NcDataset ncd = this.getDataset();
        CoordinateAxis x = this.getCoordinateAxisOfType(NcAxisType.LON);
        CoordinateAxis y = this.getCoordinateAxisOfType(NcAxisType.TIME);
        if (x == null) {
            cv = this.getCoordinateVariable(NcAxisType.LON);
            if (cv != null) {
                this.xAxis_ = new NcAxis(NcAxisType.LON, ncd, cv);
                this.xDimIndex_ = this.findDimensionIndex(cv);
            }
        } else {
            this.xAxis_ = new NcAxis(NcAxisType.LON, ncd, x);
            this.xDimIndex_ = this.findDimensionIndex(x);
        }
        if (y == null) {
            cv = this.getCoordinateVariable(NcAxisType.TIME);
            if (cv != null) {
                this.yAxis_ = new NcTimeAxis(ncd, cv);
                this.yDimIndex_ = this.findDimensionIndex(cv);
            }
        } else {
            this.yAxis_ = new NcTimeAxis(ncd, y);
            this.yDimIndex_ = this.findDimensionIndex(y);
        }
        if (this.xAxis_ == null) {
            throw new NcNullException("Found null when retrieving LON coordinate axis");
        }
        if (this.yAxis_ == null) {
            throw new NcNullException("Found null when retrieving TIME coordinate axis");
        }
        if (this.xDimIndex_ == -1) {
            throw new NcException("Unable to determine dim index for LON axis");
        }
        if (this.yDimIndex_ == -1) {
            throw new NcException("Unable to determine dim index for TIME axis");
        }
    }

    @Override
    public NcGridder getGridder() {
        return new NcGridderLonTime();
    }

    @Override
    public void describeCell(StringBuilder sb, PrintfFormat valFormat, int ... index) {
        Objects.requireNonNull(index, "Cell index cannot be null.");
        int col = index[0];
        int row = index[1];
        if (col < 0 || row < 0) {
            sb.append("Pt apparently outside data bounds");
            return;
        }
        int colDisplay = col + 1;
        int rowDisplay = row + 1;
        double lon = this.xAxis_.valueAt(col);
        double time = this.yAxis_.valueAt(row);
        double value = this.valueAt(col, row);
        sb.append("Cell [").append(colDisplay).append(", ").append(rowDisplay).append("] at [").append(NcUtils.formatLongitude(lon)).append(", ").append(new PrintfFormat("%.10g").sprintfx(time)).append("], value = ").append(valFormat.sprintfx(value));
        if (Double.isNaN(value)) {
            return;
        }
        String unitsStr = this.getUnitsStr();
        if (unitsStr != null && !unitsStr.isEmpty() && !"1".equals(unitsStr)) {
            sb.append(' ').append(unitsStr);
        }
    }
}

