/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.gridder;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.array.NcArrayLonLatCubedSphereGMAO;
import gov.nasa.giss.data.nc.gridder.NcGridderLonLat;
import gov.nasa.giss.math.MathUtils;
import java.awt.Dimension;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NcGridderLonLatCubedSphereGMAO
extends NcGridderLonLat {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public NcGridderLonLatCubedSphereGMAO() {
        this(100, 50);
    }

    public NcGridderLonLatCubedSphereGMAO(Dimension size) {
        this(size.width, size.height);
    }

    public NcGridderLonLatCubedSphereGMAO(int w, int h) {
        super(w, h);
    }

    @Override
    public void regridNoInterpolate(NcArray a, double[] target) {
        this.prepareGridAxes();
        NcArrayLonLatCubedSphereGMAO nca = (NcArrayLonLatCubedSphereGMAO)a;
        int faces = nca.getFaceCount();
        boolean hasBad = nca.hasBadValues();
        int numXs = nca.getXAxis().getLength();
        int numYs = nca.getYAxis().getLength();
        for (int iface = 0; iface < faces; ++iface) {
            for (int j = 0; j < numYs; ++j) {
                for (int i = 0; i < numXs; ++i) {
                    double[][] corners;
                    double value = nca.valueAt(iface, i, j);
                    if (hasBad && nca.isMissingOrInvalid(value) || (corners = nca.cornerLonLats(iface, i, j)) == null) continue;
                    double lon1 = corners[0][0];
                    double lon2 = corners[1][0];
                    double lon3 = corners[2][0];
                    double lon4 = corners[3][0];
                    double lat1 = corners[0][1];
                    double lat2 = corners[1][1];
                    double lat3 = corners[2][1];
                    double lat4 = corners[3][1];
                    if (Math.abs(lon2 - lon1) > 180.0 || Math.abs(lon3 - lon1) > 180.0 || Math.abs(lon4 - lon1) > 180.0 || Math.abs(lon3 - lon2) > 180.0 || Math.abs(lon4 - lon2) > 180.0 || Math.abs(lon4 - lon3) > 180.0) {
                        LOGGER.debug("Odd corner lons for {},{},{}", iface, i, j);
                        LOGGER.debug("-- Corner 1, {},{}", (Object)lon1, (Object)lat1);
                        LOGGER.debug("-- Corner 2, {},{}", (Object)lon2, (Object)lat2);
                        LOGGER.debug("-- Corner 3, {},{}", (Object)lon3, (Object)lat3);
                        LOGGER.debug("-- Corner 4, {},{}", (Object)lon4, (Object)lat4);
                    }
                    this.quadSolidFillLL(lon1, lat1, lon2, lat2, lon3, lat3, lon4, lat4, value, target);
                }
            }
        }
    }

    @Override
    public void regridInterpolate(NcArray a, double[] target) {
        double lon2;
        double lon1;
        double lat2;
        double lat1;
        double val4;
        double val3;
        double val2;
        double val1;
        this.prepareGridAxes();
        NcArrayLonLatCubedSphereGMAO nca = (NcArrayLonLatCubedSphereGMAO)a;
        int faces = nca.getFaceCount();
        int numXs = nca.getXAxis().getLength();
        int numYs = nca.getYAxis().getLength();
        int lastX = numXs - 1;
        int lastY = numYs - 1;
        for (int iface = 0; iface < faces; ++iface) {
            for (int j = 0; j < lastY; ++j) {
                int jp1 = j < numYs - 1 ? j + 1 : 0;
                for (int i = 0; i < lastX; ++i) {
                    int ip1;
                    int n = ip1 = i < numXs - 1 ? i + 1 : 0;
                    if (nca.isNearPole(iface, i, j) && nca.isNearPole(iface, ip1, jp1)) continue;
                    val1 = nca.valueAt(iface, i, j);
                    val2 = nca.valueAt(iface, ip1, j);
                    val3 = nca.valueAt(iface, ip1, jp1);
                    val4 = nca.valueAt(iface, i, jp1);
                    if (Double.isNaN(val2) && Double.isNaN(val3) || Double.isNaN(val3) && Double.isNaN(val4)) continue;
                    lat1 = nca.latitudeAt(iface, i, j);
                    lat2 = nca.latitudeAt(iface, ip1, j);
                    double lat3 = nca.latitudeAt(iface, ip1, jp1);
                    double lat4 = nca.latitudeAt(iface, i, jp1);
                    lon1 = nca.longitudeAt(iface, i, j);
                    lon2 = nca.longitudeAt(iface, ip1, j);
                    double lon3 = nca.longitudeAt(iface, ip1, jp1);
                    double lon4 = nca.longitudeAt(iface, i, jp1);
                    if (lon1 - 135.0 > lon2) {
                        lon2 += 360.0;
                    } else if (lon2 - 135.0 > lon1) {
                        lon2 -= 360.0;
                    }
                    if (lon1 - 135.0 > lon3) {
                        lon3 += 360.0;
                    } else if (lon3 - 135.0 > lon1) {
                        lon3 -= 360.0;
                    }
                    if (lon1 - 135.0 > lon4) {
                        lon4 += 360.0;
                    } else if (lon4 - 135.0 > lon1) {
                        lon4 -= 360.0;
                    }
                    this.quadInterpolateFillLL(lon1, lat1, val1, lon2, lat2, val2, lon3, lat3, val3, lon4, lat4, val4, target);
                }
            }
        }
        for (int ipole = 0; ipole < 2; ++ipole) {
            double pval;
            double plat;
            int[][] pin;
            int[][] nArray = pin = ipole == 0 ? nca.getNorthPoleCellIndices() : nca.getSouthPoleCellIndices();
            if (pin == null) continue;
            double d = plat = ipole == 0 ? 90.0 : -90.0;
            if (pin.length != 4 || Double.isNaN(pval = MathUtils.average2(val1 = nca.valueAt(pin[0][0], pin[0][1], pin[0][2]), val2 = nca.valueAt(pin[1][0], pin[1][1], pin[1][2]), val3 = nca.valueAt(pin[2][0], pin[2][1], pin[2][2]), val4 = nca.valueAt(pin[3][0], pin[3][1], pin[3][2])))) continue;
            for (int i = 0; i < 4; ++i) {
                int ip1 = i < 3 ? i + 1 : 0;
                val1 = nca.valueAt(pin[i][0], pin[i][1], pin[i][2]);
                val2 = nca.valueAt(pin[ip1][0], pin[ip1][1], pin[ip1][2]);
                if (Double.isNaN(val1) || Double.isNaN(val2)) continue;
                lat1 = nca.latitudeAt(pin[i][0], pin[i][1], pin[i][2]);
                lat2 = nca.latitudeAt(pin[ip1][0], pin[ip1][1], pin[ip1][2]);
                lon1 = nca.longitudeAt(pin[i][0], pin[i][1], pin[i][2]);
                lon2 = nca.longitudeAt(pin[ip1][0], pin[ip1][1], pin[ip1][2]);
                if (lon2 - lon1 > 180.0) {
                    lon2 -= 360.0;
                }
                if (lon1 - lon2 > 180.0) {
                    lon1 -= 360.0;
                }
                this.quadInterpolateFillLL(lon1, lat1, val1, lon1, plat, pval, lon2, plat, pval, lon2, lat2, val2, target);
            }
        }
    }
}

