/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.gridder;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.array.NcArray2D;
import gov.nasa.giss.data.nc.array.NcArrayLonLatProjected;
import gov.nasa.giss.data.nc.gridder.NcGridderLonLat;
import gov.nasa.giss.data.nc.gridder.NcGridderUtils;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NcGridderLonLatProjected
extends NcGridderLonLat {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected double lProjBound_;
    protected double tProjBound_;
    protected double rProjBound_;
    protected double bProjBound_;
    protected double xPxlPerProj_;
    protected double yPxlPerProj_;
    protected double[] pcolXX_;
    protected double[] prowYY_;
    protected int iigridWidth_;
    protected int iigridHeight_;

    public NcGridderLonLatProjected() {
        this(100, 50);
    }

    public NcGridderLonLatProjected(Dimension size) {
        this(size.width, size.height);
    }

    public NcGridderLonLatProjected(int w, int h) {
        super(w, h);
    }

    @Override
    public void regridNoInterpolate(NcArray a, double[] target) {
        int j;
        NcArray2D nca = (NcArray2D)a;
        double[] bgrid = this.makeIntermediateGrid((NcArrayLonLatProjected)nca);
        boolean hasBad = nca.hasBadValues();
        NcAxis xAxis = nca.getXAxis();
        NcAxis yAxis = nca.getYAxis();
        int numXs = xAxis.getLength();
        int numYs = yAxis.getLength();
        double[][] xBounds = xAxis.getBounds();
        double[][] yBounds = yAxis.getBounds();
        int[] srcRow = new int[this.iigridHeight_];
        int[] srcCol = new int[this.iigridWidth_];
        block0: for (j = 0; j < this.iigridHeight_; ++j) {
            srcRow[j] = -1;
            for (int jj = 0; jj < numYs; ++jj) {
                if (!(this.prowYY_[j] <= yBounds[jj][0] && this.prowYY_[j] > yBounds[jj][1]) && (!(this.prowYY_[j] >= yBounds[jj][0]) || !(this.prowYY_[j] < yBounds[jj][1]))) continue;
                srcRow[j] = jj;
                continue block0;
            }
        }
        block2: for (int i = 0; i < this.iigridWidth_; ++i) {
            srcCol[i] = -1;
            for (int ii = 0; ii < numXs; ++ii) {
                if (!(this.pcolXX_[i] >= xBounds[ii][0] && this.pcolXX_[i] < xBounds[ii][1]) && (!(this.pcolXX_[i] < xBounds[ii][0]) || !(this.pcolXX_[i] >= xBounds[ii][1]))) continue;
                srcCol[i] = ii;
                continue block2;
            }
        }
        for (j = 0; j < this.iigridHeight_; ++j) {
            if (srcRow[j] < 0) continue;
            for (int i = 0; i < this.iigridWidth_; ++i) {
                if (srcCol[i] < 0) continue;
                double value = nca.valueAt(srcCol[i], srcRow[j]);
                if (hasBad && nca.isMissingOrInvalid(value)) {
                    value = Double.NaN;
                }
                NcGridderUtils.setValue(bgrid, i, j, value, this.iigridWidth_, this.iigridHeight_);
            }
        }
        this.prepareGridAxes();
        this.transformProjectedGrid((NcArrayLonLatProjected)nca, bgrid, target);
    }

    @Override
    public void regridInterpolate(NcArray a, double[] target) {
        LOGGER.trace("class {}", (Object)this.getClass().getSimpleName());
        NcArray2D nca = (NcArray2D)a;
        double[] bgrid = this.makeIntermediateGrid((NcArrayLonLatProjected)nca);
        boolean hasBad = nca.hasBadValues();
        NcAxis xAxis = nca.getXAxis();
        NcAxis yAxis = nca.getYAxis();
        double[] xValues = xAxis.getValues();
        double[] yValues = yAxis.getValues();
        double[][] xBounds = xAxis.getBounds();
        double[][] yBounds = yAxis.getBounds();
        int numYs = yValues.length;
        int numXs = xValues.length;
        int lastY = numYs - 1;
        int lastX = numXs - 1;
        int[] srcRow = new int[this.iigridHeight_];
        block0: for (int j = 0; j < this.iigridHeight_; ++j) {
            srcRow[j] = -1;
            for (int jj = 0; jj < lastY; ++jj) {
                if (!(this.prowYY_[j] >= yValues[jj] && this.prowYY_[j] < yValues[jj + 1]) && (!(this.prowYY_[j] <= yValues[jj]) || !(this.prowYY_[j] > yValues[jj + 1]))) continue;
                srcRow[j] = jj;
                continue block0;
            }
        }
        int[] srcCol = new int[this.iigridWidth_];
        block2: for (int i = 0; i < this.iigridWidth_; ++i) {
            srcCol[i] = -1;
            for (int ii = 0; ii < lastX; ++ii) {
                if (!(this.pcolXX_[i] >= xValues[ii] && this.pcolXX_[i] < xValues[ii + 1]) && (!(this.pcolXX_[i] <= xValues[ii]) || !(this.pcolXX_[i] > xValues[ii + 1]))) continue;
                srcCol[i] = ii;
                continue block2;
            }
        }
        LOGGER.trace("prowYY {}, {}", (Object)this.prowYY_[1], (Object)this.prowYY_[this.iigridHeight_ - 12]);
        LOGGER.trace("pcolXX {}, {}", (Object)this.pcolXX_[1], (Object)this.pcolXX_[this.iigridWidth_ - 2]);
        LOGGER.trace("yValues {}, {}", (Object)yValues[0], (Object)yValues[lastY - 1]);
        LOGGER.trace("xValues {}, {}", (Object)xValues[0], (Object)xValues[lastX - 1]);
        LOGGER.trace("srcRow {}, {}", (Object)srcRow[1], (Object)srcRow[this.iigridHeight_ - 2]);
        LOGGER.trace("srcCol {}, {}", (Object)srcCol[1], (Object)srcCol[this.iigridWidth_ - 2]);
        for (int j = 0; j < this.iigridHeight_; ++j) {
            if (srcRow[j] == -1) continue;
            double yPct = (this.prowYY_[j] - yValues[srcRow[j]]) / (yValues[srcRow[j] + 1] - yValues[srcRow[j]]);
            for (int i = 0; i < this.iigridWidth_; ++i) {
                int leftCol = srcCol[i];
                if (leftCol == -1) continue;
                int rightCol = leftCol + 1 < numXs ? leftCol + 1 : 0;
                double leftLon = xValues[leftCol];
                double rightLon = xValues[rightCol];
                double xPct = (this.pcolXX_[i] - leftLon) / (rightLon - leftLon);
                double valTL = nca.valueAt(leftCol, srcRow[j]);
                double valTR = nca.valueAt(rightCol, srcRow[j]);
                double valBL = nca.valueAt(leftCol, srcRow[j] + 1);
                double valBR = nca.valueAt(rightCol, srcRow[j] + 1);
                if (hasBad) {
                    if (nca.isMissingOrInvalid(valTL)) {
                        valTL = Double.NaN;
                    }
                    if (nca.isMissingOrInvalid(valTR)) {
                        valTR = Double.NaN;
                    }
                    if (nca.isMissingOrInvalid(valBL)) {
                        valBL = Double.NaN;
                    }
                    if (nca.isMissingOrInvalid(valBR)) {
                        valBR = Double.NaN;
                    }
                }
                double value = NcGridderUtils.bilinearInterpolate(xPct, yPct, valTL, valTR, valBL, valBR);
                NcGridderUtils.setValue(bgrid, i, j, value, this.iigridWidth_, this.iigridHeight_);
            }
        }
        LOGGER.trace("gridded");
        this.prepareGridAxes();
        this.transformProjectedGrid((NcArrayLonLatProjected)nca, bgrid, target);
    }

    private double[] makeIntermediateGrid(NcArrayLonLatProjected nca) {
        double[] bounds = nca.getBounds();
        this.lProjBound_ = bounds[0];
        this.tProjBound_ = bounds[1];
        this.rProjBound_ = bounds[2];
        this.bProjBound_ = bounds[3];
        LOGGER.trace("input L {}, T {}, R {}, B {}", this.lProjBound_, this.tProjBound_, this.rProjBound_, this.bProjBound_);
        if (this.rProjBound_ < this.lProjBound_) {
            double xx = this.rProjBound_;
            this.rProjBound_ = this.lProjBound_;
            this.lProjBound_ = xx;
        }
        if (this.tProjBound_ < this.bProjBound_) {
            double yy = this.tProjBound_;
            this.tProjBound_ = this.bProjBound_;
            this.bProjBound_ = yy;
        }
        LOGGER.trace("adj input L {}, T {}, R {}, B {}", this.lProjBound_, this.tProjBound_, this.rProjBound_, this.bProjBound_);
        this.constrainIntermediateGridBounds(nca);
        this.iigridWidth_ = 4 * this.gridWidth_;
        this.iigridHeight_ = 4 * this.gridHeight_;
        int iisize = this.iigridWidth_ * this.iigridHeight_;
        double[] bgrid = new double[iisize];
        for (int i = 0; i < iisize; ++i) {
            bgrid[i] = Double.NaN;
        }
        this.pcolXX_ = new double[this.iigridWidth_];
        this.prowYY_ = new double[this.iigridHeight_];
        double projPerXPxl = (this.rProjBound_ - this.lProjBound_) / (double)this.iigridWidth_;
        double projPerYPxl = (this.bProjBound_ - this.tProjBound_) / (double)this.iigridHeight_;
        for (int i = 0; i < this.iigridWidth_; ++i) {
            this.pcolXX_[i] = this.lProjBound_ + ((double)i + 0.5) * projPerXPxl;
        }
        for (int j = 0; j < this.iigridHeight_; ++j) {
            this.prowYY_[j] = this.tProjBound_ + ((double)j + 0.5) * projPerYPxl;
        }
        this.xPxlPerProj_ = (double)this.iigridWidth_ / (this.rProjBound_ - this.lProjBound_);
        this.yPxlPerProj_ = (double)this.iigridHeight_ / (this.bProjBound_ - this.tProjBound_);
        return bgrid;
    }

    protected void constrainIntermediateGridBounds(NcArrayLonLatProjected nca) {
        double outWW = this.rBound_ - this.lBound_;
        double outHH = this.tBound_ - this.bBound_;
        if (Math.abs(outWW) > 270.0) {
            return;
        }
        double leftProjX = Double.NaN;
        double rightProjX = Double.NaN;
        double topProjY = Double.NaN;
        double bottomProjY = Double.NaN;
        int nstep = 40;
        double xdiff = outWW / 40.0;
        double ydiff = outHH / 40.0;
        for (int jj = 0; jj <= 40; ++jj) {
            double llat = this.bBound_ + (double)jj * ydiff;
            for (int ii = 0; ii <= 40; ++ii) {
                double llon = this.lBound_ + (double)ii * xdiff;
                Point2D.Double ppt = nca.transformLL2XY(llon, llat);
                if (ppt == null) continue;
                if (Double.isNaN(leftProjX) || ppt.x < leftProjX) {
                    leftProjX = ppt.x;
                }
                if (Double.isNaN(rightProjX) || ppt.x > rightProjX) {
                    rightProjX = ppt.x;
                }
                if (Double.isNaN(topProjY) || ppt.y > topProjY) {
                    topProjY = ppt.y;
                }
                if (!Double.isNaN(bottomProjY) && !(ppt.y < bottomProjY)) continue;
                bottomProjY = ppt.y;
            }
        }
        if (!Double.isNaN(leftProjX) && !Double.isNaN(rightProjX) && leftProjX > this.lProjBound_) {
            this.lProjBound_ = leftProjX;
        }
        if (rightProjX < this.rProjBound_) {
            this.rProjBound_ = rightProjX;
        }
        if (!Double.isNaN(topProjY) && !Double.isNaN(bottomProjY) && topProjY < this.tProjBound_) {
            this.tProjBound_ = topProjY;
        }
        if (bottomProjY > this.bProjBound_) {
            this.bProjBound_ = bottomProjY;
        }
    }

    protected void transformProjectedGrid(NcArrayLonLatProjected anca, double[] fromArray, double[] toArray) {
        for (int row = 0; row < this.gridHeight_; ++row) {
            double rowLat = this.tBound_ + ((double)row + 0.5) * this.yDegPerPxl_;
            for (int col = 0; col < this.gridWidth_; ++col) {
                double colLon = this.lBound_ + ((double)col + 0.5) * this.xDegPerPxl_;
                Point2D.Double fromXY = anca.transformLL2XY(colLon, rowLat);
                if (fromXY == null) continue;
                double altCol = (fromXY.x - this.lProjBound_) * this.xPxlPerProj_ + 0.5;
                double altRow = (fromXY.y - this.tProjBound_) * this.yPxlPerProj_ + 0.5;
                if ((altCol < 0.0 || altCol >= (double)this.iigridWidth_ || altRow < 0.0 || altRow >= (double)this.iigridHeight_) && colLon > 180.0) {
                    fromXY = anca.transformLL2XY(colLon - 360.0, rowLat);
                    altCol = (fromXY.x - this.lProjBound_) * this.xPxlPerProj_ + 0.5;
                    altRow = (fromXY.y - this.tProjBound_) * this.yPxlPerProj_ + 0.5;
                }
                if ((altCol < 0.0 || altCol >= (double)this.iigridWidth_ || altRow < 0.0 || altRow >= (double)this.iigridHeight_) && colLon < -180.0) {
                    fromXY = anca.transformLL2XY(colLon + 360.0, rowLat);
                    altCol = (fromXY.x - this.lProjBound_) * this.xPxlPerProj_ + 0.5;
                    altRow = (fromXY.y - this.tProjBound_) * this.yPxlPerProj_ + 0.5;
                }
                if (altCol < 0.0 || altCol >= (double)this.iigridWidth_ || altRow < 0.0 || altRow >= (double)this.iigridHeight_) continue;
                int fromIndex = (int)altRow * this.iigridWidth_ + (int)altCol;
                int toIndex = row * this.gridWidth_ + col;
                toArray[toIndex] = fromArray[fromIndex];
            }
        }
    }
}

