/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics;

import gov.nasa.giss.util.AbstractDescribedItem;
import java.util.LinkedHashMap;

public class PaperSizeNew
extends AbstractDescribedItem {
    private static final LinkedHashMap<String, PaperSizeNew> DEFAULTS = new LinkedHashMap(20);
    private static final String[] DEFAULTS_ARRAY;
    private String name_;
    private String description_;
    private float widthMM_;
    private float heightMM_;

    private static void createDefault(String name, String description, float widthMM, float heightMM) {
        DEFAULTS.put(name, new PaperSizeNew(name, description, widthMM, heightMM));
    }

    private PaperSizeNew(String name, String description, float widthMM, float heightMM) {
        this.name_ = name;
        this.description_ = description;
        this.widthMM_ = widthMM;
        this.heightMM_ = heightMM;
    }

    public PaperSizeNew(String description, float widthMM, float heightMM) {
        this.description_ = description;
        this.widthMM_ = widthMM;
        this.heightMM_ = heightMM;
    }

    public float widthMM() {
        return this.widthMM_;
    }

    public float heightMM() {
        return this.heightMM_;
    }

    public int widthPts() {
        return (int)((double)(72.0f * this.widthMM_) / 25.4 + 0.5);
    }

    public int heightPts() {
        return (int)((double)(72.0f * this.heightMM_) / 25.4 + 0.5);
    }

    @Override
    public String name() {
        return this.name_;
    }

    @Override
    public String getDescription() {
        return this.description_;
    }

    public String toString() {
        return this.description_;
    }

    @Override
    public String[] defaults() {
        return DEFAULTS_ARRAY;
    }

    @Override
    public boolean matches(String text) {
        return this.name().equalsIgnoreCase(text) || this.description_.equalsIgnoreCase(text);
    }

    public static PaperSizeNew matching(String str) {
        for (String key : DEFAULTS.keySet()) {
            PaperSizeNew item = DEFAULTS.get(key);
            if (!item.matches(str)) continue;
            return item;
        }
        return null;
    }

    static {
        PaperSizeNew.createDefault("LETTER", "US Letter", 215.9f, 279.4f);
        PaperSizeNew.createDefault("LEGAL", "US Legal", 215.9f, 355.6f);
        PaperSizeNew.createDefault("LEDGER", "US Ledger", 431.8f, 279.4f);
        PaperSizeNew.createDefault("A0", "A0", 1189.0f, 841.0f);
        PaperSizeNew.createDefault("A1", "A1", 841.0f, 594.0f);
        PaperSizeNew.createDefault("A2", "A2", 594.0f, 420.0f);
        PaperSizeNew.createDefault("A3", "A3", 420.0f, 297.0f);
        PaperSizeNew.createDefault("A4", "A4", 297.0f, 210.0f);
        PaperSizeNew.createDefault("A5", "A5", 210.0f, 148.0f);
        PaperSizeNew.createDefault("ANSI_A", "ANSI A", 215.9f, 279.4f);
        PaperSizeNew.createDefault("ANSI_B", "ANSI B", 279.4f, 431.8f);
        PaperSizeNew.createDefault("ANSI_C", "ANSI C", 431.8f, 558.8f);
        PaperSizeNew.createDefault("ANSI_D", "ANSI D", 558.8f, 863.6f);
        PaperSizeNew.createDefault("ANSI_E", "ANSI E", 863.6f, 1117.6f);
        PaperSizeNew.createDefault("ARCH_A", "Arch A", 228.6f, 304.8f);
        PaperSizeNew.createDefault("ARCH_B", "Arch B", 304.8f, 457.2f);
        PaperSizeNew.createDefault("ARCH_C", "Arch C", 457.2f, 609.6f);
        PaperSizeNew.createDefault("ARCH_D", "Arch D", 609.6f, 914.4f);
        PaperSizeNew.createDefault("ARCH_E", "Arch E", 914.4f, 1219.2f);
        PaperSizeNew.createDefault("ARCH_E1", "Arch E1", 762.0f, 1066.8f);
        PaperSizeNew.createDefault("ARCH_E2", "Arch E2", 660.4f, 965.2f);
        PaperSizeNew.createDefault("ARCH_E3", "Arch E3", 685.8f, 990.6f);
        DEFAULTS_ARRAY = DEFAULTS.keySet().toArray(new String[0]);
    }
}

