/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics.plot;

public class PlotPieceMargins
implements Cloneable {
    private int left_;
    private int top_;
    private int right_;
    private int bottom_;

    public PlotPieceMargins() {
        this(0, 0, 0, 0);
    }

    public PlotPieceMargins(int margin) {
        this(margin, margin, margin, margin);
    }

    public PlotPieceMargins(int vmargin, int hmargin) {
        this(vmargin, hmargin, vmargin, hmargin);
    }

    public PlotPieceMargins(int left, int top, int right, int bottom) {
        this.setMargins(left, top, right, bottom);
    }

    public void setMargins(int left, int top, int right, int bottom) {
        this.left_ = left;
        this.top_ = top;
        this.right_ = right;
        this.bottom_ = bottom;
    }

    public int getLeft() {
        return this.left_;
    }

    public int getTop() {
        return this.top_;
    }

    public int getRight() {
        return this.right_;
    }

    public int getBottom() {
        return this.bottom_;
    }

    public String toString() {
        return "[L " + this.left_ + ", T " + this.top_ + ", R " + this.right_ + ", B " + this.bottom_ + "]";
    }

    public Object clone() throws CloneNotSupportedException {
        return new PlotPieceMargins(this.left_, this.top_, this.right_, this.bottom_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        boolean match;
        PlotPieceMargins ppm;
        if (!(obj instanceof PlotPieceMargins)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        PlotPieceMargins plotPieceMargins = ppm = (PlotPieceMargins)obj;
        synchronized (plotPieceMargins) {
            PlotPieceMargins plotPieceMargins2 = this;
            synchronized (plotPieceMargins2) {
                match = ppm.getLeft() == this.left_ && ppm.getTop() == this.top_ && ppm.getRight() == this.right_ && ppm.getBottom() == this.bottom_;
            }
        }
        return match;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

