/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.GlobularProjection2H;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class Apian2TwoH
extends GlobularProjection2H {
    public static final String PROJECTION_NAME = "Apian II (Two-Hemisphere)";
    public static final int PROPERTIES = 0x6000008;
    private static final double RADIUS_FACTOR = 1.5707963267948966;

    public Apian2TwoH(int width, int height) {
        this(width, height, 0, 0);
    }

    public Apian2TwoH(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x6000008, width, height, xmargin, ymargin, 1.5707963267948966);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        Point2D.Double altXY;
        double lambdaRad = this.lonToLambdaRad(lon);
        boolean rightside = Math.abs(lambdaRad) > 1.5707963267948966;
        double altLon = MapUtils.normalizeMP180(lon);
        if (rightside) {
            altLon = altLon < 0.0 ? (altLon += 180.0) : (altLon -= 180.0);
        }
        if ((altXY = this.transformAltLL2XYIgnoreMargins(altLon, lat)) == null) {
            return null;
        }
        double x = rightside ? altXY.x + (double)this.rightCenterX_ : altXY.x + (double)this.leftCenterX_;
        double y = altXY.y;
        return new Point2D.Double(x, y);
    }

    private Point2D.Double transformAltLL2XYIgnoreMargins(double lon, double lat) {
        double lambdaRad = this.lonToLambdaRad(lon);
        if (Math.abs(lambdaRad) > 1.5707963267948966) {
            return null;
        }
        double phiRad = Math.toRadians(lat);
        double x = 0.3183098861837907 * lambdaRad * Math.sqrt(Math.PI * Math.PI - 4.0 * phiRad * phiRad);
        double y = phiRad;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x *= this.rS_, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        boolean leftside = xx < (double)this.outCenterX_;
        double x = leftside ? xx - (double)this.leftCenterX_ : xx - (double)this.rightCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double phiRad = y * this.invRS_;
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = x * Math.PI * this.invRS_ / Math.sqrt(Math.PI * Math.PI - 4.0 * phiRad * phiRad);
        if (Math.abs(lambdaRad) > 1.5707963267948966) {
            return null;
        }
        double lambda = Math.toDegrees(lambdaRad) + (leftside ? 0.0 : 180.0);
        double phi = Math.toDegrees(phiRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Apian2TwoH apian2TwoH = this;
        synchronized (apian2TwoH) {
            double y;
            double phiRad;
            for (int iy = 0; iy < this.dyMax_ && !((phiRad = (y = (double)iy + 0.5) * this.invRS_) > 1.5707963267948966); ++iy) {
                double x;
                double lambdaRad;
                double phiP = Math.toDegrees(phiRad);
                double xFactor = Math.PI * this.invRS_ / Math.sqrt(Math.PI * Math.PI - 4.0 * phiRad * phiRad);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > 1.5707963267948966); ++ix) {
                    double lambdaP = Math.toDegrees(lambdaRad);
                    this.setInvPoints(ix, iy, lambdaP, phiP);
                }
            }
        }
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        for (int i = 0; i < 2; ++i) {
            double lambdaCH = i == 0 ? this.lambdaC_ : this.lambdaC_ + 180.0;
            Point2D.Double east = this.transformLL2XY(lambdaCH + 89.99999, lat);
            Point2D.Double west = this.transformLL2XY(lambdaCH - 89.99999, lat);
            if (east == null && west == null) {
                return;
            }
            GraphicUtils.drawLine(g2d, west, east);
        }
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, double maxLat, String label) {
        double lambda = this.lonToLambda(lon);
        if (Math.abs(lambda) == 90.0) {
            return;
        }
        super.drawMeridian(g2d, lon, maxLat, label);
    }
}

