/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.GlobularProjection2H;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class Fournier1TwoH
extends GlobularProjection2H {
    public static final String PROJECTION_NAME = "Fournier I Globular (Two-Hemisphere)";
    public static final int PROPERTIES = 0x6000020;
    private static final double RADIUS_FACTOR = 1.5707963267948966;

    public Fournier1TwoH(int width, int height) {
        this(width, height, 0, 0);
    }

    public Fournier1TwoH(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x6000020, width, height, xmargin, ymargin, 1.5707963267948966);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        Point2D.Double altXY;
        double lambdaRad = this.lonToLambdaRad(lon);
        boolean rightside = Math.abs(lambdaRad) > 1.5707963267948966;
        double altLon = MapUtils.normalizeMP180(lon);
        if (rightside) {
            altLon = altLon < 0.0 ? (altLon += 180.0) : (altLon -= 180.0);
        }
        if ((altXY = this.transformAltLL2XYIgnoreMargins(altLon, lat)) == null) {
            return null;
        }
        double x = rightside ? altXY.x + (double)this.rightCenterX_ : altXY.x + (double)this.leftCenterX_;
        double y = altXY.y;
        return new Point2D.Double(x, y);
    }

    private Point2D.Double transformAltLL2XYIgnoreMargins(double lon, double lat) {
        double lambdaRad = this.lonToLambdaRad(lon);
        double absLambdaRad = Math.abs(lambdaRad);
        if (absLambdaRad > 1.5707963267948966) {
            return null;
        }
        double phiRad = Math.toRadians(lat);
        double absPhiRad = Math.abs(phiRad);
        double x = 0.0;
        double y = 0.0;
        if (lat == 0.0) {
            x = lambdaRad;
        } else if (absLambdaRad < 1.0E-5 || Math.abs(phiRad) == 1.5707963267948966) {
            y = phiRad;
        } else if (absLambdaRad > 1.5707863267948965) {
            x = lambdaRad * Math.cos(phiRad);
            y = 1.5707963267948966 * Math.sin(phiRad);
        } else {
            double lambdaRad2 = lambdaRad * lambdaRad;
            double fourLambdaRad2 = 4.0 * lambdaRad2;
            double phiRad2 = phiRad * phiRad;
            double sinPhi = Math.sin(absPhiRad);
            double valC = 2.4674011002723395;
            double valP = Math.PI * sinPhi;
            double valS = (2.4674011002723395 - phiRad2) / (valP - 2.0 * absPhiRad);
            double valR = valS - absPhiRad;
            double sqTerm = fourLambdaRad2 * lambdaRad2 + Math.PI * 2 * lambdaRad2 * (2.0 * valS * sinPhi - Math.PI) + Math.PI * Math.PI * valR * valR;
            double cosT = (Math.PI * Math.sqrt(sqTerm) - fourLambdaRad2 * valS) / (valR * (Math.PI * Math.PI - fourLambdaRad2));
            y = valS - valR * cosT;
            x = lambdaRad * Math.sqrt(1.0 - y * y / 2.4674011002723395);
            if (phiRad < 0.0) {
                y = -y;
            }
        }
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x *= this.rS_, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double fguess;
        boolean leftside = xx < (double)this.outCenterX_;
        double x = leftside ? xx - (double)this.leftCenterX_ : xx - (double)this.rightCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double xOverRS = x * this.invRS_;
        double yOverRS = y * this.invRS_;
        double absXOverRS = Math.abs(xOverRS);
        double absYOverRS = Math.abs(yOverRS);
        if (absXOverRS > 1.5707963267948966 || absYOverRS > 1.5707963267948966) {
            return null;
        }
        if (Math.hypot(absXOverRS, absYOverRS) > 1.5707963267948966) {
            return null;
        }
        if (x == 0.0 && y == 0.0) {
            return leftside ? new PointLL(this.lambdaC_, 0.0) : new PointLL(this.lambdaC_ + 180.0, 0.0);
        }
        double lambdaRad = absXOverRS / Math.sqrt(1.0 - absYOverRS * absYOverRS / 2.4674011002723395);
        if (Double.isNaN(lambdaRad) || lambdaRad > 1.5707963267948966) {
            return null;
        }
        if (y == 0.0) {
            return new PointLL(this.lambdaC_ + lambdaRad, 0.0);
        }
        double x2PlusY2 = absXOverRS * absXOverRS + absYOverRS * absYOverRS;
        double phiRad = fguess = Math.abs(lambdaRad) < 0.5183627878423159 ? absYOverRS : Math.asin(absYOverRS / Math.sqrt(x2PlusY2));
        boolean found = false;
        for (int iter = 0; iter < 33; ++iter) {
            double cosPhi = Math.cos(phiRad);
            double sinPhi = Math.sin(phiRad);
            double piSinPhi = Math.PI * sinPhi;
            double s = (2.4674011002723395 - phiRad * phiRad) / (piSinPhi - 2.0 * phiRad);
            double r = s - phiRad;
            double dsdphi = (2.0 * r - Math.PI * s * cosPhi) / (piSinPhi - 2.0 * phiRad);
            double func = x2PlusY2 - 2.4674011002723395 - 2.0 * absYOverRS * s + s * piSinPhi;
            double dfunc = (piSinPhi - 2.0 * absYOverRS) * dsdphi + Math.PI * s * cosPhi;
            double dphiRad = -func / dfunc;
            phiRad += dphiRad;
            if (!(Math.abs(dphiRad) < 1.0E-5)) continue;
            found = true;
            break;
        }
        if (!found || Double.isNaN(phiRad) || Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambda = Math.signum(x) * Math.toDegrees(lambdaRad) + (leftside ? 0.0 : 180.0);
        double phi = Math.signum(y) * Math.toDegrees(phiRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Fournier1TwoH fournier1TwoH = this;
        synchronized (fournier1TwoH) {
            for (int iy = 0; iy < this.dyMax_; ++iy) {
                double x;
                double xOverRs;
                double lambdaRad;
                double y = (double)iy + 0.5;
                double yOverRs = y * this.invRS_;
                double phiRad = y / (double)this.dyMax_ * 1.5707963267948966;
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (xOverRs = (x = (double)ix + 0.5) * this.invRS_) / Math.sqrt(1.0 - yOverRs * yOverRs / 2.4674011002723395)) > 1.5707963267948966); ++ix) {
                    double x2PlusY2 = xOverRs * xOverRs + yOverRs * yOverRs;
                    for (int iter = 0; iter < 33; ++iter) {
                        double cosPhi = Math.cos(phiRad);
                        double sinPhi = Math.sin(phiRad);
                        double piSinPhi = Math.PI * sinPhi;
                        double s = (2.4674011002723395 - phiRad * phiRad) / (piSinPhi - 2.0 * phiRad);
                        double r = s - phiRad;
                        double dsdphi = (2.0 * r - Math.PI * s * cosPhi) / (piSinPhi - 2.0 * phiRad);
                        double func = x2PlusY2 - 2.4674011002723395 - 2.0 * yOverRs * s + s * piSinPhi;
                        double dfunc = (piSinPhi - 2.0 * yOverRs) * dsdphi + Math.PI * s * cosPhi;
                        double dphiRad = -func / dfunc;
                        phiRad += dphiRad;
                        if (Math.abs(dphiRad) < 1.0E-5) break;
                    }
                    double lambdaP = Math.toDegrees(lambdaRad);
                    double phiP = Math.toDegrees(phiRad);
                    this.setInvPoints(ix, iy, lambdaP, phiP);
                }
            }
        }
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        for (int i = 0; i < 2; ++i) {
            double lambdaCH = i == 0 ? this.lambdaC_ : this.lambdaC_ + 180.0;
            Point2D.Double dot1 = this.transformLL2XY(lambdaCH - 89.99999, lat);
            Point2D.Double dot2 = this.transformLL2XY(lambdaCH, lat);
            Point2D.Double dot3 = this.transformLL2XY(lambdaCH + 89.99999, lat);
            GraphicUtils.drawCircularArc(g2d, dot1, dot2, dot3);
        }
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, double maxLat, String label) {
        Point2D.Double dotSP;
        Point2D.Double dotEq = this.transformLL2XY(lon, 0.0);
        if (dotEq == null) {
            return;
        }
        Point2D.Double dotN = this.transformLL2XY(lon, maxLat);
        Point2D.Double dotS = this.transformLL2XY(lon, -maxLat);
        if (dotN == null || dotS == null) {
            return;
        }
        if (Math.abs(dotN.x - dotEq.x) < 1.0E-5) {
            GraphicUtils.drawLine(g2d, dotN, dotS);
            return;
        }
        Point2D.Double dotNP = maxLat > 89.99999 ? dotN : this.transformLL2XY(lon, 90.0);
        Point2D.Double double_ = dotSP = maxLat > 89.99999 ? dotS : this.transformLL2XY(lon, -90.0);
        if (dotNP == null || dotSP == null) {
            return;
        }
        double hw = Math.abs(dotEq.x - dotNP.x);
        double rectX = dotNP.x - hw;
        double rectW = 2.0 * hw;
        double rectH = dotSP.y - dotNP.y;
        if (dotEq.x > dotN.x) {
            GraphicUtils.drawEllipticArc(g2d, rectX, dotNP.y, rectW, rectH, dotS, dotN);
        } else {
            GraphicUtils.drawEllipticArc(g2d, rectX, dotNP.y, rectW, rectH, dotN, dotS);
        }
    }
}

