/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.LonLatRotator;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.ProjGraphicUtils;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GnomonicCSOblique
extends AbstractProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Gnomonic Cubed Sphere Oblique";
    public static final int PROPERTIES = 0x8000000;
    private static final double MAX_X_OVER_RS = 4.0;
    private static final double MAX_Y_OVER_RS = 3.0;
    private static final int FACE1 = 1;
    private static final int FACE2 = 2;
    private static final int FACE3 = 3;
    private static final int FACE4 = 4;
    private static final int TOP = 5;
    private static final int BOTTOM = 6;
    private static final double LON_SHIFT = 0.0;
    private int npFace_ = 2;
    private int spFace_ = 2;
    private double twoRS_;
    private double threeRS_;
    private double fourRS_;
    private LonLatRotator rotMatrices_ = new LonLatRotator(this.lambdaC_ + 0.0, this.phiC_);

    public GnomonicCSOblique(int width, int height) {
        this(width, height, 0, 0);
    }

    public GnomonicCSOblique(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x8000000, width, height, xmargin, ymargin, 4.0, 3.0);
        this.finishConstruction();
    }

    @Override
    public boolean isRecenterableLat() {
        return true;
    }

    @Override
    public void setCenter(double lon, double lat) {
        super.setCenter(lon, lat);
        if (this.rotMatrices_ != null) {
            this.rotMatrices_.setAngles(this.lambdaC_ + 0.0, this.phiC_);
        }
    }

    @Override
    protected final void finishScaling() {
        this.twoRS_ = 2.0 * this.rS_;
        this.threeRS_ = 3.0 * this.rS_;
        this.fourRS_ = 4.0 * this.rS_;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double[] llP = this.rotMatrices_.rotate(lon + 0.0, lat);
        double lambdaRad = Math.toRadians(llP[0]);
        double phiRad = Math.toRadians(llP[1]);
        double cosPhiRad = Math.cos(phiRad);
        double xx = Math.cos(lambdaRad) * cosPhiRad;
        double yy = Math.sin(lambdaRad) * cosPhiRad;
        double zz = Math.sin(phiRad);
        double absXX = Math.abs(xx);
        double absYY = Math.abs(yy);
        double absZZ = Math.abs(zz);
        double ratio = 0.0;
        int face = 0;
        if (absXX >= absYY && absXX >= absZZ) {
            ratio = 1.0 / absXX;
            face = xx > 0.0 ? 2 : 4;
        } else if (absYY >= absXX && absYY >= absZZ) {
            ratio = 1.0 / absYY;
            face = yy > 0.0 ? 3 : 1;
        } else {
            ratio = 1.0 / absZZ;
            face = zz > 0.0 ? 5 : 6;
        }
        xx *= ratio;
        yy *= ratio;
        zz *= ratio;
        switch (face) {
            case 1: {
                yy = -2.0 + xx;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                yy = 2.0 - xx;
                break;
            }
            case 4: {
                yy = 4.0 - yy;
                break;
            }
            case 5: {
                switch (this.npFace_) {
                    case 1: {
                        double tt = xx;
                        xx = -yy;
                        yy = tt - 2.0;
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        double tt = xx;
                        xx = yy;
                        yy = -tt + 2.0;
                        break;
                    }
                    case 4: {
                        xx = -xx;
                        yy = -yy + 4.0;
                        break;
                    }
                }
                zz = 2.0 - xx;
                break;
            }
            case 6: {
                switch (this.spFace_) {
                    case 1: {
                        double tt = xx;
                        xx = -yy;
                        yy = tt - 2.0;
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        double tt = xx;
                        xx = yy;
                        yy = -tt + 2.0;
                        break;
                    }
                    case 4: {
                        xx = -xx;
                        yy = -yy + 4.0;
                        break;
                    }
                }
                zz = -2.0 + xx;
                break;
            }
        }
        double x = (double)this.outCenterX_ + (yy -= 1.0) * this.rS_;
        double y = (double)this.outCenterY_ - zz * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xxx, double yyy) {
        double x = xxx + this.rS_ - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yyy;
        double xOverRS = x * this.invRS_;
        double yOverRS = y * this.invRS_;
        if (Math.abs(yOverRS) <= 1.0) {
            if (xOverRS < -3.0 || xOverRS > 5.0) {
                return null;
            }
            int face = 2;
            double yy = xOverRS;
            double zz = yOverRS;
            if (xOverRS < -1.0) {
                face = 1;
                yy += 2.0;
            } else if (xOverRS > 3.0) {
                face = 4;
                yy -= 4.0;
            } else if (xOverRS > 1.0) {
                face = 3;
                yy -= 2.0;
            }
            double rhoQ = Math.sqrt(yy * yy + zz * zz + 1.0);
            double xx = Math.sqrt(1.0 - (yy /= rhoQ) * yy - (zz /= rhoQ) * zz);
            double lambdaPRad = Math.atan2(yy, xx);
            double lambdaP = Math.toDegrees(lambdaPRad);
            double phiPRad = Math.asin(zz);
            double phiP = Math.toDegrees(phiPRad);
            if (face == 3) {
                lambdaP += 90.0;
            } else if (face == 4) {
                lambdaP += 180.0;
            } else if (face == 1) {
                lambdaP -= 90.0;
            }
            double[] ll = this.rotMatrices_.inverse(lambdaP, phiP);
            return new PointLL(ll[0] - 0.0, ll[1]);
        }
        if (Math.abs(yOverRS) <= 3.0) {
            double yy = xOverRS;
            int switchface = yOverRS > 0.0 ? this.npFace_ : this.spFace_;
            switch (switchface) {
                case 1: {
                    if (xOverRS < -3.0 || xOverRS > -1.0) {
                        return null;
                    }
                    yy = xOverRS + 2.0;
                    break;
                }
                case 2: {
                    if (xOverRS < -1.0 || xOverRS > 1.0) {
                        return null;
                    }
                    yy = xOverRS;
                    break;
                }
                case 3: {
                    if (xOverRS < 1.0 || xOverRS > 3.0) {
                        return null;
                    }
                    yy = xOverRS - 2.0;
                    break;
                }
                case 4: {
                    if (xOverRS < 3.0 || xOverRS > 5.0) {
                        return null;
                    }
                    yy = xOverRS - 4.0;
                    break;
                }
            }
            double xx = 2.0 - Math.abs(yOverRS);
            double rhoQ = Math.sqrt(yy * yy + xx * xx + 1.0);
            double zz = Math.sqrt(1.0 - (yy /= rhoQ) * yy - (xx /= rhoQ) * xx);
            double lambdaPRad = Math.atan2(yy, xx);
            double lambdaP = Math.toDegrees(lambdaPRad);
            double phiPRad = Math.asin(zz);
            double phiP = Math.toDegrees(phiPRad);
            switch (switchface) {
                case 1: {
                    lambdaP -= 90.0;
                    break;
                }
                case 3: {
                    lambdaP += 90.0;
                    break;
                }
                case 4: {
                    lambdaP += 180.0;
                    break;
                }
            }
            if (yOverRS < 0.0) {
                phiP *= -1.0;
            }
            double[] ll = this.rotMatrices_.inverse(lambdaP, phiP);
            return new PointLL(ll[0] - 0.0, ll[1]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        GnomonicCSOblique gnomonicCSOblique = this;
        synchronized (gnomonicCSOblique) {
            int iy = -((int)this.rS_);
            while ((double)iy < this.threeRS_) {
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                int ix = 0;
                while ((double)ix < this.rS_) {
                    double[] ll;
                    double phiP;
                    double phiPRad;
                    double lambdaP;
                    double lambdaPRad;
                    double xx;
                    double rhoQ;
                    double zz;
                    double yy;
                    double x = (double)ix + 0.5;
                    double xOverRS = x * this.invRS_;
                    if (yOverRS <= 1.0) {
                        yy = xOverRS;
                        zz = yOverRS;
                        rhoQ = Math.sqrt(yy * yy + zz * zz + 1.0);
                        xx = Math.sqrt(1.0 - (yy /= rhoQ) * yy - (zz /= rhoQ) * zz);
                        lambdaPRad = Math.atan2(yy, xx);
                        lambdaP = Math.toDegrees(lambdaPRad);
                        phiPRad = Math.asin(zz);
                        phiP = Math.toDegrees(phiPRad);
                        ll = this.rotMatrices_.inverse(lambdaP, phiP);
                        this.setFacePoint(ix, iy, ll[0], ll[1]);
                    } else {
                        yy = xOverRS;
                        xx = 2.0 - yOverRS;
                        rhoQ = Math.sqrt(yy * yy + xx * xx + 1.0);
                        zz = Math.sqrt(1.0 - (yy /= rhoQ) * yy - (xx /= rhoQ) * xx);
                        lambdaPRad = Math.atan2(yy, xx);
                        lambdaP = Math.toDegrees(lambdaPRad);
                        phiPRad = Math.asin(zz);
                        phiP = Math.toDegrees(phiPRad);
                        ll = this.rotMatrices_.inverse(lambdaP, phiP);
                        this.setPolePoint(ix, iy, ll[0], ll[1]);
                    }
                    ++ix;
                }
                ++iy;
            }
        }
    }

    private void setFacePoint(int ix, int iy, double dlambda, double phi) {
        int ixM = -ix - 1;
        this.setInvPoint((int)((double)ix - this.threeRS_), iy, dlambda - 90.0, phi);
        this.setInvPoint((int)((double)ixM - this.threeRS_), iy, -dlambda - 90.0, phi);
        this.setInvPoint((int)((double)ix - this.rS_), iy, dlambda, phi);
        this.setInvPoint((int)((double)ixM - this.rS_), iy, -dlambda, phi);
        this.setInvPoint((int)((double)ix + this.rS_), iy, dlambda + 90.0, phi);
        this.setInvPoint((int)((double)ixM + this.rS_), iy, -dlambda + 90.0, phi);
        this.setInvPoint((int)((double)ix + this.threeRS_), iy, dlambda + 180.0, phi);
        this.setInvPoint((int)((double)ixM + this.threeRS_), iy, -dlambda + 180.0, phi);
    }

    private void setPolePoint(int ix, int iy, double dlambda, double phi) {
        int ixM = -ix - 1;
        int iyM = -iy - 1;
        switch (this.npFace_) {
            case 1: {
                this.setInvPoint((int)((double)ix - this.threeRS_), iy, dlambda - 90.0, phi);
                this.setInvPoint((int)((double)ixM - this.threeRS_), iy, -dlambda - 90.0, phi);
                break;
            }
            case 2: {
                this.setInvPoint((int)((double)ix - this.rS_), iy, dlambda, phi);
                this.setInvPoint((int)((double)ixM - this.rS_), iy, -dlambda, phi);
                break;
            }
            case 3: {
                this.setInvPoint((int)((double)ix + this.rS_), iy, dlambda + 90.0, phi);
                this.setInvPoint((int)((double)ixM + this.rS_), iy, -dlambda + 90.0, phi);
                break;
            }
            case 4: {
                this.setInvPoint((int)((double)ix + this.threeRS_), iy, dlambda + 180.0, phi);
                this.setInvPoint((int)((double)ixM + this.threeRS_), iy, -dlambda + 180.0, phi);
                break;
            }
        }
        switch (this.spFace_) {
            case 1: {
                this.setInvPoint((int)((double)ix - this.threeRS_), iyM, dlambda - 90.0, -phi);
                this.setInvPoint((int)((double)ixM - this.threeRS_), iyM, -dlambda - 90.0, -phi);
                break;
            }
            case 2: {
                this.setInvPoint((int)((double)ix - this.rS_), iyM, dlambda, -phi);
                this.setInvPoint((int)((double)ixM - this.rS_), iyM, -dlambda, -phi);
                break;
            }
            case 3: {
                this.setInvPoint((int)((double)ix + this.rS_), iyM, dlambda + 90.0, -phi);
                this.setInvPoint((int)((double)ixM + this.rS_), iyM, -dlambda + 90.0, -phi);
                break;
            }
            case 4: {
                this.setInvPoint((int)((double)ix + this.threeRS_), iyM, dlambda + 180.0, -phi);
                this.setInvPoint((int)((double)ixM + this.threeRS_), iyM, -dlambda + 180.0, -phi);
                break;
            }
        }
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        Graphics2D g2x = (Graphics2D)g2d.create();
        g2x.setStroke(ProjGraphicUtils.getSquareMiterStroke(g2x.getStroke()));
        Path2D.Double path = new Path2D.Double();
        path.moveTo((double)this.outCenterX_ - this.fourRS_, (double)this.outCenterY_ - this.rS_);
        switch (this.npFace_) {
            case 1: {
                path.lineTo((double)this.outCenterX_ - this.fourRS_, (double)this.outCenterY_ - this.threeRS_);
                path.lineTo((double)this.outCenterX_ - this.twoRS_, (double)this.outCenterY_ - this.threeRS_);
                path.lineTo((double)this.outCenterX_ - this.twoRS_, (double)this.outCenterY_ - this.rS_);
                break;
            }
            case 2: {
                path.lineTo((double)this.outCenterX_ - this.twoRS_, (double)this.outCenterY_ - this.rS_);
                path.lineTo((double)this.outCenterX_ - this.twoRS_, (double)this.outCenterY_ - this.threeRS_);
                path.lineTo(this.outCenterX_, (double)this.outCenterY_ - this.threeRS_);
                path.lineTo(this.outCenterX_, (double)this.outCenterY_ - this.rS_);
                break;
            }
            case 3: {
                path.lineTo(this.outCenterX_, (double)this.outCenterY_ - this.rS_);
                path.lineTo(this.outCenterX_, (double)this.outCenterY_ - this.threeRS_);
                path.lineTo((double)this.outCenterX_ + this.twoRS_, (double)this.outCenterY_ - this.threeRS_);
                path.lineTo((double)this.outCenterX_ + this.twoRS_, (double)this.outCenterY_ - this.rS_);
                break;
            }
            case 4: {
                path.lineTo((double)this.outCenterX_ + this.twoRS_, (double)this.outCenterY_ - this.rS_);
                path.lineTo((double)this.outCenterX_ + this.twoRS_, (double)this.outCenterY_ - this.threeRS_);
                path.lineTo((double)this.outCenterX_ + this.fourRS_, (double)this.outCenterY_ - this.threeRS_);
                break;
            }
        }
        path.lineTo((double)this.outCenterX_ + this.fourRS_, (double)this.outCenterY_ - this.rS_);
        path.lineTo((double)this.outCenterX_ + this.fourRS_, (double)this.outCenterY_ + this.rS_);
        switch (this.spFace_) {
            case 1: {
                path.lineTo((double)this.outCenterX_ - this.twoRS_, (double)this.outCenterY_ + this.rS_);
                path.lineTo((double)this.outCenterX_ - this.twoRS_, (double)this.outCenterY_ + this.threeRS_);
                path.lineTo((double)this.outCenterX_ - this.fourRS_, (double)this.outCenterY_ + this.threeRS_);
                break;
            }
            case 2: {
                path.lineTo(this.outCenterX_, (double)this.outCenterY_ + this.rS_);
                path.lineTo(this.outCenterX_, (double)this.outCenterY_ + this.threeRS_);
                path.lineTo((double)this.outCenterX_ - this.twoRS_, (double)this.outCenterY_ + this.threeRS_);
                path.lineTo((double)this.outCenterX_ - this.twoRS_, (double)this.outCenterY_ + this.rS_);
                break;
            }
            case 3: {
                path.lineTo((double)this.outCenterX_ + this.twoRS_, (double)this.outCenterY_ + this.rS_);
                path.lineTo((double)this.outCenterX_ + this.twoRS_, (double)this.outCenterY_ + this.threeRS_);
                path.lineTo(this.outCenterX_, (double)this.outCenterY_ + this.threeRS_);
                path.lineTo(this.outCenterX_, (double)this.outCenterY_ + this.rS_);
                break;
            }
            case 4: {
                path.lineTo((double)this.outCenterX_ + this.fourRS_, (double)this.outCenterY_ + this.threeRS_);
                path.lineTo((double)this.outCenterX_ + this.twoRS_, (double)this.outCenterY_ + this.threeRS_);
                path.lineTo((double)this.outCenterX_ + this.twoRS_, (double)this.outCenterY_ + this.rS_);
                break;
            }
        }
        path.lineTo((double)this.outCenterX_ - this.fourRS_, (double)this.outCenterY_ + this.rS_);
        path.closePath();
        g2x.draw(path);
        g2x.dispose();
    }
}

