/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.map.LonLatRotator;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.ProjGraphicUtils;
import gov.nasa.giss.math.Elliptic;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpilhausWorldOceanInASquare
extends AbstractProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Spilhaus World Ocean in a Square";
    public static final int PROPERTIES = 4096;
    private static final double MODULUS = 0.7071067811865476;
    private static final double MODULUS2 = 0.5000000000000001;
    private static final double CAP_K = 1.854074677301372;
    private static final double MAX_X_OVER_RS = 1.854074677301372;
    private static final double MAX_Y_OVER_RS = 1.854074677301372;
    private static final double CENTER_LON = 66.94970198;
    private static final double CENTER_LAT = -49.56371678;
    private static final double AZIMUTH = 40.17823482;
    private LonLatRotator rotMatrices_ = new LonLatRotator(66.94970198, -49.56371678, 40.17823482);
    private double kRS_;

    public SpilhausWorldOceanInASquare(int width, int height) {
        this(width, height, 0, 0);
    }

    public SpilhausWorldOceanInASquare(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4096, width, height, xmargin, ymargin, 1.854074677301372, 1.854074677301372);
        this.finishConstruction();
    }

    @Override
    protected final void finishScaling() {
        this.kRS_ = 1.854074677301372 * this.rS_;
    }

    @Override
    public boolean isRecenterableLon() {
        return false;
    }

    @Override
    public boolean isRecenterableLat() {
        return false;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double tt;
        double[] llP = this.rotMatrices_.rotate(lon, lat);
        double lonP = llP[0];
        double latP = llP[1];
        if (latP > 89.99999) {
            return new Point2D.Double((double)this.outCenterX_ + this.kRS_, (double)this.outCenterY_ - this.kRS_);
        }
        if (latP < -89.99999) {
            return new Point2D.Double((double)this.outCenterX_ - this.kRS_, (double)this.outCenterY_ + this.kRS_);
        }
        double lambdaRad = Math.toRadians(lonP);
        double absLambdaRad = Math.abs(lambdaRad);
        double sinHalfLambda = Math.sin(0.5 * absLambdaRad);
        double phiRad = Math.toRadians(latP);
        double absPhiRad = Math.abs(phiRad);
        double sinPhiP = Math.tan(0.5 * absPhiRad);
        double cosPhiP = Math.sqrt(1.0 - sinPhiP * sinPhiP);
        double cosA = cosPhiP * sinHalfLambda;
        double cosB = sinPhiP;
        double sinA = Math.sqrt(1.0 - cosA * cosA);
        double sinB = Math.sqrt(1.0 - cosB * cosB);
        double cosAcosB = cosA * cosB;
        double sinAsinB = sinA * sinB;
        double sinM = Math.sqrt(1.0 + cosAcosB - sinAsinB);
        double sinN = Math.sqrt(1.0 - cosAcosB - sinAsinB);
        double mmm = Math.asin(sinM);
        double nnn = Math.asin(sinN);
        if (sinPhiP + cosA < 0.0) {
            mmm = -mmm;
        }
        if (sinPhiP - cosA < 0.0) {
            nnn = -nnn;
        }
        double x = Elliptic.ellipticF(mmm, 0.5000000000000001);
        double y = Elliptic.ellipticF(nnn, 0.5000000000000001);
        if (lambdaRad < 0.0) {
            tt = x;
            x = y;
            y = tt;
        }
        if (phiRad < 0.0) {
            tt = x;
            x = -y;
            y = -tt;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double phi;
        double lambda;
        double yOverRS;
        double xOverRS;
        boolean bot;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double absx = Math.abs(x);
        double absy = Math.abs(y);
        if (absx > this.kRS_ || absy > this.kRS_) {
            return null;
        }
        boolean top = y > 0.0 && absy > absx;
        boolean left = x < 0.0 && absx > absy;
        boolean bl = bot = y < 0.0 && absy > absx;
        if (top) {
            xOverRS = y * this.invRS_;
            yOverRS = x * this.invRS_;
        } else if (left) {
            xOverRS = -x * this.invRS_;
            yOverRS = -y * this.invRS_;
        } else if (bot) {
            xOverRS = -y * this.invRS_;
            yOverRS = -x * this.invRS_;
        } else {
            xOverRS = x * this.invRS_;
            yOverRS = y * this.invRS_;
        }
        double[] absLL = this.transformXYrs2LL(xOverRS, yOverRS);
        if (absLL == null || Double.isNaN(absLL[0]) || Double.isNaN(absLL[1])) {
            return null;
        }
        if (top) {
            lambda = -absLL[0];
            phi = absLL[1];
        } else if (left) {
            lambda = -absLL[0];
            phi = -absLL[1];
        } else if (bot) {
            lambda = absLL[0];
            phi = -absLL[1];
        } else {
            lambda = absLL[0];
            phi = absLL[1];
        }
        double[] ll = this.rotMatrices_.inverse(lambda, phi);
        return new PointLL(ll[0], ll[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        SpilhausWorldOceanInASquare spilhausWorldOceanInASquare = this;
        synchronized (spilhausWorldOceanInASquare) {
            block3: for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double absy = Math.abs(y);
                double yOverRS = y * this.invRS_;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    if (absy > x) continue;
                    double xOverRS = x * this.invRS_;
                    double[] llRot = this.transformXYrs2LL(xOverRS, yOverRS);
                    if (llRot == null) continue block3;
                    this.setInvPoints(ix, iy, llRot);
                }
            }
        }
    }

    protected void setInvPoints(int ix, int iy, double[] llRot) {
        int col = ix;
        int colF = -ix - 1;
        int row = -iy - 1;
        int rowF = iy;
        double[] ll = this.rotMatrices_.inverse(llRot[0], llRot[1]);
        this.setInverseArrayLocation(this.outCenterX_ + col, this.outCenterY_ + row, ll[0], ll[1]);
        ll = this.rotMatrices_.inverse(-llRot[0], llRot[1]);
        this.setInverseArrayLocation(this.outCenterX_ + rowF, this.outCenterY_ + colF, ll[0], ll[1]);
        ll = this.rotMatrices_.inverse(-llRot[0], -llRot[1]);
        this.setInverseArrayLocation(this.outCenterX_ + colF, this.outCenterY_ + rowF, ll[0], ll[1]);
        ll = this.rotMatrices_.inverse(llRot[0], -llRot[1]);
        this.setInverseArrayLocation(this.outCenterX_ + row, this.outCenterY_ + col, ll[0], ll[1]);
    }

    private double[] transformXYrs2LL(double x, double y) {
        double cosB;
        double[] jacobiM = Elliptic.jacobiSnCnDn(x, 0.5000000000000001);
        double[] jacobiN = Elliptic.jacobiSnCnDn(y, 0.5000000000000001);
        double sinM = jacobiM[0];
        double sinN = jacobiN[0];
        double sinSqM = sinM * sinM;
        double sinSqN = sinN * sinN;
        double sinAsinB = -0.5 * (sinSqM + sinSqN - 2.0);
        double cosAcosB = 0.5 * (sinSqM - sinSqN);
        double cosAplusB = cosAcosB - sinAsinB;
        double cosAminusB = cosAcosB + sinAsinB;
        double aPlusB = Math.acos(cosAplusB);
        double aMinusB = y >= 0.0 ? Math.acos(cosAminusB) : -Math.acos(cosAminusB);
        double a = 0.5 * (aPlusB + aMinusB);
        double b = 0.5 * (aPlusB - aMinusB);
        double cosA = Math.cos(a);
        double sinPhiP = cosB = Math.cos(b);
        double phiPRad = Math.asin(sinPhiP);
        double cosPhiP = Math.cos(phiPRad);
        double phiRad = 2.0 * Math.atan(sinPhiP);
        if (phiRad > 1.5707963267948966) {
            return null;
        }
        double sinHalfLambda = cosA / cosPhiP;
        double lambdaRad = 2.0 * Math.asin(sinHalfLambda);
        if (lambdaRad > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new double[]{lambda, phi};
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        Path2D.Double path = new Path2D.Double();
        path.moveTo((double)this.outCenterX_ + this.kRS_, (double)this.outCenterY_ - this.kRS_);
        path.lineTo((double)this.outCenterX_ + this.kRS_, (double)this.outCenterY_ + this.kRS_);
        path.lineTo((double)this.outCenterX_ - this.kRS_, (double)this.outCenterY_ + this.kRS_);
        path.lineTo((double)this.outCenterX_ - this.kRS_, (double)this.outCenterY_ - this.kRS_);
        path.closePath();
        Graphics2D g2x = (Graphics2D)g2d.create();
        g2x.setStroke(ProjGraphicUtils.getSquareMiterStroke(g2x.getStroke()));
        g2x.draw(path);
        g2x.dispose();
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, double maxLat, String label) {
        Point2D.Double dot;
        double lat;
        ArrayList<Point2D.Double> ptlist = new ArrayList<Point2D.Double>(400);
        Point2D.Double lastdot = new Point2D.Double(0.0, 0.0);
        double d = lat = maxLat < -89.99999 ? -89.99999 : -maxLat;
        while (lat < maxLat) {
            dot = this.transformLL2XY(lon, lat);
            if (dot == null) {
                this.drawCurve(g2d, ptlist);
            } else {
                if (ptlist.size() != 0 && dot.distance(lastdot) > 25.0) {
                    this.drawCurve(g2d, ptlist);
                }
                ptlist.add(dot);
                lastdot.setLocation(dot.x, dot.y);
            }
            double absLat = Math.abs(lat);
            if (absLat >= maxLat - 1.0) {
                lat += 0.1;
                continue;
            }
            lat += 0.3;
        }
        Point2D.Double double_ = dot = lat < 89.99999 ? this.transformLL2XY(lon, maxLat) : null;
        if (dot == null) {
            this.drawCurve(g2d, ptlist);
        } else if (ptlist.size() != 0) {
            if (dot.distance(lastdot) > 25.0) {
                this.drawCurve(g2d, ptlist);
            } else {
                ptlist.add(new Point2D.Double(dot.x, dot.y));
                this.drawCurve(g2d, ptlist);
            }
        }
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        Point2D.Double dot;
        ArrayList<Point2D.Double> ptlist = new ArrayList<Point2D.Double>(800);
        Point2D.Double lastdot = new Point2D.Double(0.0, 0.0);
        double lon = -179.99999;
        while (lon < 179.99999) {
            dot = this.transformLL2XY(lon, lat);
            if (dot == null) {
                this.drawCurve(g2d, ptlist);
                lon += 0.1;
                continue;
            }
            if (ptlist.size() != 0 && dot.distance(lastdot) > 25.0) {
                this.drawCurve(g2d, ptlist);
            }
            ptlist.add(dot);
            lastdot.setLocation(dot.x, dot.y);
            lon += 0.3;
        }
        dot = this.transformLL2XY(179.99999, lat);
        if (dot == null) {
            this.drawCurve(g2d, ptlist);
        } else if (ptlist.size() != 0) {
            if (dot.distance(lastdot) > 25.0) {
                this.drawCurve(g2d, ptlist);
            } else {
                ptlist.add(new Point2D.Double(dot.x, dot.y));
                this.drawCurve(g2d, ptlist);
            }
        }
    }

    private void drawCurve(Graphics2D g2d, ArrayList<Point2D.Double> ptlist) {
        Bezier bcurve;
        if (ptlist.size() > 1 && (bcurve = new Bezier(false, ptlist)) != null) {
            bcurve.draw(g2d);
        }
        ptlist.clear();
    }
}

