/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action;

import gov.nasa.giss.panoply.dialog.PanLinkDimensionsDialog;
import gov.nasa.giss.panoply.plotui.PanArrayControls;
import gov.nasa.giss.panoply.plotui.PanArraySlicer;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.util.PanProperties;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class PanLinkDimensionsAction
extends AbstractAction {
    private static final String ACTION_NAME = PanProperties.MENU_PROPS.getString("link-dimensions");
    private PanArrayControls controls_;

    public PanLinkDimensionsAction(PanArrayControls controls) {
        super(ACTION_NAME);
        this.controls_ = controls;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.controls_.isLinked()) {
            this.controls_.resetLinkedDimensions();
            return;
        }
        if (this.controls_.getPossibleLinkCount() == 1) {
            this.controls_.linkDimensions();
            return;
        }
        PanPlotFrame pframe = this.controls_.getPlotFrame();
        PanLinkDimensionsDialog dlog = new PanLinkDimensionsDialog(pframe);
        dlog.setVisible(true);
        this.controls_.resetLinkedDimensions();
        if (dlog.isSuccessful()) {
            PanArraySlicer[] companions = dlog.getSlicers();
            this.controls_.linkDimensions(companions[0], companions[1]);
        } else {
            this.controls_.resetLinkedDimensions();
        }
        dlog.dispose();
    }
}

