/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action;

import gov.nasa.giss.data.nc.NcCatalog;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.panoply.prefs.PanBookmarkNode;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class PanRemoveOneSourceAction
extends AbstractAction {
    private final PanSourcesFrame parent_;

    public PanRemoveOneSourceAction(PanSourcesFrame f) {
        super(PanProperties.MENU_PROPS.getString("clear"));
        this.parent_ = f;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TreeTableNode node = this.parent_.getSelectedNode();
        if (node == null) {
            return;
        }
        if (node instanceof NcDataset) {
            this.parent_.getSubpanel(PanSourcesFrame.Subpanel.DATASETS).removeNode((NcDataset)node);
        } else if (node instanceof NcCatalog) {
            this.parent_.getSubpanel(PanSourcesFrame.Subpanel.CATALOGS).removeNode((NcCatalog)node);
        } else if (node instanceof PanBookmarkNode) {
            this.parent_.getSubpanel(PanSourcesFrame.Subpanel.BOOKMARKS).removeNode((PanBookmarkNode)node);
        }
    }
}

