/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.io;

import gov.nasa.giss.panoply.ui.PanFrame;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.text.IntegerDocument;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.label.MultiLineLabel;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanGribTableOptionsDialog
extends JDialog {
    private final PanFrame pframe_;
    private JTextField centerTF_;
    private JTextField subcenterTF_;
    private JTextField versionTF_;
    private JButton okayBtn_;
    private JButton cancelBtn_;
    private boolean success_;

    public PanGribTableOptionsDialog(PanFrame pframe) {
        super(pframe, "GRIB-1 Table Options", true);
        this.pframe_ = pframe;
        this.setResizable(false);
        this.createLayout();
        this.attachListeners();
    }

    private void createLayout() {
        MultiLineLabel messageLabel = new MultiLineLabel("Enter the center, subcenter and version for GRIB-1 datasets to which this table should be applied. Subcenter and version IDs may be set to the wildcard. Otherwise, all IDs should be between 1 and 255.", 72, 2);
        this.centerTF_ = new JTextField(new IntegerDocument(), "1", 6);
        this.subcenterTF_ = new JTextField(new IntegerDocument(), "-1", 6);
        this.versionTF_ = new JTextField(new IntegerDocument(), "-1", 6);
        this.centerTF_.setHorizontalAlignment(4);
        this.subcenterTF_.setHorizontalAlignment(4);
        this.versionTF_.setHorizontalAlignment(4);
        this.subcenterTF_.setMinimumSize(this.subcenterTF_.getPreferredSize());
        this.okayBtn_ = new JButton("Okay");
        this.cancelBtn_ = new JButton("Cancel");
        QuickBox buttonBox = PlatformUtils.isMacintosh() ? QuickBox.createRightBox(this.cancelBtn_, this.okayBtn_) : QuickBox.createRightBox(this.okayBtn_, this.cancelBtn_);
        JPanel contentPanel = new JPanel();
        FlexingGridLayout fgl = new FlexingGridLayout(4, 7, 0, 2);
        fgl.setColumnWeight(3, 9999.0f);
        contentPanel.setLayout(fgl);
        contentPanel.setBorder(PanGuiUtils.STD_BORDER);
        contentPanel.add((Component)messageLabel, new FGConstraint(0, 0, 4, 1, 1.0, 0.5));
        contentPanel.add((Component)new JLabel("Center:\u2009"), new FGConstraint(0, 2));
        contentPanel.add((Component)this.centerTF_, new FGConstraint(1, 2));
        contentPanel.add((Component)new JLabel("Subcenter:\u2009"), new FGConstraint(0, 3));
        contentPanel.add((Component)this.subcenterTF_, new FGConstraint(1, 3));
        contentPanel.add((Component)new JLabel(" (-1 = wildcard)"), new FGConstraint(2, 3));
        contentPanel.add((Component)new JLabel("Version:\u2009"), new FGConstraint(0, 4));
        contentPanel.add((Component)this.versionTF_, new FGConstraint(1, 4));
        contentPanel.add((Component)new JLabel(" (-1 = wildcard)"), new FGConstraint(2, 4));
        contentPanel.add((Component)buttonBox, new FGConstraint(0, 6, 4, 1, 1.0, 0.5));
        this.getContentPane().add(contentPanel);
        this.getRootPane().setDefaultButton(this.okayBtn_);
        GuiUtils.fixDefaultButtonColor(this.okayBtn_);
        this.pack();
        Rectangle rr = this.pframe_.getBounds();
        Dimension psize = this.getContentPane().getPreferredSize();
        int x = (rr.width - psize.width) / 2;
        int y = (rr.height - psize.height) / 2;
        this.setLocation(rr.x + x, rr.y + y);
    }

    private void attachListeners() {
        this.okayBtn_.addActionListener(e -> {
            this.success_ = true;
            this.setVisible(false);
        });
        this.cancelBtn_.addActionListener(e -> this.setVisible(false));
    }

    public boolean isSuccessful() {
        return this.success_;
    }

    public int[] getResponses() {
        int c = ((IntegerDocument)this.centerTF_.getDocument()).getValue();
        int s = ((IntegerDocument)this.subcenterTF_.getDocument()).getValue();
        int v = ((IntegerDocument)this.versionTF_.getDocument()).getValue();
        return new int[]{c, s, v};
    }
}

