/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.map.overlay.MapOverlay;
import gov.nasa.giss.map.overlay.OverlayResourceList;
import gov.nasa.giss.panoply.prefsui.PanPrefsTableModel;
import gov.nasa.giss.panoply.util.PanResourceUtils;
import gov.nasa.giss.util.reslist.ResourceListDataEvent;
import gov.nasa.giss.util.reslist.ResourceListDataListener;
import gov.nasa.giss.util.reslist.ResourceListEntry;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanOverlayTableModel
extends PanPrefsTableModel
implements ResourceListDataListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OverlayResourceList reslist_ = PanResourceUtils.getOverlayList();

    public PanOverlayTableModel() {
        super(true);
        this.reslist_.addListDataListener(this);
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public int getRowCount() {
        if (this.reslist_ == null) {
            return 0;
        }
        return this.reslist_.getSize();
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: {
                return Boolean.class;
            }
        }
        return String.class;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return "Fave?";
            }
            case 1: {
                return "Name";
            }
            case 2: {
                return "Type";
            }
            case 3: {
                return "Status";
            }
        }
        return "Error";
    }

    @Override
    public Object getValueAt(int row, int col) {
        ResourceListEntry.LocType loctype = this.reslist_.getLocType(row);
        ResourceListEntry eee = this.reslist_.getElementAt(row);
        MapOverlay ooo = PanResourceUtils.getOverlay(row);
        switch (col) {
            case 0: {
                return this.reslist_.isFavorite(row);
            }
            case 1: {
                if (eee == null) {
                    return "\u2014";
                }
                return eee.getName();
            }
            case 2: {
                if (ooo instanceof MapOverlay) {
                    MapOverlay moo = ooo;
                    if (moo.isOutline()) {
                        return "Outline";
                    }
                    if (moo.isMask()) {
                        return "Mask";
                    }
                    if (moo.isPoints()) {
                        return "Points";
                    }
                    return "WTF?";
                }
                return "[Invalid/Corrupt]";
            }
            case 3: {
                switch (loctype) {
                    case INCODE: 
                    case JAR: {
                        return "Built-in";
                    }
                    case USERLIB: {
                        return "User Lib";
                    }
                }
                return "Session";
            }
        }
        return "Error";
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (col == 0) {
            String lcname = this.reslist_.getName(row).toLowerCase();
            return !"earth.cno".equalsIgnoreCase(lcname) && !"MWDB_Coasts_1.cnob".equalsIgnoreCase(lcname) && !"MWDB_Coasts_Countries_1.cnob".equalsIgnoreCase(lcname);
        }
        return false;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col != 0) {
            return;
        }
        if (this.isCellEditable(row, col)) {
            this.reslist_.setFavorite(row, (Boolean)value);
        } else {
            this.reslist_.setFavorite(row, true);
        }
        this.fireTableCellUpdated(row, col);
    }

    @Override
    public void contentsChanged(ResourceListDataEvent e) {
        this.fireTableDataChanged();
    }

    @Override
    public void statusChanged(ResourceListDataEvent e) {
    }

    @Override
    public void intervalAdded(ResourceListDataEvent e) {
        int index0 = e.getIndex0();
        int index1 = e.getIndex1();
        this.fireTableRowsInserted(index0, index1);
    }

    @Override
    public void intervalRemoved(ResourceListDataEvent e) {
        int index0 = e.getIndex0();
        int index1 = e.getIndex1();
        this.fireTableRowsDeleted(index0, index1);
    }

    @Override
    public void sortByColumn(int col) {
        LOGGER.trace("Does nothing. Not implemented.");
    }
}

