/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.sources;

import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.panoply.ui.PanButton;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.ui.BlackSplitPane;
import gov.nasa.giss.ui.GTextField;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.event.TreeTableEvent;
import gov.nasa.giss.ui.event.TreeTableListener;
import gov.nasa.giss.ui.treetable.SearchableTreeTablePanel;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.invoke.MethodHandles;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PanSourcesPanel
extends JPanel
implements PropertyChangeListener,
TreeTableListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final PanSourcesFrame parent_;
    private BlackSplitPane splitPane_;
    private final JComponent leftPanel_;
    private JComponent treeHolder_;
    protected SearchableTreeTablePanel ttPanel_;
    private boolean findVisible_;
    private JComponent findPanel_;
    private GTextField findTermTF_;
    private PanButton findNextBtn_;
    private static String commonFindTerm_ = "";
    private JComponent rightPanel_;
    protected JEditorPane infoPane_;
    private static boolean ignorePCEvents_;

    public PanSourcesPanel(PanSourcesFrame parent, boolean includeInfo) {
        this.parent_ = parent;
        this.leftPanel_ = this.makeLeftPanel();
        this.leftPanel_.setMinimumSize(new Dimension(135, 300));
        if (includeInfo) {
            this.splitPane_ = new BlackSplitPane();
            this.splitPane_.addPropertyChangeListener(this);
            this.rightPanel_ = this.makeRightPanel();
            this.rightPanel_.setMinimumSize(new Dimension(135, 300));
        }
        this.setMinimumSize(new Dimension(540, 300));
        this.setPreferredSize(this.getMinimumSize());
        this.setLayout(new BorderLayout());
        this.setBorder(PanGuiUtils.NO_BORDER);
        this.setOpaque(false);
    }

    private JComponent makeLeftPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setOpaque(false);
        panel.setBorder(null);
        this.treeHolder_ = this.makeTreeHolder();
        panel.add(this.treeHolder_);
        this.findPanel_ = this.makeFindPanel();
        return panel;
    }

    protected abstract JComponent makeTreeHolder();

    private JComponent makeFindPanel() {
        JLabel findLabel = new JLabel("Find: ");
        this.findTermTF_ = GTextField.createSearchField();
        this.findNextBtn_ = PanButton.createSegmented("Find", "first");
        PanButton findDoneButton = PanButton.createSegmented("Done", "last");
        PanButton altNextButton = PanButton.createSegmented("Next", "first");
        Dimension d1 = this.findNextBtn_.getMinimumSize();
        Dimension d2 = altNextButton.getMinimumSize();
        if (d1.width < d2.width) {
            this.findNextBtn_.setMinimumSize(d2);
            this.findNextBtn_.setMaximumSize(d2);
        }
        this.findNextBtn_.setRequestFocusEnabled(false);
        findDoneButton.setRequestFocusEnabled(false);
        QuickBox panel = QuickBox.createHorizontalBox(findLabel, this.findTermTF_, this.findNextBtn_, findDoneButton);
        panel.setBorder(BorderFactory.createEmptyBorder(2, 8, 2, 8));
        panel.setOpaque(false);
        d2 = panel.getPreferredSize();
        panel.setMinimumSize(new Dimension(20, d2.height));
        panel.setMaximumSize(new Dimension(2000, d2.height));
        this.findTermTF_.addActionListener(e -> this.findNext());
        this.findTermTF_.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateCommon();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateCommon();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateCommon();
            }

            private void updateCommon() {
                commonFindTerm_ = PanSourcesPanel.this.findTermTF_.getText();
                PanSourcesPanel.this.findNextBtn_.setText("Find");
            }
        });
        this.findNextBtn_.addActionListener(e -> {
            commonFindTerm_ = this.findTermTF_.getText();
            this.findNext();
        });
        findDoneButton.addActionListener(e -> {
            this.showFind(false);
            this.findNextBtn_.setText("Find");
        });
        return panel;
    }

    private JComponent makeRightPanel() {
        this.infoPane_ = new JEditorPane("text/plain", "");
        this.infoPane_.setFont(new Font("Monospaced", 0, 12));
        this.infoPane_.setEditable(false);
        this.infoPane_.setBorder(PanGuiUtils.NO_BORDER);
        JScrollPane infoSPane = new JScrollPane(this.infoPane_);
        infoSPane.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY));
        return infoSPane;
    }

    protected abstract void refreshInfoPane();

    protected boolean isFindVisible() {
        return this.findVisible_;
    }

    public void showFind(boolean visible) {
        this.findVisible_ = visible;
        if (visible) {
            if (this.findPanel_ == null) {
                this.findPanel_ = this.makeFindPanel();
            }
            if (!this.leftPanel_.isAncestorOf(this.findPanel_)) {
                this.leftPanel_.removeAll();
                this.leftPanel_.add(this.findPanel_);
                this.leftPanel_.add(this.treeHolder_);
                this.findNextBtn_.setText("Find");
            }
            this.leftPanel_.validate();
            this.findTermTF_.grabFocus();
        } else if (this.findPanel_ != null && this.leftPanel_.isAncestorOf(this.findPanel_)) {
            this.leftPanel_.remove(this.findPanel_);
            this.leftPanel_.validate();
        }
    }

    protected String getSearchTerm() {
        return commonFindTerm_;
    }

    public void findNext() {
        String sterm = this.getSearchTerm();
        if (sterm == null || sterm.length() < 1) {
            return;
        }
        boolean found = this.ttPanel_.searchForNext(sterm);
        if (found) {
            this.findNextBtn_.setText("Next");
            this.refreshInfoPane();
        } else {
            this.findNextBtn_.setText("Find");
        }
    }

    abstract void refreshActions();

    public abstract void removeNode(TreeTableNode var1);

    public abstract void clear();

    public TreeTableNode getSelectedNode() {
        return this.ttPanel_.getTreeTable().getSelectedNode();
    }

    public synchronized void remakeLayout() {
        this.findTermTF_.setText(commonFindTerm_);
        Dimension csize = null;
        Component[] children = this.getComponents();
        if (children != null && children.length > 0) {
            csize = children[0].getSize();
        }
        if (this.rightPanel_ == null || this.splitPane_ == null) {
            if (!(this.isAncestorOf(this.leftPanel_) && this.leftPanel_.getParent() == this || this.isAncestorOf(this.leftPanel_))) {
                this.add((Component)this.leftPanel_, "Center");
            }
            if (csize != null) {
                this.leftPanel_.setPreferredSize(csize);
            }
            this.validate();
            return;
        }
        ignorePCEvents_ = true;
        PanPreferences prefs = PanPreferences.getSharedInstance();
        if (prefs.getBoolean("sources:info.vis")) {
            if (this.isAncestorOf(this.leftPanel_) && this.leftPanel_.getParent() == this) {
                this.remove(this.leftPanel_);
            }
            if (!this.isAncestorOf(this.splitPane_)) {
                this.splitPane_.setLeftComponent(this.leftPanel_);
                this.splitPane_.setRightComponent(this.rightPanel_);
                this.add((Component)this.splitPane_, "Center");
                int infoPct = prefs.getInt("sources:info.width");
                infoPct = Math.min(infoPct, 85);
                infoPct = Math.max(infoPct, 15);
                double infoFrac = (double)infoPct * 0.01;
                this.splitPane_.setDividerLocation(1.0 - infoFrac);
                if (csize != null) {
                    csize.width = 10000;
                    this.splitPane_.setPreferredSize(csize);
                }
            }
        } else {
            if (this.isAncestorOf(this.splitPane_)) {
                ignorePCEvents_ = true;
                this.remove(this.splitPane_);
                ignorePCEvents_ = false;
            }
            if (this.leftPanel_.getParent() == this.splitPane_) {
                this.splitPane_.remove(this.leftPanel_);
            }
            this.add((Component)this.leftPanel_, "Center");
            if (csize != null) {
                this.leftPanel_.setPreferredSize(csize);
            }
        }
        if (this.isAncestorOf(this.splitPane_)) {
            int oldInfoPct = this.splitPane_.getWidth() > 0 ? this.rightPanel_.getWidth() * 100 / this.splitPane_.getWidth() : -1;
            int newInfoPct = prefs.getInt("sources:info.width");
            newInfoPct = Math.min(newInfoPct, 85);
            newInfoPct = Math.max(newInfoPct, 15);
            if (oldInfoPct >= 0 && Math.abs(newInfoPct - oldInfoPct) > 0) {
                double infoFrac = (double)newInfoPct * 0.01;
                this.splitPane_.setDividerLocation(1.0 - infoFrac);
            }
            this.splitPane_.invalidate();
            this.splitPane_.validate();
        }
        this.invalidate();
        this.validate();
        this.repaint();
        ignorePCEvents_ = false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (ignorePCEvents_) {
            return;
        }
        String pname = e.getPropertyName();
        if (pname.equals("dividerLocation") && this.splitPane_ != null && this.isAncestorOf(this.splitPane_)) {
            int newLocation = this.splitPane_.getDividerLocation();
            int panelWidth = this.splitPane_.getWidth();
            if (newLocation > 0 && newLocation < panelWidth) {
                PanPreferences prefs = PanPreferences.getSharedInstance();
                int newInfoPct = this.rightPanel_.getWidth() * 100 / panelWidth;
                prefs.setInt("sources:info.width", newInfoPct);
            }
        }
    }

    @Override
    public void removalRequested(TreeTableEvent e) {
        if (e == null) {
            return;
        }
        TreeTableNode snode = this.ttPanel_.getTreeTable().getSelectedNode();
        this.removeNode(snode);
    }

    @Override
    public void itemRemoved(TreeTableEvent e) {
        this.refreshActions();
        this.refreshInfoPane();
        this.repaint();
    }
}

