/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.time.mission;

import gov.nasa.giss.time.mission.MarsLanderID;
import gov.nasa.giss.time.mission.MarsLanderTime;
import gov.nasa.giss.time.mission.MissionStatus;
import gov.nasa.giss.time.planet.MarsTime;

public class MarsExplorationRover
extends MarsLanderTime {
    private static final long MERA_LAUNCH_MILLIS = 1055267927000L;
    private static final long MERA_LANDING_MILLIS = 1073190883000L;
    private static final double MERA_SOL1_J2000_MILLIS = 1.264096557E8;
    private static final double MERA_OFFSET = 600.0;
    private static final long MERB_LAUNCH_MILLIS = 1057634295000L;
    private static final long MERB_LANDING_MILLIS = 1075006462000L;
    private static final double MERB_SOL1_J2000_MILLIS = 1.282298048E8;
    private static final double MERB_OFFSET = 780.0;
    private long launchMillis_;
    private long descentMillis_;
    private long landingMillis_;
    private double t0j2000_;
    private double offset_;

    private MarsExplorationRover() {
        super("MER-A Spirit");
    }

    public MarsExplorationRover(MarsLanderID lid, MarsTime marsTime) {
        super(lid.toString(), marsTime);
        switch (lid) {
            case MERA: {
                this.launchMillis_ = 1055267927000L;
                this.landingMillis_ = 1073190883000L;
                this.t0j2000_ = 1.264096557E8;
                this.offset_ = 600.0;
                break;
            }
            case MERB: {
                this.launchMillis_ = 1057634295000L;
                this.landingMillis_ = 1075006462000L;
                this.t0j2000_ = 1.282298048E8;
                this.offset_ = 780.0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Lander ID is not an MER mission");
            }
        }
        this.descentMillis_ = this.landingMillis_ - 420000L;
    }

    @Override
    protected void update() {
        long millis = this.mTime_.getMillis();
        if (millis < this.launchMillis_) {
            this.status_ = MissionStatus.NOT_LAUNCHED;
            this.sol_ = Long.MIN_VALUE;
            this.fraction_ = 0.0;
            return;
        }
        double lltSec = (this.mTime_.getJ2000Seconds() - this.t0j2000_) * 0.9732442960905843 + this.offset_;
        double llt = lltSec * 1.1574074074074073E-5;
        this.sol_ = (long)Math.floor(llt);
        this.fraction_ = llt - (double)this.sol_;
        if (llt >= 0.0) {
            ++this.sol_;
        }
        this.status_ = millis < this.descentMillis_ ? MissionStatus.IN_FLIGHT : (millis < this.landingMillis_ ? MissionStatus.DESCENDING : MissionStatus.ACTIVE);
        this.needsUpdate_ = false;
    }
}

