/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.tools;

import com.googlecode.dex2jar.tools.BaseCmd;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

@BaseCmd.Syntax(cmd="d2j-jar-access", syntax="[options] <jar>", desc="add or remove class/method/field access in jar file")
public class JarAccessCmd
extends BaseCmd
implements Opcodes {
    @BaseCmd.Opt(opt="f", longOpt="force", hasArg=false, description="force overwrite")
    private boolean forceOverwrite = false;
    @BaseCmd.Opt(opt="o", longOpt="output", description="output dir of .j files, default is $current_dir/[jar-name]-access.jar", argName="out-dir")
    private Path output;
    @BaseCmd.Opt(opt="rd", longOpt="remove-debug", hasArg=false, description="remove debug info")
    private boolean removeDebug = false;
    @BaseCmd.Opt(opt="rf", longOpt="remove-field-access", description="remove access from field", argName="ACC")
    private String removeFieldAccess;
    @BaseCmd.Opt(opt="rm", longOpt="remove-method-access", description="remove access from method", argName="ACC")
    private String removeMethodAccess;
    @BaseCmd.Opt(opt="rc", longOpt="remove-class-access", description="remove access from class", argName="ACC")
    private String removeClassAccess;
    @BaseCmd.Opt(opt="af", longOpt="add-field-access", description="add access from field", argName="ACC")
    private String addFieldAccess;
    @BaseCmd.Opt(opt="am", longOpt="add-method-access", description="add access from method", argName="ACC")
    private String addMethodAccess;
    @BaseCmd.Opt(opt="ac", longOpt="add-class-access", description="add access from class", argName="ACC")
    private String addClassAccess;

    public static void main(String ... args) {
        new JarAccessCmd().doMain(args);
    }

    static int str2acc(String s) {
        if (s == null) {
            return 0;
        }
        int result = 0;
        if ((s = s.toLowerCase()).contains("public")) {
            result |= 1;
        }
        if (s.contains("private")) {
            result |= 2;
        }
        if (s.contains("protected")) {
            result |= 4;
        }
        if (s.contains("final")) {
            result |= 0x10;
        }
        if (s.contains("static")) {
            result |= 8;
        }
        if (s.contains("super")) {
            result |= 0x20;
        }
        if (s.contains("synchronized")) {
            result |= 0x20;
        }
        if (s.contains("volatile")) {
            result |= 0x40;
        }
        if (s.contains("bridge")) {
            result |= 0x40;
        }
        if (s.contains("transient")) {
            result |= 0x80;
        }
        if (s.contains("varargs")) {
            result |= 0x80;
        }
        if (s.contains("native")) {
            result |= 0x100;
        }
        if (s.contains("strict")) {
            result |= 0x800;
        }
        if (s.contains("interface")) {
            result |= 0x200;
        }
        if (s.contains("abstract")) {
            result |= 0x400;
        }
        if (s.contains("synthetic")) {
            result |= 0x1000;
        }
        if (s.contains("annotation")) {
            result |= 0x2000;
        }
        if (s.contains("enum")) {
            result |= 0x4000;
        }
        if (s.contains("deprecated")) {
            result |= 0x20000;
        }
        return result;
    }

    protected void doCommandLine() throws Exception {
        if (this.remainingArgs.length != 1) {
            this.usage();
            return;
        }
        Path jar = new File(this.remainingArgs[0]).toPath();
        if (!Files.exists(jar, new LinkOption[0])) {
            System.err.println(jar + " is not exists");
            this.usage();
            return;
        }
        if (this.output == null) {
            this.output = Files.isDirectory(jar, new LinkOption[0]) ? new File(jar.getFileName() + "-access.jar").toPath() : new File(String.valueOf(JarAccessCmd.getBaseName((String)jar.getFileName().toString())) + "-access.jar").toPath();
        }
        if (Files.exists(this.output, new LinkOption[0]) && !this.forceOverwrite) {
            System.err.println(this.output + " exists, use --force to overwrite");
            this.usage();
            return;
        }
        final int rf = ~JarAccessCmd.str2acc(this.removeFieldAccess);
        final int rm = ~JarAccessCmd.str2acc(this.removeMethodAccess);
        final int rc = ~JarAccessCmd.str2acc(this.removeClassAccess);
        final int af = JarAccessCmd.str2acc(this.addFieldAccess);
        final int am = JarAccessCmd.str2acc(this.addMethodAccess);
        final int ac = JarAccessCmd.str2acc(this.addClassAccess);
        final int flags = this.removeDebug ? 2 : 0;
        Throwable throwable = null;
        Object var10_11 = null;
        try (FileSystem outFileSystem = JarAccessCmd.createZip((Path)this.output);){
            final Path outRoot = outFileSystem.getPath("/", new String[0]);
            JarAccessCmd.walkJarOrDir((Path)jar, (BaseCmd.FileVisitorX)new BaseCmd.FileVisitorX(){

                public void visitFile(Path file, Path relative) throws IOException {
                    if (file.getFileName().toString().endsWith(".class")) {
                        final ClassReader r = new ClassReader(Files.readAllBytes(file));
                        ClassWriter cr = new ClassWriter(0);
                        r.accept(new ClassVisitor(262144, (ClassVisitor)cr){

                            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                                int na = access & rc | ac;
                                if (access != na) {
                                    System.out.println("c " + name);
                                }
                                super.visit(version, na, name, signature, superName, interfaces);
                            }

                            public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                                int na = access & rf | af;
                                if (na != access) {
                                    System.out.println("f " + r.getClassName() + "." + name);
                                }
                                return super.visitField(na, name, desc, signature, value);
                            }

                            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                                int na = access & rm | am;
                                if (na != access) {
                                    System.out.println("m " + r.getClassName() + "." + name + desc);
                                }
                                return super.visitMethod(na, name, desc, signature, exceptions);
                            }
                        }, flags | 8);
                        Files.write(outRoot.resolve(relative), cr.toByteArray(), new OpenOption[0]);
                    } else {
                        Files.copy(file, outRoot.resolve(relative), new CopyOption[0]);
                    }
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

