/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.database.dao.impl;

import com.ghostchu.peerbanhelper.BanList;
import com.ghostchu.peerbanhelper.database.dao.AbstractPBHDao;
import com.ghostchu.peerbanhelper.database.table.BanListEntity;
import com.ghostchu.peerbanhelper.util.IPAddressUtil;
import com.ghostchu.peerbanhelper.util.json.JsonUtil;
import com.ghostchu.peerbanhelper.wrapper.BanMetadata;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.TableUtils;
import inet.ipaddr.IPAddress;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class BanListDao
extends AbstractPBHDao<BanListEntity, String> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BanListDao.class);

    public BanListDao(@Autowired ConnectionSource database) throws SQLException {
        super(database, BanListEntity.class);
    }

    public Map<IPAddress, BanMetadata> readBanList() {
        HashMap<IPAddress, BanMetadata> map = new HashMap<IPAddress, BanMetadata>();
        try {
            this.queryForAll().forEach(e -> map.put(IPAddressUtil.getIPAddress(e.getAddress()), (BanMetadata)JsonUtil.tiny().fromJson(e.getMetadata(), BanMetadata.class)));
        }
        catch (Exception e2) {
            log.error("Unable to read stored banlist, skipping...", (Throwable)e2);
        }
        return map;
    }

    public int saveBanList(BanList banlist) throws SQLException {
        return this.callBatchTasks(() -> {
            ArrayList entityList = new ArrayList();
            banlist.forEach((key, value) -> entityList.add(new BanListEntity(key.toNormalizedString(), JsonUtil.tiny().toJson(value))));
            TableUtils.clearTable((ConnectionSource)this.getConnectionSource(), BanListEntity.class);
            return this.create(entityList);
        });
    }
}

