/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module.impl.webapi;

import com.ghostchu.peerbanhelper.BanList;
import com.ghostchu.peerbanhelper.DownloaderServer;
import com.ghostchu.peerbanhelper.database.Database;
import com.ghostchu.peerbanhelper.database.dao.impl.HistoryDao;
import com.ghostchu.peerbanhelper.database.dao.impl.ModuleDao;
import com.ghostchu.peerbanhelper.database.dao.impl.RuleDao;
import com.ghostchu.peerbanhelper.database.dao.impl.TorrentDao;
import com.ghostchu.peerbanhelper.database.table.HistoryEntity;
import com.ghostchu.peerbanhelper.downloader.DownloaderManagerImpl;
import com.ghostchu.peerbanhelper.metric.BasicMetrics;
import com.ghostchu.peerbanhelper.module.AbstractFeatureModule;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.BanDTO;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.BanLogDTO;
import com.ghostchu.peerbanhelper.util.IPAddressUtil;
import com.ghostchu.peerbanhelper.util.ipdb.IPDBManager;
import com.ghostchu.peerbanhelper.util.ipdb.IPGeoData;
import com.ghostchu.peerbanhelper.util.query.Orderable;
import com.ghostchu.peerbanhelper.util.query.Page;
import com.ghostchu.peerbanhelper.util.query.Pageable;
import com.ghostchu.peerbanhelper.web.JavalinWebContainer;
import com.ghostchu.peerbanhelper.web.Role;
import com.ghostchu.peerbanhelper.web.wrapper.StdResp;
import com.ghostchu.peerbanhelper.wrapper.BakedBanMetadata;
import com.ghostchu.peerbanhelper.wrapper.BanMetadata;
import com.ghostchu.peerbanhelper.wrapper.PeerAddress;
import com.ghostchu.peerbanhelper.wrapper.PeerWrapper;
import com.j256.ormlite.stmt.QueryBuilder;
import inet.ipaddr.IPAddress;
import io.javalin.Javalin;
import io.javalin.http.Context;
import io.javalin.security.RouteRole;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public final class PBHBanController
extends AbstractFeatureModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PBHBanController.class);
    @Autowired
    private Database db;
    @Autowired
    @Qualifier(value="persistMetrics")
    private BasicMetrics persistMetrics;
    @Autowired
    private JavalinWebContainer webContainer;
    @Autowired
    private HistoryDao historyDao;
    @Autowired
    private DownloaderServer downloaderServer;
    @Autowired
    private DownloaderManagerImpl downloaderManager;
    @Autowired
    private TorrentDao torrentDao;
    @Autowired
    private ModuleDao moduleDao;
    @Autowired
    private RuleDao ruleDao;
    @Autowired
    private BanList banList;
    @Autowired
    private IPDBManager iPDBManager;

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    @NotNull
    public String getName() {
        return "WebAPI - PBH Ban API";
    }

    @Override
    @NotNull
    public String getConfigName() {
        return "webapi-downloader";
    }

    @Override
    public void onEnable() {
        ((Javalin)((Javalin)((Javalin)((Javalin)this.webContainer.javalin().get("/api/bans", this::handleBans, new RouteRole[]{Role.USER_READ})).get("/api/bans/logs", this::handleLogs, new RouteRole[]{Role.USER_READ})).get("/api/bans/ranks", this::handleRanks, new RouteRole[]{Role.USER_READ})).delete("/api/bans", this::handleBanDelete, new RouteRole[]{Role.USER_WRITE})).put("/api/bans", this::handleBanAdd, new RouteRole[]{Role.USER_WRITE});
    }

    private void handleBanAdd(@NotNull Context context) {
        String[] request = (String[])context.bodyAsClass(String[].class);
        int size = 0;
        for (String s : request) {
            this.downloaderServer.scheduleBanPeerNoAssign(new PeerAddress(s, 0, s));
            ++size;
        }
        context.json((Object)new StdResp(true, null, Map.of("count", size)));
    }

    private void handleBanDelete(Context context) {
        List<String> request = Arrays.asList((String[])context.bodyAsClass(String[].class));
        ArrayList<IPAddress> pendingRemovals = new ArrayList<IPAddress>();
        if (request.contains("*")) {
            pendingRemovals.addAll(this.banList.copyKeySet());
            this.downloaderServer.getNeedReApplyBanList().set(true);
        } else {
            for (String s : request) {
                pendingRemovals.add(IPAddressUtil.getIPAddress(s));
            }
        }
        pendingRemovals.forEach(pa -> this.downloaderServer.scheduleUnBanPeer((IPAddress)pa));
        context.json((Object)new StdResp(true, null, Map.of("count", pendingRemovals.size())));
    }

    private void handleRanks(Context ctx) throws Exception {
        Pageable pageable = new Pageable(ctx);
        String filter = ctx.queryParam("filter");
        ctx.json((Object)new StdResp(true, null, this.historyDao.getBannedIps(pageable, filter)));
    }

    private void handleLogs(Context ctx) throws SQLException {
        if (this.db == null) {
            throw new IllegalStateException("Database not initialized on this PeerBanHelper server");
        }
        this.persistMetrics.flush();
        Pageable pageable = new Pageable(ctx);
        Orderable orderable = new Orderable(Map.of("banAt", false), ctx);
        Page queryResult = this.historyDao.queryByPaging(orderable.addMapping("torrent.name", "torrentName").addMapping("torrent.infoHash", "torrentInfoHash").addMapping("torrent.size", "torrentSize").addMapping("module.name", "module").addMapping("rule.rule", "rule").addMapping("ip", "peerIp").apply(this.historyDao.queryBuilder().join(this.torrentDao.queryBuilder().setAlias("torrent"), QueryBuilder.JoinType.LEFT, QueryBuilder.JoinWhereOperation.AND).join(this.ruleDao.queryBuilder().setAlias("rule").join(this.moduleDao.queryBuilder().setAlias("module"), QueryBuilder.JoinType.LEFT, QueryBuilder.JoinWhereOperation.AND), QueryBuilder.JoinType.LEFT, QueryBuilder.JoinWhereOperation.AND)), pageable);
        List<BanLogDTO> result = queryResult.getResults().stream().map(r -> new BanLogDTO(this.locale(ctx), this.downloaderManager, (HistoryEntity)r)).toList();
        ctx.json((Object)new StdResp(true, null, new Page<BanLogDTO>(pageable, queryResult.getTotal(), result)));
    }

    private void handleBans(Context ctx) {
        boolean hasPageParam = ctx.queryParam("page") != null;
        boolean ignoreBanForDisconnect = Boolean.parseBoolean(Objects.requireNonNullElse(ctx.queryParam("ignoreBanForDisconnect"), "true"));
        String search = ctx.queryParam("search");
        if (search != null) {
            search = URLDecoder.decode(search, StandardCharsets.UTF_8);
        }
        Pageable pageable = new Pageable(ctx);
        Stream<BanDTO> banStream = this.getBanResponseStream(this.locale(ctx), -1L, -1L, ignoreBanForDisconnect, search);
        List<BanDTO> allResults = banStream.toList();
        long total = allResults.size();
        long skip = pageable.getZeroBasedPage() * pageable.getSize();
        List pageResults = allResults.stream().skip(skip).limit(pageable.getSize()).toList();
        ctx.json((Object)new StdResp(true, null, new Page(pageable, total, pageResults)));
    }

    @Override
    public void onDisable() {
    }

    @NotNull
    private Stream<BanDTO> getBanResponseStream(String locale, long lastBanTime, long limit, boolean ignoreBanForDisconnect, String search) {
        Stream<BanDTO> banResponseList = this.banList.toMap().entrySet().stream().filter(b -> {
            if (((BanMetadata)b.getValue()).isExcludeFromDisplay()) {
                return false;
            }
            if (!ignoreBanForDisconnect) {
                return true;
            }
            return !((BanMetadata)b.getValue()).isBanForDisconnect();
        }).filter(b -> search == null || Arrays.stream(((IPAddress)b.getKey()).toStandardStrings()).anyMatch(ip -> ip.toLowerCase(Locale.ROOT).contains(search.toLowerCase(Locale.ROOT))) || ((BanMetadata)b.getValue()).toString().toLowerCase(Locale.ROOT).contains(search.toLowerCase(Locale.ROOT))).map(entry -> new BanDTO(((IPAddress)entry.getKey()).toNormalizedString(), new BakedBanMetadata(locale, (BanMetadata)entry.getValue()), null)).sorted((o1, o2) -> Long.compare(o2.getBanMetadata().getBanAt(), o1.getBanMetadata().getBanAt()));
        if (lastBanTime > 0L) {
            banResponseList = banResponseList.filter(b -> b.getBanMetadata().getBanAt() < lastBanTime);
        }
        if (limit > 0L) {
            banResponseList = banResponseList.limit(limit);
        }
        banResponseList = banResponseList.peek(response -> {
            PeerWrapper peerWrapper = response.getBanMetadata().getPeer();
            if (peerWrapper != null) {
                IPGeoData nullableGeoData = this.iPDBManager.queryIPDB(peerWrapper.toPeerAddress().getAddress().toInetAddress()).geoData().get();
                response.setIpGeoData(nullableGeoData);
            }
        });
        return banResponseList;
    }
}

