/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.task;

import java.io.Serializable;
import org.springframework.core.task.TaskCallback;
import org.springframework.core.task.TaskExecutor;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrencyThrottleSupport;

public class SyncTaskExecutor
extends ConcurrencyThrottleSupport
implements TaskExecutor,
Serializable {
    @Override
    public void execute(Runnable task) {
        Assert.notNull((Object)task, "Task must not be null");
        if (this.isThrottleActive()) {
            this.beforeAccess();
            try {
                task.run();
            }
            finally {
                this.afterAccess();
            }
        } else {
            task.run();
        }
    }

    public <V, E extends Exception> V execute(TaskCallback<V, E> task) throws E {
        Assert.notNull(task, "Task must not be null");
        if (this.isThrottleActive()) {
            this.beforeAccess();
            try {
                V v = task.call();
                return v;
            }
            finally {
                this.afterAccess();
            }
        }
        return task.call();
    }
}

