/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.database.dao.impl;

import com.ghostchu.peerbanhelper.database.dao.AbstractPBHDao;
import com.ghostchu.peerbanhelper.database.table.TrafficJournalEntity;
import com.ghostchu.peerbanhelper.downloader.DownloaderSpeedLimiter;
import com.ghostchu.peerbanhelper.util.MiscUtil;
import com.j256.ormlite.dao.GenericRawResults;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class TrafficJournalDao
extends AbstractPBHDao<TrafficJournalEntity, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TrafficJournalDao.class);

    public TrafficJournalDao(@Autowired ConnectionSource database) throws SQLException {
        super(database, TrafficJournalEntity.class);
    }

    @NotNull
    public SlidingWindowDynamicSpeedLimiter tweakSpeedLimiterBySlidingWindow(@Nullable String downloader, @NotNull DownloaderSpeedLimiter currentSetting, long thresholdBytes, long minSpeedBytesPerSecond, long maxSpeedBytesPerSecond) throws Exception {
        long newSpeed;
        SlidingWindowDynamicSpeedLimiter slidingWindowDynamicSpeedLimiter = new SlidingWindowDynamicSpeedLimiter();
        slidingWindowDynamicSpeedLimiter.setThreshold(thresholdBytes);
        slidingWindowDynamicSpeedLimiter.setMaxSpeed(maxSpeedBytesPerSecond);
        slidingWindowDynamicSpeedLimiter.setMinSpeed(minSpeedBytesPerSecond);
        long windowSizeMillis = 86400000L;
        slidingWindowDynamicSpeedLimiter.setWindowSizeMillis(windowSizeMillis);
        long currentTime = System.currentTimeMillis();
        long windowStartTime = currentTime - windowSizeMillis;
        slidingWindowDynamicSpeedLimiter.setWindowStartTime(windowStartTime);
        Timestamp startTimestamp = new Timestamp(windowStartTime);
        Timestamp endTimestamp = new Timestamp(currentTime);
        List<TrafficDataComputed> trafficData = downloader == null ? this.getAllDownloadersOverallData(startTimestamp, endTimestamp) : this.getSpecificDownloaderOverallData(downloader, startTimestamp, endTimestamp);
        long totalUploadedBytes = trafficData.stream().mapToLong(TrafficDataComputed::getDataOverallUploaded).sum();
        slidingWindowDynamicSpeedLimiter.setUploadedInWindow(totalUploadedBytes);
        long currentSpeedLimit = currentSetting.upload();
        slidingWindowDynamicSpeedLimiter.setOldSpeedLimit(currentSpeedLimit);
        if (totalUploadedBytes >= thresholdBytes) {
            if (currentSpeedLimit <= minSpeedBytesPerSecond) {
                newSpeed = minSpeedBytesPerSecond;
                slidingWindowDynamicSpeedLimiter.setReachedMinimumSpeed(true);
            } else {
                double b = thresholdBytes > 0L ? (double)totalUploadedBytes / (double)thresholdBytes : 1.0;
                newSpeed = Math.max(minSpeedBytesPerSecond, (long)((double)currentSpeedLimit / b));
                slidingWindowDynamicSpeedLimiter.setDecreaseFactor(b);
            }
        } else if (currentSpeedLimit >= maxSpeedBytesPerSecond && maxSpeedBytesPerSecond > 0L) {
            newSpeed = maxSpeedBytesPerSecond;
        } else {
            double a = (double)(thresholdBytes - totalUploadedBytes) / (double)windowSizeMillis * 1000.0;
            newSpeed = Math.min(maxSpeedBytesPerSecond, Math.addExact(currentSpeedLimit, (long)a));
            slidingWindowDynamicSpeedLimiter.setIncreaseFactor(a);
        }
        slidingWindowDynamicSpeedLimiter.setNewSpeedLimit(newSpeed);
        return slidingWindowDynamicSpeedLimiter;
    }

    public TrafficDataComputed getTodayData(String downloader) throws Exception {
        Timestamp startOfToday = new Timestamp(MiscUtil.getStartOfToday(System.currentTimeMillis()));
        Timestamp endOfToday = new Timestamp(MiscUtil.getEndOfToday(System.currentTimeMillis()));
        List results = downloader == null || downloader.isBlank() ? this.getAllDownloadersOverallData(startOfToday, endOfToday).stream().toList() : this.getSpecificDownloaderOverallData(downloader, startOfToday, endOfToday).stream().toList();
        if (results.isEmpty()) {
            return new TrafficDataComputed(startOfToday, 0L, 0L);
        }
        return new TrafficDataComputed(startOfToday, results.stream().mapToLong(TrafficDataComputed::getDataOverallUploaded).sum(), results.stream().mapToLong(TrafficDataComputed::getDataOverallDownloaded).sum());
    }

    public TrafficJournalEntity updateData(String downloader, long overallDownloaded, long overallUploaded, long overallDownloadedProtocol, long overallUploadedProtocol) throws SQLException {
        long timestamp = MiscUtil.getStartOfHour(System.currentTimeMillis());
        TrafficJournalEntity journalEntity = (TrafficJournalEntity)this.queryBuilder().where().eq("downloader", (Object)downloader).and().eq("timestamp", (Object)timestamp).queryForFirst();
        if (journalEntity == null) {
            journalEntity = new TrafficJournalEntity();
            journalEntity.setDownloader(downloader);
            journalEntity.setTimestamp(timestamp);
            journalEntity.setDataOverallDownloadedAtStart(overallDownloaded);
            journalEntity.setDataOverallUploadedAtStart(overallUploaded);
            journalEntity.setProtocolOverallDownloadedAtStart(overallDownloadedProtocol);
            journalEntity.setProtocolOverallUploadedAtStart(overallUploadedProtocol);
        }
        journalEntity.setDataOverallDownloaded(overallDownloaded);
        journalEntity.setDataOverallUploaded(overallUploaded);
        journalEntity.setProtocolOverallDownloaded(overallDownloadedProtocol);
        journalEntity.setProtocolOverallUploaded(overallUploadedProtocol);
        this.createOrUpdate(journalEntity);
        return journalEntity;
    }

    public List<TrafficDataComputed> getDayOffsetData(String downloader, Timestamp startAt, Timestamp endAt) throws Exception {
        List<TrafficDataComputed> results = downloader == null || downloader.isBlank() ? this.getAllDownloadersOverallData(startAt, endAt).stream().toList() : this.getSpecificDownloaderOverallData(downloader, startAt, endAt).stream().toList();
        return results;
    }

    public List<TrafficDataComputed> getAllDownloadersOverallData(Timestamp start, Timestamp end) throws Exception {
        try (GenericRawResults results = this.queryBuilder().selectRaw(new String[]{"timestamp", "SUM(dataOverallUploadedAtStart) AS totalUploadedAtStart", "SUM(dataOverallUploaded) AS totalUploaded", "SUM(dataOverallDownloadedAtStart) AS totalDownloadedAtStart", "SUM(dataOverallDownloaded) AS totalDownloaded"}).where().ge("timestamp", (Object)start.getTime()).and().le("timestamp", (Object)end.getTime()).queryBuilder().groupBy("timestamp").queryRaw();){
            List<TrafficDataComputed> list = results.getResults().stream().map(args -> new TrafficData(new Timestamp(Long.parseLong(args[0])), Long.parseLong(args[1]), Long.parseLong(args[2]), Long.parseLong(args[3]), Long.parseLong(args[4]))).map(data -> new TrafficDataComputed(data.getTimestamp(), data.getDataOverallUploaded() - data.getDataOverallUploadedAtStart(), data.getDataOverallDownloaded() - data.getDataOverallDownloadedAtStart())).toList();
            return list;
        }
    }

    public List<TrafficDataComputed> getSpecificDownloaderOverallData(String downloadName, Timestamp start, Timestamp end) throws SQLException {
        return this.queryBuilder().orderBy("timestamp", true).where().eq("downloader", (Object)downloadName).and().ge("timestamp", (Object)start.getTime()).and().le("timestamp", (Object)end.getTime()).queryBuilder().query().stream().map(e -> new TrafficData(new Timestamp(e.getTimestamp()), e.getDataOverallUploadedAtStart(), e.getDataOverallUploaded(), e.getDataOverallDownloadedAtStart(), e.getDataOverallDownloaded())).map(data -> new TrafficDataComputed(data.getTimestamp(), Math.max(0L, data.getDataOverallUploaded() - data.getDataOverallUploadedAtStart()), Math.max(0L, data.getDataOverallDownloaded() - data.getDataOverallDownloadedAtStart()))).toList();
    }

    public static class SlidingWindowDynamicSpeedLimiter {
        private Long windowSizeMillis;
        private Long windowStartTime;
        private Long uploadedInWindow;
        private Long oldSpeedLimit;
        private Long newSpeedLimit;
        private Long threshold;
        private Long minSpeed;
        private Long maxSpeed;
        private Double increaseFactor;
        private Double decreaseFactor;
        private Boolean reachedMaximumSpeed;
        private Boolean reachedMinimumSpeed;

        @Generated
        public Long getWindowSizeMillis() {
            return this.windowSizeMillis;
        }

        @Generated
        public Long getWindowStartTime() {
            return this.windowStartTime;
        }

        @Generated
        public Long getUploadedInWindow() {
            return this.uploadedInWindow;
        }

        @Generated
        public Long getOldSpeedLimit() {
            return this.oldSpeedLimit;
        }

        @Generated
        public Long getNewSpeedLimit() {
            return this.newSpeedLimit;
        }

        @Generated
        public Long getThreshold() {
            return this.threshold;
        }

        @Generated
        public Long getMinSpeed() {
            return this.minSpeed;
        }

        @Generated
        public Long getMaxSpeed() {
            return this.maxSpeed;
        }

        @Generated
        public Double getIncreaseFactor() {
            return this.increaseFactor;
        }

        @Generated
        public Double getDecreaseFactor() {
            return this.decreaseFactor;
        }

        @Generated
        public Boolean getReachedMaximumSpeed() {
            return this.reachedMaximumSpeed;
        }

        @Generated
        public Boolean getReachedMinimumSpeed() {
            return this.reachedMinimumSpeed;
        }

        @Generated
        public void setWindowSizeMillis(Long windowSizeMillis) {
            this.windowSizeMillis = windowSizeMillis;
        }

        @Generated
        public void setWindowStartTime(Long windowStartTime) {
            this.windowStartTime = windowStartTime;
        }

        @Generated
        public void setUploadedInWindow(Long uploadedInWindow) {
            this.uploadedInWindow = uploadedInWindow;
        }

        @Generated
        public void setOldSpeedLimit(Long oldSpeedLimit) {
            this.oldSpeedLimit = oldSpeedLimit;
        }

        @Generated
        public void setNewSpeedLimit(Long newSpeedLimit) {
            this.newSpeedLimit = newSpeedLimit;
        }

        @Generated
        public void setThreshold(Long threshold) {
            this.threshold = threshold;
        }

        @Generated
        public void setMinSpeed(Long minSpeed) {
            this.minSpeed = minSpeed;
        }

        @Generated
        public void setMaxSpeed(Long maxSpeed) {
            this.maxSpeed = maxSpeed;
        }

        @Generated
        public void setIncreaseFactor(Double increaseFactor) {
            this.increaseFactor = increaseFactor;
        }

        @Generated
        public void setDecreaseFactor(Double decreaseFactor) {
            this.decreaseFactor = decreaseFactor;
        }

        @Generated
        public void setReachedMaximumSpeed(Boolean reachedMaximumSpeed) {
            this.reachedMaximumSpeed = reachedMaximumSpeed;
        }

        @Generated
        public void setReachedMinimumSpeed(Boolean reachedMinimumSpeed) {
            this.reachedMinimumSpeed = reachedMinimumSpeed;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SlidingWindowDynamicSpeedLimiter)) {
                return false;
            }
            SlidingWindowDynamicSpeedLimiter other = (SlidingWindowDynamicSpeedLimiter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$windowSizeMillis = this.getWindowSizeMillis();
            Long other$windowSizeMillis = other.getWindowSizeMillis();
            if (this$windowSizeMillis == null ? other$windowSizeMillis != null : !((Object)this$windowSizeMillis).equals(other$windowSizeMillis)) {
                return false;
            }
            Long this$windowStartTime = this.getWindowStartTime();
            Long other$windowStartTime = other.getWindowStartTime();
            if (this$windowStartTime == null ? other$windowStartTime != null : !((Object)this$windowStartTime).equals(other$windowStartTime)) {
                return false;
            }
            Long this$uploadedInWindow = this.getUploadedInWindow();
            Long other$uploadedInWindow = other.getUploadedInWindow();
            if (this$uploadedInWindow == null ? other$uploadedInWindow != null : !((Object)this$uploadedInWindow).equals(other$uploadedInWindow)) {
                return false;
            }
            Long this$oldSpeedLimit = this.getOldSpeedLimit();
            Long other$oldSpeedLimit = other.getOldSpeedLimit();
            if (this$oldSpeedLimit == null ? other$oldSpeedLimit != null : !((Object)this$oldSpeedLimit).equals(other$oldSpeedLimit)) {
                return false;
            }
            Long this$newSpeedLimit = this.getNewSpeedLimit();
            Long other$newSpeedLimit = other.getNewSpeedLimit();
            if (this$newSpeedLimit == null ? other$newSpeedLimit != null : !((Object)this$newSpeedLimit).equals(other$newSpeedLimit)) {
                return false;
            }
            Long this$threshold = this.getThreshold();
            Long other$threshold = other.getThreshold();
            if (this$threshold == null ? other$threshold != null : !((Object)this$threshold).equals(other$threshold)) {
                return false;
            }
            Long this$minSpeed = this.getMinSpeed();
            Long other$minSpeed = other.getMinSpeed();
            if (this$minSpeed == null ? other$minSpeed != null : !((Object)this$minSpeed).equals(other$minSpeed)) {
                return false;
            }
            Long this$maxSpeed = this.getMaxSpeed();
            Long other$maxSpeed = other.getMaxSpeed();
            if (this$maxSpeed == null ? other$maxSpeed != null : !((Object)this$maxSpeed).equals(other$maxSpeed)) {
                return false;
            }
            Double this$increaseFactor = this.getIncreaseFactor();
            Double other$increaseFactor = other.getIncreaseFactor();
            if (this$increaseFactor == null ? other$increaseFactor != null : !((Object)this$increaseFactor).equals(other$increaseFactor)) {
                return false;
            }
            Double this$decreaseFactor = this.getDecreaseFactor();
            Double other$decreaseFactor = other.getDecreaseFactor();
            if (this$decreaseFactor == null ? other$decreaseFactor != null : !((Object)this$decreaseFactor).equals(other$decreaseFactor)) {
                return false;
            }
            Boolean this$reachedMaximumSpeed = this.getReachedMaximumSpeed();
            Boolean other$reachedMaximumSpeed = other.getReachedMaximumSpeed();
            if (this$reachedMaximumSpeed == null ? other$reachedMaximumSpeed != null : !((Object)this$reachedMaximumSpeed).equals(other$reachedMaximumSpeed)) {
                return false;
            }
            Boolean this$reachedMinimumSpeed = this.getReachedMinimumSpeed();
            Boolean other$reachedMinimumSpeed = other.getReachedMinimumSpeed();
            return !(this$reachedMinimumSpeed == null ? other$reachedMinimumSpeed != null : !((Object)this$reachedMinimumSpeed).equals(other$reachedMinimumSpeed));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SlidingWindowDynamicSpeedLimiter;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $windowSizeMillis = this.getWindowSizeMillis();
            result = result * 59 + ($windowSizeMillis == null ? 43 : ((Object)$windowSizeMillis).hashCode());
            Long $windowStartTime = this.getWindowStartTime();
            result = result * 59 + ($windowStartTime == null ? 43 : ((Object)$windowStartTime).hashCode());
            Long $uploadedInWindow = this.getUploadedInWindow();
            result = result * 59 + ($uploadedInWindow == null ? 43 : ((Object)$uploadedInWindow).hashCode());
            Long $oldSpeedLimit = this.getOldSpeedLimit();
            result = result * 59 + ($oldSpeedLimit == null ? 43 : ((Object)$oldSpeedLimit).hashCode());
            Long $newSpeedLimit = this.getNewSpeedLimit();
            result = result * 59 + ($newSpeedLimit == null ? 43 : ((Object)$newSpeedLimit).hashCode());
            Long $threshold = this.getThreshold();
            result = result * 59 + ($threshold == null ? 43 : ((Object)$threshold).hashCode());
            Long $minSpeed = this.getMinSpeed();
            result = result * 59 + ($minSpeed == null ? 43 : ((Object)$minSpeed).hashCode());
            Long $maxSpeed = this.getMaxSpeed();
            result = result * 59 + ($maxSpeed == null ? 43 : ((Object)$maxSpeed).hashCode());
            Double $increaseFactor = this.getIncreaseFactor();
            result = result * 59 + ($increaseFactor == null ? 43 : ((Object)$increaseFactor).hashCode());
            Double $decreaseFactor = this.getDecreaseFactor();
            result = result * 59 + ($decreaseFactor == null ? 43 : ((Object)$decreaseFactor).hashCode());
            Boolean $reachedMaximumSpeed = this.getReachedMaximumSpeed();
            result = result * 59 + ($reachedMaximumSpeed == null ? 43 : ((Object)$reachedMaximumSpeed).hashCode());
            Boolean $reachedMinimumSpeed = this.getReachedMinimumSpeed();
            result = result * 59 + ($reachedMinimumSpeed == null ? 43 : ((Object)$reachedMinimumSpeed).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TrafficJournalDao.SlidingWindowDynamicSpeedLimiter(windowSizeMillis=" + this.getWindowSizeMillis() + ", windowStartTime=" + this.getWindowStartTime() + ", uploadedInWindow=" + this.getUploadedInWindow() + ", oldSpeedLimit=" + this.getOldSpeedLimit() + ", newSpeedLimit=" + this.getNewSpeedLimit() + ", threshold=" + this.getThreshold() + ", minSpeed=" + this.getMinSpeed() + ", maxSpeed=" + this.getMaxSpeed() + ", increaseFactor=" + this.getIncreaseFactor() + ", decreaseFactor=" + this.getDecreaseFactor() + ", reachedMaximumSpeed=" + this.getReachedMaximumSpeed() + ", reachedMinimumSpeed=" + this.getReachedMinimumSpeed() + ")";
        }

        @Generated
        public SlidingWindowDynamicSpeedLimiter() {
        }

        @Generated
        public SlidingWindowDynamicSpeedLimiter(Long windowSizeMillis, Long windowStartTime, Long uploadedInWindow, Long oldSpeedLimit, Long newSpeedLimit, Long threshold, Long minSpeed, Long maxSpeed, Double increaseFactor, Double decreaseFactor, Boolean reachedMaximumSpeed, Boolean reachedMinimumSpeed) {
            this.windowSizeMillis = windowSizeMillis;
            this.windowStartTime = windowStartTime;
            this.uploadedInWindow = uploadedInWindow;
            this.oldSpeedLimit = oldSpeedLimit;
            this.newSpeedLimit = newSpeedLimit;
            this.threshold = threshold;
            this.minSpeed = minSpeed;
            this.maxSpeed = maxSpeed;
            this.increaseFactor = increaseFactor;
            this.decreaseFactor = decreaseFactor;
            this.reachedMaximumSpeed = reachedMaximumSpeed;
            this.reachedMinimumSpeed = reachedMinimumSpeed;
        }
    }

    public static class TrafficDataComputed {
        private Timestamp timestamp;
        private long dataOverallUploaded;
        private long dataOverallDownloaded;

        @Generated
        public Timestamp getTimestamp() {
            return this.timestamp;
        }

        @Generated
        public long getDataOverallUploaded() {
            return this.dataOverallUploaded;
        }

        @Generated
        public long getDataOverallDownloaded() {
            return this.dataOverallDownloaded;
        }

        @Generated
        public void setTimestamp(Timestamp timestamp) {
            this.timestamp = timestamp;
        }

        @Generated
        public void setDataOverallUploaded(long dataOverallUploaded) {
            this.dataOverallUploaded = dataOverallUploaded;
        }

        @Generated
        public void setDataOverallDownloaded(long dataOverallDownloaded) {
            this.dataOverallDownloaded = dataOverallDownloaded;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TrafficDataComputed)) {
                return false;
            }
            TrafficDataComputed other = (TrafficDataComputed)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getDataOverallUploaded() != other.getDataOverallUploaded()) {
                return false;
            }
            if (this.getDataOverallDownloaded() != other.getDataOverallDownloaded()) {
                return false;
            }
            Timestamp this$timestamp = this.getTimestamp();
            Timestamp other$timestamp = other.getTimestamp();
            return !(this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TrafficDataComputed;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $dataOverallUploaded = this.getDataOverallUploaded();
            result = result * 59 + (int)($dataOverallUploaded >>> 32 ^ $dataOverallUploaded);
            long $dataOverallDownloaded = this.getDataOverallDownloaded();
            result = result * 59 + (int)($dataOverallDownloaded >>> 32 ^ $dataOverallDownloaded);
            Timestamp $timestamp = this.getTimestamp();
            result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TrafficJournalDao.TrafficDataComputed(timestamp=" + String.valueOf(this.getTimestamp()) + ", dataOverallUploaded=" + this.getDataOverallUploaded() + ", dataOverallDownloaded=" + this.getDataOverallDownloaded() + ")";
        }

        @Generated
        public TrafficDataComputed() {
        }

        @Generated
        public TrafficDataComputed(Timestamp timestamp, long dataOverallUploaded, long dataOverallDownloaded) {
            this.timestamp = timestamp;
            this.dataOverallUploaded = dataOverallUploaded;
            this.dataOverallDownloaded = dataOverallDownloaded;
        }
    }

    public static class TrafficData {
        private Timestamp timestamp;
        private long dataOverallUploadedAtStart;
        private long dataOverallUploaded;
        private long dataOverallDownloadedAtStart;
        private long dataOverallDownloaded;

        @Generated
        public Timestamp getTimestamp() {
            return this.timestamp;
        }

        @Generated
        public long getDataOverallUploadedAtStart() {
            return this.dataOverallUploadedAtStart;
        }

        @Generated
        public long getDataOverallUploaded() {
            return this.dataOverallUploaded;
        }

        @Generated
        public long getDataOverallDownloadedAtStart() {
            return this.dataOverallDownloadedAtStart;
        }

        @Generated
        public long getDataOverallDownloaded() {
            return this.dataOverallDownloaded;
        }

        @Generated
        public void setTimestamp(Timestamp timestamp) {
            this.timestamp = timestamp;
        }

        @Generated
        public void setDataOverallUploadedAtStart(long dataOverallUploadedAtStart) {
            this.dataOverallUploadedAtStart = dataOverallUploadedAtStart;
        }

        @Generated
        public void setDataOverallUploaded(long dataOverallUploaded) {
            this.dataOverallUploaded = dataOverallUploaded;
        }

        @Generated
        public void setDataOverallDownloadedAtStart(long dataOverallDownloadedAtStart) {
            this.dataOverallDownloadedAtStart = dataOverallDownloadedAtStart;
        }

        @Generated
        public void setDataOverallDownloaded(long dataOverallDownloaded) {
            this.dataOverallDownloaded = dataOverallDownloaded;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TrafficData)) {
                return false;
            }
            TrafficData other = (TrafficData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getDataOverallUploadedAtStart() != other.getDataOverallUploadedAtStart()) {
                return false;
            }
            if (this.getDataOverallUploaded() != other.getDataOverallUploaded()) {
                return false;
            }
            if (this.getDataOverallDownloadedAtStart() != other.getDataOverallDownloadedAtStart()) {
                return false;
            }
            if (this.getDataOverallDownloaded() != other.getDataOverallDownloaded()) {
                return false;
            }
            Timestamp this$timestamp = this.getTimestamp();
            Timestamp other$timestamp = other.getTimestamp();
            return !(this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TrafficData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $dataOverallUploadedAtStart = this.getDataOverallUploadedAtStart();
            result = result * 59 + (int)($dataOverallUploadedAtStart >>> 32 ^ $dataOverallUploadedAtStart);
            long $dataOverallUploaded = this.getDataOverallUploaded();
            result = result * 59 + (int)($dataOverallUploaded >>> 32 ^ $dataOverallUploaded);
            long $dataOverallDownloadedAtStart = this.getDataOverallDownloadedAtStart();
            result = result * 59 + (int)($dataOverallDownloadedAtStart >>> 32 ^ $dataOverallDownloadedAtStart);
            long $dataOverallDownloaded = this.getDataOverallDownloaded();
            result = result * 59 + (int)($dataOverallDownloaded >>> 32 ^ $dataOverallDownloaded);
            Timestamp $timestamp = this.getTimestamp();
            result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TrafficJournalDao.TrafficData(timestamp=" + String.valueOf(this.getTimestamp()) + ", dataOverallUploadedAtStart=" + this.getDataOverallUploadedAtStart() + ", dataOverallUploaded=" + this.getDataOverallUploaded() + ", dataOverallDownloadedAtStart=" + this.getDataOverallDownloadedAtStart() + ", dataOverallDownloaded=" + this.getDataOverallDownloaded() + ")";
        }

        @Generated
        public TrafficData() {
        }

        @Generated
        public TrafficData(Timestamp timestamp, long dataOverallUploadedAtStart, long dataOverallUploaded, long dataOverallDownloadedAtStart, long dataOverallDownloaded) {
            this.timestamp = timestamp;
            this.dataOverallUploadedAtStart = dataOverallUploadedAtStart;
            this.dataOverallUploaded = dataOverallUploaded;
            this.dataOverallDownloadedAtStart = dataOverallDownloadedAtStart;
            this.dataOverallDownloaded = dataOverallDownloaded;
        }
    }
}

