/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module.impl.rule;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.bittorrent.peer.Peer;
import com.ghostchu.peerbanhelper.bittorrent.torrent.Torrent;
import com.ghostchu.peerbanhelper.downloader.Downloader;
import com.ghostchu.peerbanhelper.module.AbstractRuleFeatureModule;
import com.ghostchu.peerbanhelper.module.CheckResult;
import com.ghostchu.peerbanhelper.module.PeerAction;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.wrapper.StructuredData;
import com.ghostchu.simplereloadlib.ReloadResult;
import com.ghostchu.simplereloadlib.Reloadable;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public final class AntiVampire
extends AbstractRuleFeatureModule
implements Reloadable {
    private long banDuration;
    private boolean xunleiPreset;

    @Override
    @NotNull
    public String getName() {
        return "Anti Vampire";
    }

    @Override
    @NotNull
    public String getConfigName() {
        return "anti-vampire";
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public void onEnable() {
        this.reloadConfig();
        Main.getReloadManager().register((Reloadable)this);
    }

    @Override
    public boolean isThreadSafe() {
        return true;
    }

    @Override
    public void onDisable() {
        Main.getReloadManager().unregister((Reloadable)this);
    }

    public ReloadResult reloadModule() throws Exception {
        this.reloadConfig();
        return super.reloadModule();
    }

    public void reloadConfig() {
        this.banDuration = this.getConfig().getLong("ban-duration", 0L);
        this.xunleiPreset = this.getConfig().getBoolean("presets.xunlei.enabled");
    }

    @Override
    @NotNull
    public CheckResult shouldBanPeer(@NotNull Torrent torrent, @NotNull Peer peer, @NotNull Downloader downloader) {
        CheckResult checkResult;
        if (this.xunleiPreset && (checkResult = this.checkXunleiPreset(torrent, peer, downloader)) != null) {
            return checkResult;
        }
        return this.pass();
    }

    private CheckResult checkXunleiPreset(@NotNull Torrent torrent, @NotNull Peer peer, @NotNull Downloader downloader) {
        String clientName;
        String peerId;
        boolean isXunlei = false;
        boolean isXunlei0019 = false;
        if (peer.getPeerId() != null && (peerId = peer.getPeerId().toLowerCase(Locale.ROOT)).startsWith("-xl")) {
            isXunlei = true;
            if (peerId.startsWith("-xl0019")) {
                isXunlei0019 = true;
            }
        }
        if (peer.getClientName() != null && (clientName = peer.getClientName().toLowerCase(Locale.ROOT)).startsWith("xunlei")) {
            isXunlei = true;
            if (clientName.contains("0019") || clientName.contains("0.0.1.9")) {
                isXunlei0019 = true;
            }
        }
        if (!isXunlei) {
            return null;
        }
        if (!isXunlei0019) {
            return new CheckResult(this.getClass(), PeerAction.BAN, this.banDuration, new TranslationComponent(Lang.MODULE_ANTI_VAMPIRE_TITLE), new TranslationComponent(Lang.MODULE_ANTI_VAMPIRE_DESCRIPTION_XUNLEI_NON_0019), StructuredData.create().add("xunleiType", "non-0019").add("seeding", torrent.isSeeding()));
        }
        if (torrent.isSeeding()) {
            return new CheckResult(this.getClass(), PeerAction.BAN, this.banDuration, new TranslationComponent(Lang.MODULE_ANTI_VAMPIRE_TITLE), new TranslationComponent(Lang.MODULE_ANTI_VAMPIRE_DESCRIPTION_XUNLEI_0019_SEEDING), StructuredData.create().add("xunleiType", "0019").add("seeding", torrent.isSeeding()));
        }
        return null;
    }
}

