/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module.impl.webapi;

import com.ghostchu.peerbanhelper.database.dao.impl.AlertDao;
import com.ghostchu.peerbanhelper.database.table.AlertEntity;
import com.ghostchu.peerbanhelper.module.AbstractFeatureModule;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.AlertDTO;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.util.query.Page;
import com.ghostchu.peerbanhelper.util.query.Pageable;
import com.ghostchu.peerbanhelper.web.JavalinWebContainer;
import com.ghostchu.peerbanhelper.web.Role;
import com.ghostchu.peerbanhelper.web.wrapper.StdResp;
import io.javalin.Javalin;
import io.javalin.http.Context;
import io.javalin.security.RouteRole;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class PBHAlertController
extends AbstractFeatureModule {
    @Autowired
    private JavalinWebContainer webContainer;
    @Autowired
    private AlertDao alertDao;

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    @NotNull
    public String getName() {
        return "WebAPI - Alerts";
    }

    @Override
    @NotNull
    public String getConfigName() {
        return "webapi-alerts";
    }

    @Override
    public void onEnable() {
        ((Javalin)((Javalin)((Javalin)this.webContainer.javalin().get("/api/alerts", this::handleListing, new RouteRole[]{Role.USER_READ})).patch("/api/alert/{id}/dismiss", this::handleRead, new RouteRole[]{Role.USER_WRITE})).post("/api/alert/dismissAll", this::handleAllRead, new RouteRole[]{Role.USER_WRITE})).delete("/api/alert/{id}", this::handleDelete, new RouteRole[]{Role.USER_WRITE});
    }

    private void handleAllRead(Context context) throws SQLException {
        this.alertDao.markAllAsRead();
        context.json((Object)new StdResp(true, "OK!", null));
    }

    private void handleListing(Context ctx) throws SQLException {
        ctx.status(200);
        if (ctx.queryParam("unread") != null && Boolean.parseBoolean(ctx.queryParam("unread"))) {
            ctx.json((Object)new StdResp(true, null, this.alertDao.getUnreadAlertsUnPaged().stream().map(alert -> new AlertDTO(alert.getId(), alert.getCreateAt(), alert.getReadAt(), alert.getLevel(), alert.getIdentifier(), TextManager.tl(this.locale(ctx), alert.getTitle()), TextManager.tl(this.locale(ctx), alert.getContent()))).toList()));
        } else {
            Page alerts = this.alertDao.queryByPaging(new Pageable(ctx));
            Page<AlertDTO> newAlerts = new Page<AlertDTO>(alerts.getPage(), alerts.getSize(), alerts.getTotal(), alerts.getResults().stream().map(alert -> new AlertDTO(alert.getId(), alert.getCreateAt(), alert.getReadAt(), alert.getLevel(), alert.getIdentifier(), TextManager.tl(this.locale(ctx), alert.getTitle()), TextManager.tl(this.locale(ctx), alert.getContent()))).toList());
            ctx.json((Object)new StdResp(true, null, newAlerts));
        }
    }

    private void handleRead(Context ctx) throws SQLException {
        long id = Long.parseLong(ctx.pathParam("id"));
        AlertEntity entity = (AlertEntity)this.alertDao.queryForId(id);
        entity.setReadAt(new Timestamp(System.currentTimeMillis()));
        this.alertDao.update(entity);
        ctx.status(200);
        ctx.json((Object)new StdResp(true, "OK", null));
    }

    private void handleDelete(Context ctx) throws SQLException {
        this.alertDao.deleteById(Long.parseLong(ctx.pathParam("id")));
        ctx.status(200);
        ctx.json((Object)new StdResp(true, "OK", null));
    }

    @Override
    public void onDisable() {
    }
}

