/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.pbhplus;

import com.ghostchu.peerbanhelper.util.HTTPUtil;
import com.ghostchu.peerbanhelper.util.json.JsonUtil;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LicenseDownloader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LicenseDownloader.class);
    private final HTTPUtil httpUtil;

    public LicenseDownloader(HTTPUtil httpUtil) {
        this.httpUtil = httpUtil;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public String attemptDownloadFromServer(@NotNull String text) {
        OkHttpClient httpClient = this.httpUtil.newBuilder().callTimeout(15L, TimeUnit.SECONDS).build();
        HttpUrl.Builder urlBuilder = new HttpUrl.Builder().scheme("https").host("api.pbh-btn.com").addPathSegment("peerbanhelper").addPathSegment("v1").addPathSegment("licenses").addPathSegment("download").addQueryParameter("query", text);
        Request request = new Request.Builder().url(urlBuilder.build()).get().build();
        try (Response response = httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IllegalStateException(response.code() + " " + response.body().string());
            }
            if (response.code() == 204 || response.code() == 404) {
                String string2 = null;
                return string2;
            }
            ServerDownloadedLicense result = (ServerDownloadedLicense)JsonUtil.standard().fromJson(response.body().charStream(), ServerDownloadedLicense.class);
            String string = result.keyText;
            return string;
        }
        catch (Exception e) {
            log.warn("Failed to download the license from server", (Throwable)e);
            return null;
        }
    }

    public static class ServerDownloadedLicense {
        private String keyText;
    }
}

