/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.wrapper;

import com.ghostchu.peerbanhelper.bittorrent.peer.Peer;
import com.ghostchu.peerbanhelper.wrapper.PeerAddress;
import lombok.Generated;

public final class PeerWrapper {
    private PeerAddress address;
    private String rawIp;
    private String id;
    private String clientName;
    private long downloaded;
    private long downloadSpeed;
    private long uploaded;
    private long uploadSpeed;
    private double progress;
    private String flags;

    public PeerWrapper(Peer peer) {
        this.id = peer.getPeerId();
        this.rawIp = peer.getPeerAddress().getRawIp();
        this.address = peer.getPeerAddress();
        this.clientName = peer.getClientName();
        this.downloaded = peer.getDownloaded();
        this.downloadSpeed = peer.getDownloadSpeed();
        this.uploaded = peer.getUploaded();
        this.uploadSpeed = peer.getUploadSpeed();
        this.progress = peer.getProgress();
        this.flags = peer.getFlags() == null ? null : peer.getFlags().getLtStdString();
    }

    public PeerAddress toPeerAddress() {
        return new PeerAddress(this.address.getIp(), this.address.getPort(), this.rawIp);
    }

    @Generated
    public PeerAddress getAddress() {
        return this.address;
    }

    @Generated
    public String getRawIp() {
        return this.rawIp;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getClientName() {
        return this.clientName;
    }

    @Generated
    public long getDownloaded() {
        return this.downloaded;
    }

    @Generated
    public long getDownloadSpeed() {
        return this.downloadSpeed;
    }

    @Generated
    public long getUploaded() {
        return this.uploaded;
    }

    @Generated
    public long getUploadSpeed() {
        return this.uploadSpeed;
    }

    @Generated
    public double getProgress() {
        return this.progress;
    }

    @Generated
    public String getFlags() {
        return this.flags;
    }

    @Generated
    public void setAddress(PeerAddress address) {
        this.address = address;
    }

    @Generated
    public void setRawIp(String rawIp) {
        this.rawIp = rawIp;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    @Generated
    public void setDownloaded(long downloaded) {
        this.downloaded = downloaded;
    }

    @Generated
    public void setDownloadSpeed(long downloadSpeed) {
        this.downloadSpeed = downloadSpeed;
    }

    @Generated
    public void setUploaded(long uploaded) {
        this.uploaded = uploaded;
    }

    @Generated
    public void setUploadSpeed(long uploadSpeed) {
        this.uploadSpeed = uploadSpeed;
    }

    @Generated
    public void setProgress(double progress) {
        this.progress = progress;
    }

    @Generated
    public void setFlags(String flags) {
        this.flags = flags;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PeerWrapper)) {
            return false;
        }
        PeerWrapper other = (PeerWrapper)o;
        if (this.getDownloaded() != other.getDownloaded()) {
            return false;
        }
        if (this.getDownloadSpeed() != other.getDownloadSpeed()) {
            return false;
        }
        if (this.getUploaded() != other.getUploaded()) {
            return false;
        }
        if (this.getUploadSpeed() != other.getUploadSpeed()) {
            return false;
        }
        if (Double.compare(this.getProgress(), other.getProgress()) != 0) {
            return false;
        }
        PeerAddress this$address = this.getAddress();
        PeerAddress other$address = other.getAddress();
        if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
            return false;
        }
        String this$rawIp = this.getRawIp();
        String other$rawIp = other.getRawIp();
        if (this$rawIp == null ? other$rawIp != null : !this$rawIp.equals(other$rawIp)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$clientName = this.getClientName();
        String other$clientName = other.getClientName();
        if (this$clientName == null ? other$clientName != null : !this$clientName.equals(other$clientName)) {
            return false;
        }
        String this$flags = this.getFlags();
        String other$flags = other.getFlags();
        return !(this$flags == null ? other$flags != null : !this$flags.equals(other$flags));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $downloaded = this.getDownloaded();
        result = result * 59 + (int)($downloaded >>> 32 ^ $downloaded);
        long $downloadSpeed = this.getDownloadSpeed();
        result = result * 59 + (int)($downloadSpeed >>> 32 ^ $downloadSpeed);
        long $uploaded = this.getUploaded();
        result = result * 59 + (int)($uploaded >>> 32 ^ $uploaded);
        long $uploadSpeed = this.getUploadSpeed();
        result = result * 59 + (int)($uploadSpeed >>> 32 ^ $uploadSpeed);
        long $progress = Double.doubleToLongBits(this.getProgress());
        result = result * 59 + (int)($progress >>> 32 ^ $progress);
        PeerAddress $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        String $rawIp = this.getRawIp();
        result = result * 59 + ($rawIp == null ? 43 : $rawIp.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $clientName = this.getClientName();
        result = result * 59 + ($clientName == null ? 43 : $clientName.hashCode());
        String $flags = this.getFlags();
        result = result * 59 + ($flags == null ? 43 : $flags.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PeerWrapper(address=" + String.valueOf(this.getAddress()) + ", rawIp=" + this.getRawIp() + ", id=" + this.getId() + ", clientName=" + this.getClientName() + ", downloaded=" + this.getDownloaded() + ", downloadSpeed=" + this.getDownloadSpeed() + ", uploaded=" + this.getUploaded() + ", uploadSpeed=" + this.getUploadSpeed() + ", progress=" + this.getProgress() + ", flags=" + this.getFlags() + ")";
    }

    @Generated
    public PeerWrapper() {
    }

    @Generated
    public PeerWrapper(PeerAddress address, String rawIp, String id, String clientName, long downloaded, long downloadSpeed, long uploaded, long uploadSpeed, double progress, String flags) {
        this.address = address;
        this.rawIp = rawIp;
        this.id = id;
        this.clientName = clientName;
        this.downloaded = downloaded;
        this.downloadSpeed = downloadSpeed;
        this.uploaded = uploaded;
        this.uploadSpeed = uploadSpeed;
        this.progress = progress;
        this.flags = flags;
    }
}

