/*
 * Decompiled with CFR 0.152.
 */
package raccoonfink.deluge.responses;

import org.json.JSONException;
import org.json.JSONObject;
import raccoonfink.deluge.DelugeException;
import raccoonfink.deluge.responses.DelugeResponse;

public final class ConnectedResponse
extends DelugeResponse {
    private final boolean m_connected;

    public ConnectedResponse(Integer httpResponseCode, JSONObject response) throws DelugeException {
        super(httpResponseCode, response);
        try {
            this.m_connected = response.getBoolean("result");
        }
        catch (JSONException e) {
            throw new DelugeException(e);
        }
    }

    public ConnectedResponse(Integer httpResponseCode, JSONObject response, boolean isConnected) throws DelugeException {
        super(httpResponseCode, response);
        this.m_connected = isConnected;
    }

    public boolean isConnected() {
        return this.m_connected;
    }

    @Override
    public JSONObject toResponseJSON() throws JSONException {
        JSONObject ret = super.toResponseJSON();
        ret.put("result", this.isConnected());
        return ret;
    }
}

