/*
 * Decompiled with CFR 0.152.
 */
package raccoonfink.deluge.responses;

import org.json.JSONException;
import org.json.JSONObject;
import raccoonfink.deluge.DelugeException;

public class DelugeResponse {
    private final int m_id;
    private final int m_responseCode;
    private final JSONObject m_result;

    public DelugeResponse(Integer httpResponseCode, JSONObject response) throws DelugeException {
        assert (httpResponseCode != null);
        try {
            this.m_id = response.getInt("id");
        }
        catch (JSONException e) {
            throw new DelugeException("Invalid 'id' field in JSON: " + String.valueOf(response), e);
        }
        this.m_responseCode = httpResponseCode;
        this.m_result = response;
    }

    public int getId() {
        return this.m_id;
    }

    public int getResponseCode() {
        return this.m_responseCode;
    }

    public JSONObject getResponseData() {
        return this.m_result;
    }

    public JSONObject toResponseJSON() throws JSONException {
        JSONObject ret = new JSONObject();
        ret.put("id", this.getId());
        ret.put("responseCode", this.getResponseCode());
        ret.put("result", JSONObject.NULL);
        return ret;
    }
}

