/*
 * Decompiled with CFR 0.152.
 */
package raccoonfink.deluge.responses;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import raccoonfink.deluge.DelugeEvent;
import raccoonfink.deluge.DelugeException;
import raccoonfink.deluge.responses.DelugeResponse;

public final class EventsResponse
extends DelugeResponse {
    private final List<DelugeEvent> m_events = new ArrayList<DelugeEvent>();

    public EventsResponse(Integer httpResponseCode, JSONObject result) throws DelugeException {
        super(httpResponseCode, result);
        if (!result.isNull("result")) {
            try {
                JSONArray res = result.getJSONArray("result");
                for (int i = 0; i < res.length(); ++i) {
                    this.m_events.add(new DelugeEvent(res.getJSONArray(i)));
                }
            }
            catch (JSONException e) {
                throw new DelugeException(e);
            }
        }
    }

    public List<DelugeEvent> getEvents() {
        return Collections.unmodifiableList(this.m_events);
    }

    @Override
    public JSONObject toResponseJSON() throws JSONException {
        JSONObject ret = super.toResponseJSON();
        for (DelugeEvent ev : this.m_events) {
            ret.append("result", (Object)ev.toJSON());
        }
        return ret;
    }
}

