/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper;

import com.ghostchu.peerbanhelper.BanList;
import com.ghostchu.peerbanhelper.DownloaderServer;
import com.ghostchu.peerbanhelper.ExternalSwitch;
import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.alert.AlertLevel;
import com.ghostchu.peerbanhelper.alert.AlertManager;
import com.ghostchu.peerbanhelper.bittorrent.peer.Peer;
import com.ghostchu.peerbanhelper.bittorrent.peer.PeerImpl;
import com.ghostchu.peerbanhelper.bittorrent.torrent.Torrent;
import com.ghostchu.peerbanhelper.bittorrent.torrent.TorrentImpl;
import com.ghostchu.peerbanhelper.databasent.routing.WriteTransactionTemplate;
import com.ghostchu.peerbanhelper.databasent.service.BanListService;
import com.ghostchu.peerbanhelper.downloader.Downloader;
import com.ghostchu.peerbanhelper.downloader.DownloaderLastStatus;
import com.ghostchu.peerbanhelper.downloader.DownloaderLoginResult;
import com.ghostchu.peerbanhelper.downloader.DownloaderManagerImpl;
import com.ghostchu.peerbanhelper.event.banwave.FeatureModuleExecuteEvent;
import com.ghostchu.peerbanhelper.event.banwave.LivePeersUpdatedEvent;
import com.ghostchu.peerbanhelper.event.banwave.PeerBanEvent;
import com.ghostchu.peerbanhelper.event.banwave.PeerUnbanEvent;
import com.ghostchu.peerbanhelper.exchange.ExchangeMap;
import com.ghostchu.peerbanhelper.metric.BasicMetrics;
import com.ghostchu.peerbanhelper.module.BatchMonitorFeatureModule;
import com.ghostchu.peerbanhelper.module.CheckResult;
import com.ghostchu.peerbanhelper.module.FeatureModule;
import com.ghostchu.peerbanhelper.module.ModuleManagerImpl;
import com.ghostchu.peerbanhelper.module.MonitorFeatureModule;
import com.ghostchu.peerbanhelper.module.PeerAction;
import com.ghostchu.peerbanhelper.module.RuleFeatureModule;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.CommonUtil;
import com.ghostchu.peerbanhelper.util.IPAddressUtil;
import com.ghostchu.peerbanhelper.util.MsgUtil;
import com.ghostchu.peerbanhelper.util.WatchDog;
import com.ghostchu.peerbanhelper.util.dns.DNSLookup;
import com.ghostchu.peerbanhelper.util.lab.Experiments;
import com.ghostchu.peerbanhelper.util.lab.Laboratory;
import com.ghostchu.peerbanhelper.wrapper.BanMetadata;
import com.ghostchu.peerbanhelper.wrapper.PeerAddress;
import com.ghostchu.peerbanhelper.wrapper.PeerMetadata;
import com.ghostchu.peerbanhelper.wrapper.StructuredData;
import com.ghostchu.simplereloadlib.ReloadResult;
import com.ghostchu.simplereloadlib.Reloadable;
import com.spotify.futures.CompletableFutures;
import inet.ipaddr.IPAddress;
import inet.ipaddr.format.util.AddressTrie;
import inet.ipaddr.format.util.AssociativeAddressTrie;
import inet.ipaddr.format.util.BinaryTreeNode;
import inet.ipaddr.format.util.DualIPv4v6Tries;
import io.sentry.Sentry;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public final class DownloaderServerImpl
implements Reloadable,
AutoCloseable,
DownloaderServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DownloaderServerImpl.class);
    private final DualIPv4v6Tries ignoreAddresses = new DualIPv4v6Tries();
    private final Lock banWaveLock = new ReentrantLock();
    private final BanList banList;
    private final Deque<ScheduledBanListOperation> scheduledBanListOperations = new ConcurrentLinkedDeque<ScheduledBanListOperation>();
    private final DownloaderManagerImpl downloaderManager;
    private final BasicMetrics metrics;
    private final ModuleManagerImpl moduleManager;
    private long banDuration;
    private Map<PeerAddress, List<PeerMetadata>> LIVE_PEERS = Collections.synchronizedMap(new HashMap());
    private boolean hideFinishLogs;
    private static final long BANLIST_SAVE_INTERVAL = 3600000L;
    private final CheckResult NO_MATCHES_CHECK_RESULT = new CheckResult(this.getClass(), PeerAction.NO_ACTION, 0L, new TranslationComponent("No Matches"), new TranslationComponent("No Matches"), StructuredData.create());
    private final AtomicBoolean needReApplyBanList = new AtomicBoolean();
    private ScheduledExecutorService BAN_WAVE_SERVICE;
    private WatchDog banWaveWatchDog;
    private final BanListService banListDao;
    private final DNSLookup dnsLookup;
    private final Laboratory laboratory;
    private boolean globalPaused = false;
    private final AlertManager alertManager;
    private final ExecutorService slaveWorkStealingService = Executors.newWorkStealingPool();
    private final ExecutorService mainWorkStealingService = Executors.newWorkStealingPool();
    private final WriteTransactionTemplate transactionTemplate;

    public DownloaderServerImpl(BanList banList, DownloaderManagerImpl downloaderManager, @Qualifier(value="persistMetrics") BasicMetrics metrics, ModuleManagerImpl moduleManager, BanListService banListDao, DNSLookup dnsLookup, Laboratory laboratory, AlertManager alertManager, WriteTransactionTemplate transactionTemplate) {
        this.banList = banList;
        this.downloaderManager = downloaderManager;
        this.metrics = metrics;
        this.banListDao = banListDao;
        this.dnsLookup = dnsLookup;
        this.moduleManager = moduleManager;
        this.laboratory = laboratory;
        this.alertManager = alertManager;
        this.transactionTemplate = transactionTemplate;
        Main.getReloadManager().register((Reloadable)this);
    }

    public ReloadResult reloadModule() throws Exception {
        this.load();
        return super.reloadModule();
    }

    public void load() {
        this.banDuration = Main.getProfileConfig().getLong("ban-duration");
        this.hideFinishLogs = Main.getMainConfig().getBoolean("logger.hide-finish-log");
        Main.getProfileConfig().getStringList("ignore-peers-from-addresses").forEach(ip -> {
            IPAddress ignored = IPAddressUtil.getIPAddress(ip);
            this.ignoreAddresses.add(ignored);
        });
        if (this.laboratory.isExperimentActivated(Experiments.ASYNC_BANLIST_APPLY.getExperiment())) {
            CompletableFuture.runAsync(this::reApplyBanListForDownloaders);
        } else {
            this.reApplyBanListForDownloaders();
        }
        this.unbanWhitelistedPeers();
        this.registerTimer();
    }

    @Override
    public void close() {
        this.metrics.close();
        this.saveBanList();
    }

    private void unbanWhitelistedPeers() {
        ArrayList list = new ArrayList();
        this.banList.forEach((addr, meta) -> {
            AddressTrie.TrieNode node = this.ignoreAddresses.elementsContaining(addr);
            if (node != null) {
                list.add(addr);
            }
        });
        list.forEach(this::scheduleUnBanPeer);
    }

    public void loadBanListToMemory() {
        if (!Main.getMainConfig().getBoolean("persist.banlist")) {
            return;
        }
        this.banList.reset();
        try {
            Map<IPAddress, BanMetadata> data = this.banListDao.readBanList();
            this.banList.addAll(data);
            log.info(TextManager.tlUI(Lang.LOAD_BANLIST_FROM_FILE, data.size()));
        }
        catch (Exception e) {
            log.error(TextManager.tlUI(Lang.ERR_UPDATE_BAN_LIST, new Object[0]), (Throwable)e);
        }
    }

    private void saveBanList() {
        if (!Main.getMainConfig().getBoolean("persist.banlist")) {
            return;
        }
        try {
            int count = this.banListDao.saveBanList(this.banList);
            log.info(TextManager.tlUI(Lang.SAVED_BANLIST, count));
        }
        catch (Exception e) {
            log.error(TextManager.tlUI(Lang.SAVE_BANLIST_FAILED, new Object[0]), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void banWave() {
        try {
            if (!this.banWaveLock.tryLock(3L, TimeUnit.SECONDS)) {
                return;
            }
            if (this.isGlobalPaused()) {
                if (this.needReApplyBanList.get()) {
                    this.reApplyBanListForDownloaders();
                }
                return;
            }
            this.banWaveWatchDog.setLastOperation("Ban wave - start", false);
            long startTimer = System.currentTimeMillis();
            this.banWaveWatchDog.setLastOperation("Reset last status", false);
            this.banWaveWatchDog.setLastOperation("Run scheduled tasks", true);
            this.downloaderManager.forEach(Downloader::runScheduleTasks);
            this.banWaveWatchDog.setLastOperation("Remove expired bans", false);
            Collection<BanMetadata> unbannedPeers = this.removeExpiredBans();
            CopyOnWriteArrayList bannedPeers = new CopyOnWriteArrayList();
            this.banWaveWatchDog.setLastOperation("Collect peers", true);
            Map<Downloader, Map<Torrent, List<Peer>>> peers = this.collectPeers();
            this.banWaveWatchDog.setLastOperation("Update live peers", false);
            this.updateLivePeers(peers);
            this.banWaveWatchDog.setLastOperation("Notify BatchMonitorFeatureModules", false);
            for (FeatureModule module : this.moduleManager.getModules()) {
                if (!(module instanceof BatchMonitorFeatureModule)) continue;
                BatchMonitorFeatureModule batchMonitorFeatureModule = (BatchMonitorFeatureModule)module;
                Main.getEventBus().post((Object)new FeatureModuleExecuteEvent(module));
                batchMonitorFeatureModule.onPeersRetrieved(peers);
            }
            peers.forEach((downloader, entry) -> {
                this.banWaveWatchDog.setLastOperation("Notify MonitorFeatureModules", false);
                for (FeatureModule module : this.moduleManager.getModules()) {
                    if (!(module instanceof MonitorFeatureModule)) continue;
                    MonitorFeatureModule monitorFeatureModule = (MonitorFeatureModule)module;
                    Main.getEventBus().post((Object)new FeatureModuleExecuteEvent(module));
                    entry.forEach((torrent, plist) -> monitorFeatureModule.onTorrentPeersRetrieved((Downloader)downloader, (Torrent)torrent, (List<Peer>)plist));
                }
            });
            ConcurrentHashMap<Downloader, List> downloaderBanDetailMap = new ConcurrentHashMap<Downloader, List>();
            this.banWaveWatchDog.setLastOperation("Check Bans", false);
            ((CompletableFuture)peers.keySet().stream().map(downloader -> CompletableFuture.runAsync(() -> {
                try {
                    downloaderBanDetailMap.put((Downloader)downloader, this.checkBans((Map)peers.get(downloader), (Downloader)downloader));
                }
                catch (Exception e) {
                    log.error("Unexpected fatal error occurred while checking bans!", (Throwable)e);
                    throw e;
                }
            }, this.mainWorkStealingService)).collect(CompletableFutures.joinList())).join();
            int scheduled = 0;
            while (!this.scheduledBanListOperations.isEmpty()) {
                ScheduledBanListOperation ops = this.scheduledBanListOperations.poll();
                ++scheduled;
                if (ops.ban()) {
                    ScheduledPeerBanning banning = (ScheduledPeerBanning)ops.object();
                    List banDetails = downloaderBanDetailMap.getOrDefault(banning.downloader(), new CopyOnWriteArrayList());
                    banDetails.add(banning.detail());
                    downloaderBanDetailMap.put(banning.downloader(), banDetails);
                    continue;
                }
                PeerAddress address = (PeerAddress)ops.object();
                BanMetadata banMetadata = this.banList.get(address);
                if (banMetadata == null) continue;
                unbannedPeers.add(banMetadata);
            }
            if (scheduled > 0) {
                log.info(TextManager.tlUI(Lang.SCHEDULED_OPERATIONS, scheduled));
            }
            this.banWaveWatchDog.setLastOperation("Add banned peers into banlist", false);
            Set<IPAddress> banlistClone = this.banList.copyKeySet();
            downloaderBanDetailMap.forEach((downloader, details) -> {
                try {
                    ((CompletableFuture)details.stream().map(detail -> CompletableFuture.runAsync(() -> {
                        try {
                            if (detail.result().action() == PeerAction.BAN || detail.result().action() == PeerAction.BAN_FOR_DISCONNECT) {
                                long actualBanDuration = this.banDuration;
                                if (detail.banDuration() > 0L) {
                                    actualBanDuration = detail.banDuration();
                                }
                                BanMetadata banMetadata = new BanMetadata(detail.result().moduleContext().getName(), UUID.randomUUID().toString().replace("-", ""), this.downloaderManager.getDownloadInfo(downloader.getId()), OffsetDateTime.now(), OffsetDateTime.now().plus(actualBanDuration, ChronoUnit.MILLIS), detail.result().action() == PeerAction.BAN_FOR_DISCONNECT, detail.result().action() == PeerAction.BAN_FOR_DISCONNECT, detail.result().action() == PeerAction.BAN_FOR_DISCONNECT, detail.torrent(), detail.peer(), detail.result().rule(), detail.result().reason(), detail.result().structuredData());
                                bannedPeers.add(banMetadata);
                                this.banPeer(banlistClone, banMetadata, detail.torrent(), detail.peer());
                                if (detail.result().action() != PeerAction.BAN_FOR_DISCONNECT) {
                                    log.info(TextManager.tlUI(Lang.BAN_PEER, detail.peer().getPeerAddress(), detail.peer().getPeerId(), detail.peer().getClientName(), detail.peer().getProgress(), detail.peer().getUploaded(), detail.peer().getDownloaded(), detail.torrent().getName(), TextManager.tlUI(detail.result().reason())));
                                }
                            }
                        }
                        catch (Exception e) {
                            log.error(TextManager.tlUI(Lang.BAN_PEER_EXCEPTION, new Object[0]), (Throwable)e);
                        }
                    }, this.mainWorkStealingService)).collect(CompletableFutures.joinList())).join();
                }
                catch (Exception e) {
                    log.error(TextManager.tlUI(Lang.UNABLE_COMPLETE_PEER_BAN_TASK, new Object[0]), (Throwable)e);
                }
            });
            this.banWaveWatchDog.setLastOperation("Apply banlist", true);
            if (!this.needReApplyBanList.get()) {
                ((CompletableFuture)this.downloaderManager.stream().map(downloader -> CompletableFuture.runAsync(() -> this.updateDownloader((Downloader)downloader, !bannedPeers.isEmpty() || !unbannedPeers.isEmpty(), bannedPeers, unbannedPeers, false), this.mainWorkStealingService)).collect(CompletableFutures.joinList())).join();
            } else {
                log.info(TextManager.tlUI(Lang.APPLYING_FULL_BANLIST_TO_DOWNLOADER, new Object[0]));
                ((CompletableFuture)this.downloaderManager.stream().map(downloader -> CompletableFuture.runAsync(() -> this.updateDownloader((Downloader)downloader, true, null, null, true), this.mainWorkStealingService)).collect(CompletableFutures.joinList())).join();
                this.needReApplyBanList.set(false);
            }
            if (!this.hideFinishLogs && !this.downloaderManager.isEmpty()) {
                long downloadersCount = peers.size();
                long torrentsCount = peers.values().stream().mapToLong(Map::size).sum();
                long peersCount = peers.values().stream().flatMap(e -> e.values().stream()).mapToLong(List::size).sum();
                log.info(TextManager.tlUI(Lang.BAN_WAVE_CHECK_COMPLETED, downloadersCount, torrentsCount, peersCount, bannedPeers.size(), unbannedPeers.size(), System.currentTimeMillis() - startTimer));
            }
            this.banWaveWatchDog.setLastOperation("Completed", false);
        }
        catch (InterruptedException e2) {
            log.error("Thread interrupted");
            Thread.currentThread().interrupt();
        }
        catch (Throwable throwable) {
            log.error(TextManager.tlUI(Lang.UNABLE_COMPLETE_SCHEDULE_TASKS, new Object[0]), throwable);
        }
        finally {
            this.banWaveWatchDog.feed();
            this.metrics.recordCheck();
            this.banWaveLock.unlock();
        }
    }

    private void reApplyBanListForDownloaders() {
        try {
            ArrayList futures = new ArrayList();
            this.downloaderManager.forEach(downloader -> futures.add(CompletableFuture.runAsync(() -> {
                if (downloader.login().success()) {
                    downloader.setBanList(this.banList.copyKeySet(), null, null, true);
                }
            })));
            CompletableFutures.allAsList(futures).join();
        }
        catch (Exception e) {
            log.error("Error re-applying ban list for downloaders", (Throwable)e);
        }
    }

    private List<BanDetail> checkBans(Map<Torrent, List<Peer>> provided, @NotNull Downloader downloader) {
        List<CompletableFuture<BanDetail>> futures = Collections.synchronizedList(new ArrayList());
        Semaphore semaphore = new Semaphore(Math.min(Math.max(Runtime.getRuntime().availableProcessors(), 4), ExternalSwitch.parseInt("pbh.checkParallelism", 32)));
        for (Torrent torrent : provided.keySet()) {
            List<Peer> peers = provided.get(torrent);
            for (Peer peer : peers) {
                futures.add(CompletableFuture.supplyAsync(() -> {
                    try {
                        semaphore.acquire();
                        CheckResult checkResult = this.checkBan(torrent, peer, downloader);
                        BanDetail banDetail = new BanDetail(torrent, peer, checkResult, checkResult.duration());
                        return banDetail;
                    }
                    catch (Exception e) {
                        log.error("Unexpected error occurred while checking bans", (Throwable)e);
                        BanDetail banDetail = null;
                        return banDetail;
                    }
                    finally {
                        semaphore.release();
                    }
                }, this.slaveWorkStealingService));
            }
        }
        return futures.stream().map(CompletableFuture::join).toList();
    }

    private void updateLivePeers(Map<Downloader, Map<Torrent, List<Peer>>> peers) {
        HashMap livePeers = new HashMap();
        peers.forEach((downloader, tasks) -> tasks.forEach((torrent, peer) -> peer.forEach(p -> {
            PeerAddress address = p.getPeerAddress();
            List data = livePeers.getOrDefault(address, new ArrayList());
            PeerMetadata metadata = new PeerMetadata(this.downloaderManager.getDownloadInfo((Downloader)downloader), (Torrent)torrent, (Peer)p);
            data.add(metadata);
            livePeers.put(address, data);
        })));
        this.LIVE_PEERS = Map.copyOf(livePeers);
        Main.getEventBus().post((Object)new LivePeersUpdatedEvent(this.LIVE_PEERS));
    }

    public void updateDownloader(@NotNull Downloader downloader, boolean updateBanList, @Nullable Collection<BanMetadata> added, @Nullable Collection<BanMetadata> removed, boolean applyFullList) {
        if (!updateBanList) {
            return;
        }
        try {
            DownloaderLoginResult loginResult = downloader.login();
            if (!loginResult.success()) {
                if (loginResult.status() != DownloaderLoginResult.Status.PAUSED) {
                    log.error(TextManager.tlUI(Lang.ERR_CLIENT_LOGIN_FAILURE_SKIP, downloader.getName(), downloader.getEndpoint(), TextManager.tlUI(loginResult.message())));
                    downloader.setLastStatus(DownloaderLastStatus.ERROR, loginResult.message());
                }
                return;
            }
            downloader.setLastStatus(DownloaderLastStatus.HEALTHY, loginResult.message());
            downloader.setBanList(this.banList.copyKeySet(), added, removed, applyFullList);
        }
        catch (Throwable th) {
            log.error(TextManager.tlUI(Lang.ERR_UPDATE_BAN_LIST, downloader.getName(), downloader.getEndpoint()), th);
            downloader.setLastStatus(DownloaderLastStatus.ERROR, new TranslationComponent(Lang.STATUS_TEXT_EXCEPTION, th.getClass().getName() + ": " + th.getMessage()));
        }
    }

    public Collection<BanMetadata> removeExpiredBans() {
        ArrayList<IPAddress> removeBan = new ArrayList<IPAddress>();
        ArrayList<BanMetadata> metadata = new ArrayList<BanMetadata>();
        this.banList.forEach((key, v) -> {
            if (OffsetDateTime.now().isAfter(v.getUnbanAt())) {
                removeBan.add((IPAddress)key);
                metadata.add((BanMetadata)v);
            }
        });
        this.unbanPeers(removeBan);
        long normalUnbanCount = metadata.stream().filter(meta -> !meta.isBanForDisconnect()).count();
        if (normalUnbanCount > 0L) {
            log.info(TextManager.tlUI(Lang.PEER_UNBAN_WAVE, normalUnbanCount));
        }
        return metadata;
    }

    public Map<Downloader, Map<Torrent, List<Peer>>> collectPeers() {
        Map<Downloader, Map<Torrent, List<Peer>>> peers = Collections.synchronizedMap(new HashMap());
        for (CompletableFuture future : this.downloaderManager.stream().map(downloader -> CompletableFuture.runAsync(() -> {
            try {
                Map<Torrent, List<Peer>> p = this.collectPeers((Downloader)downloader);
                if (p != null) {
                    peers.put((Downloader)downloader, p);
                }
            }
            catch (Exception e) {
                log.error(TextManager.tlUI(Lang.DOWNLOADER_UNHANDLED_EXCEPTION, new Object[0]), (Throwable)e);
            }
        }, this.slaveWorkStealingService)).toList()) {
            future.join();
        }
        return peers;
    }

    @Nullable
    public Map<Torrent, List<Peer>> collectPeers(Downloader downloader) {
        Map<Torrent, List<Peer>> peers = Collections.synchronizedMap(new HashMap());
        DownloaderLoginResult loginResult = downloader.login();
        if (!loginResult.success()) {
            if (loginResult.status() != DownloaderLoginResult.Status.PAUSED) {
                log.error(TextManager.tlUI(Lang.ERR_CLIENT_LOGIN_FAILURE_SKIP, downloader.getName(), downloader.getEndpoint(), TextManager.tlUI(loginResult.message())));
                downloader.setLastStatus(DownloaderLastStatus.ERROR, loginResult.message());
                if (loginResult.status() == DownloaderLoginResult.Status.MISSING_COMPONENTS || loginResult.status() == DownloaderLoginResult.Status.REQUIRE_TAKE_ACTIONS) {
                    downloader.setLastStatus(DownloaderLastStatus.NEED_TAKE_ACTION, loginResult.message());
                }
            }
            return null;
        }
        List<Torrent> torrents = downloader.getTorrents();
        ArrayList futures = new ArrayList();
        Semaphore parallelReqRestrict = new Semaphore(downloader.getMaxConcurrentPeerRequestSlots());
        torrents.forEach(torrent -> futures.add(CompletableFuture.runAsync(() -> {
            try {
                parallelReqRestrict.acquire();
                List<Peer> p = downloader.getPeers((Torrent)torrent);
                peers.put((Torrent)torrent, p);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                log.error(TextManager.tlUI(Lang.UNABLE_RETRIEVE_PEERS, new Object[0]), (Throwable)e);
            }
            finally {
                parallelReqRestrict.release();
            }
        }, this.slaveWorkStealingService)));
        futures.forEach(CompletableFuture::join);
        downloader.setLastStatus(DownloaderLastStatus.HEALTHY, new TranslationComponent(Lang.STATUS_TEXT_OK));
        return peers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CheckResult checkBan(@NotNull Torrent torrent, @NotNull Peer peer, @NotNull Downloader downloader) {
        ArrayList<CheckResult> results = new ArrayList<CheckResult>();
        AddressTrie.TrieNode node = this.ignoreAddresses.elementsContaining(peer.getPeerAddress().getAddress());
        if (node != null) {
            if (this.isPeerHavePossibleBadNatConfig(peer) && !this.alertManager.identifierAlertExistsIncludeRead("downloader-nat-setup-error@" + downloader.getId())) {
                this.alertManager.publishAlert(true, AlertLevel.ERROR, "downloader-nat-setup-error@" + downloader.getId(), new TranslationComponent(Lang.DOWNLOADER_DOCKER_INCORRECT_NETWORK_DETECTED_TITLE), new TranslationComponent(Lang.DOWNLOADER_DOCKER_INCORRECT_NETWORK_DETECTED_DESCRIPTION, downloader.getId(), peer.getPeerAddress().getAddress().toNormalizedString()));
            }
            return new CheckResult(this.getClass(), PeerAction.SKIP, 0L, new TranslationComponent("general-rule-ignored-address"), new TranslationComponent("general-reason-skip-ignored-peers"), StructuredData.create().add("type", "ignoredAddresses"));
        }
        try {
            for (FeatureModule registeredModule : this.moduleManager.getModules()) {
                if (!(registeredModule instanceof RuleFeatureModule)) continue;
                RuleFeatureModule module = (RuleFeatureModule)registeredModule;
                Main.getEventBus().post((Object)new FeatureModuleExecuteEvent(registeredModule));
                try {
                    CheckResult checkResult;
                    if (module.isThreadSafe()) {
                        checkResult = module.shouldBanPeer(torrent, peer, downloader);
                    } else {
                        registeredModule.getThreadLock().lock();
                        try {
                            checkResult = module.shouldBanPeer(torrent, peer, downloader);
                        }
                        finally {
                            registeredModule.getThreadLock().unlock();
                        }
                    }
                    if (checkResult.action() == PeerAction.SKIP) {
                        results.add(checkResult);
                    }
                    results.add(checkResult);
                }
                catch (Exception e) {
                    log.error(TextManager.tlUI(Lang.UNABLE_EXECUTE_MODULE, module.getName()), (Throwable)e);
                    Sentry.captureException((Throwable)e);
                }
            }
            CheckResult result = this.NO_MATCHES_CHECK_RESULT;
            for (CheckResult r : results) {
                if (r.action() == PeerAction.SKIP) {
                    result = r;
                    break;
                }
                if (r.action() != PeerAction.BAN && r.action() != PeerAction.BAN_FOR_DISCONNECT) continue;
                result = r;
            }
            return result;
        }
        catch (Exception e) {
            log.error("Failed to execute modules", (Throwable)e);
            Sentry.captureException((Throwable)e);
            return new CheckResult(this.getClass(), PeerAction.NO_ACTION, 0L, new TranslationComponent("ERROR"), new TranslationComponent("ERROR"), StructuredData.create().add("message", e.getMessage()).add("class", e.getClass().getName()).add("stackTrace", e.getStackTrace()));
        }
    }

    private boolean isPeerHavePossibleBadNatConfig(Peer peer) {
        if ((peer.getFlags() == null || peer.getFlags().isFromIncoming() || !peer.getFlags().isOutgoingConnection() || peer.getFlags().isFromTracker() || peer.getFlags().isFromDHT() || peer.getFlags().isFromPEX()) && !peer.isHandshaking()) {
            String addrStr;
            IPAddress addr = peer.getPeerAddress().getAddress();
            if (addr.isIPv4Convertible()) {
                addr = addr.toIPv4();
            }
            return !(!(addrStr = addr.toNormalizedString()).endsWith(".1") && !addrStr.endsWith(".0") || !addr.isLocal() && !addr.isAnyLocal());
        }
        return false;
    }

    @Override
    @NotNull
    public Map<PeerAddress, List<PeerMetadata>> getPeerSnapshot() {
        return this.LIVE_PEERS;
    }

    private void banPeer(@NotNull Set<IPAddress> compareWith, @NotNull BanMetadata banMetadata, @NotNull Torrent torrentObj, @NotNull Peer peer) {
        if (compareWith.contains(peer.getPeerAddress().getAddress())) {
            log.error(TextManager.tlUI(Lang.DUPLICATE_BAN, banMetadata));
            this.needReApplyBanList.set(true);
            log.warn(TextManager.tlUI(Lang.SCHEDULED_FULL_BANLIST_APPLY, new Object[0]));
        }
        this.banList.add(peer.getPeerAddress(), banMetadata);
        this.metrics.recordPeerBan(peer.getPeerAddress().getAddress(), banMetadata);
        banMetadata.setReverseLookup("N/A");
        if (Main.getMainConfig().getBoolean("lookup.dns-reverse-lookup")) {
            this.dnsLookup.ptr(peer.getPeerAddress().getAddress().toReverseDNSLookupString()).thenAccept(hostName -> {
                if (hostName.isPresent() && !peer.getPeerAddress().getIp().equals(hostName.get())) {
                    banMetadata.setReverseLookup((String)hostName.get());
                }
            });
        }
        Main.getEventBus().post((Object)new PeerBanEvent(peer.getPeerAddress(), banMetadata, torrentObj, peer));
    }

    @Override
    public void scheduleBanPeerNoAssign(@NotNull BanMetadata banMetadata, @NotNull Torrent torrent, @NotNull Peer peer) {
        Downloader downloader = this.downloaderManager.stream().filter(d -> d.getId().equals(banMetadata.getDownloader().id())).findFirst().orElseThrow();
        this.banPeer(this.banList.copyKeySet(), banMetadata, torrent, peer);
        this.scheduledBanListOperations.add(new ScheduledBanListOperation(true, new ScheduledPeerBanning(downloader, new BanDetail(torrent, peer, new CheckResult(this.getClass(), PeerAction.BAN, this.banDuration, new TranslationComponent(Lang.PEER_BAN_USER_OPERATE_TITLE), new TranslationComponent(Lang.PEER_BAN_USER_OPERATE_DESCRIPTION), StructuredData.create().add("type", "manually")), this.banDuration))));
    }

    @Override
    public void scheduleBanPeerNoAssign(@NotNull PeerAddress addr) {
        String mockTorrentHash = "00000000000000000000";
        TorrentImpl torrent = new TorrentImpl(mockTorrentHash, "User Operation", mockTorrentHash, 0L, 0L, 0.0, 0L, 0L, false);
        PeerImpl peer = new PeerImpl(addr, "-USROPS-".getBytes(StandardCharsets.ISO_8859_1), "User Operation", 0L, 0L, 0L, 0L, 0.0, null, false);
        long yearPlus100 = 3153600000000L;
        this.scheduledBanListOperations.add(new ScheduledBanListOperation(true, new ScheduledPeerBanning(this.downloaderManager.getDownloaders().getFirst(), new BanDetail(torrent, peer, new CheckResult(this.getClass(), PeerAction.BAN, this.banDuration, new TranslationComponent(Lang.PEER_BAN_USER_OPERATE_TITLE), new TranslationComponent(Lang.PEER_BAN_USER_OPERATE_DESCRIPTION, addr), StructuredData.create().add("type", "manually").add("ip", addr)), yearPlus100))));
    }

    @Override
    public void scheduleUnBanPeer(@NotNull PeerAddress peer) {
        this.unbanPeers(List.of(peer.getAddress()));
        this.scheduledBanListOperations.add(new ScheduledBanListOperation(false, peer));
    }

    @Override
    public void scheduleUnBanPeer(@NotNull IPAddress peer) {
        this.unbanPeers(List.of(peer));
        this.scheduledBanListOperations.add(new ScheduledBanListOperation(false, new PeerAddress(peer.toNormalizedString(), 0, peer.toNormalizedString())));
    }

    private List<// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable AssociativeAddressTrie.AssociativeTrieNode<? extends IPAddress, BanMetadata>> unbanPeers(List<IPAddress> addresses) {
        ArrayList<// Could not load outer class - annotation placement on inner may be incorrect
         @Nullable AssociativeAddressTrie.AssociativeTrieNode<? extends IPAddress, BanMetadata>> unbanned = new ArrayList<AssociativeAddressTrie.AssociativeTrieNode<? extends IPAddress, BanMetadata>>();
        for (IPAddress address : addresses) {
            AssociativeAddressTrie.AssociativeTrieNode<? extends IPAddress, BanMetadata> meta = this.banList.remove(address);
            if (meta == null) continue;
            unbanned.add(meta);
        }
        Map<IPAddress, BanMetadata> metadata = unbanned.stream().filter(Objects::nonNull).collect(Collectors.toMap(BinaryTreeNode::getKey, AssociativeAddressTrie.AssociativeTrieNode::getValue));
        if (!metadata.isEmpty()) {
            Main.getEventBus().post((Object)new PeerUnbanEvent(metadata));
        }
        if (!unbanned.isEmpty()) {
            unbanned.forEach(node -> this.metrics.recordPeerUnban((IPAddress)node.getKey(), (BanMetadata)node.getValue()));
        }
        return unbanned;
    }

    @Override
    public Map<PeerAddress, List<PeerMetadata>> getLivePeersSnapshot() {
        return this.LIVE_PEERS;
    }

    private void registerTimer() {
        CommonUtil.getScheduler().scheduleWithFixedDelay(this::saveBanList, 10000L, 3600000L, TimeUnit.MILLISECONDS);
        if (this.banWaveWatchDog != null) {
            this.banWaveWatchDog.close();
        }
        this.banWaveWatchDog = new WatchDog("BanWave Thread", Main.getProfileConfig().getLong("check-interval", 5000L) + 60000L, this::watchDogHungry, null);
        this.registerBanWaveTimer();
        this.banWaveWatchDog.start();
    }

    private void registerBanWaveTimer() {
        if (!(this.BAN_WAVE_SERVICE == null || this.BAN_WAVE_SERVICE.isShutdown() && this.BAN_WAVE_SERVICE.isTerminated())) {
            this.BAN_WAVE_SERVICE.shutdownNow();
        }
        this.BAN_WAVE_SERVICE = Executors.newScheduledThreadPool(1, r -> {
            Thread thread = new Thread(r);
            thread.setName("Ban Wave");
            thread.setDaemon(true);
            return thread;
        });
        this.BAN_WAVE_SERVICE.scheduleWithFixedDelay(this::banWave, 1L, Main.getProfileConfig().getLong("check-interval", 5000L), TimeUnit.MILLISECONDS);
    }

    @Override
    @NotNull
    public BanList getBanList() {
        return this.banList;
    }

    private void watchDogHungry() {
        StringBuilder threadDump = new StringBuilder(System.lineSeparator());
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo threadInfo : threadMXBean.dumpAllThreads(true, true)) {
            threadDump.append(MsgUtil.threadInfoToString(threadInfo));
        }
        threadDump.append("\n\n");
        long[] deadLockedThreads = threadMXBean.findDeadlockedThreads();
        long[] monitorDeadlockedThreads = threadMXBean.findMonitorDeadlockedThreads();
        if (deadLockedThreads != null) {
            threadDump.append("Deadlocked Threads:\n");
            ThreadInfo[] threadInfoArray = threadMXBean.getThreadInfo(deadLockedThreads);
            int n = threadInfoArray.length;
            for (int i = 0; i < n; ++i) {
                ThreadInfo threadInfo = threadInfoArray[i];
                threadDump.append(MsgUtil.threadInfoToString(threadInfo));
            }
        }
        if (monitorDeadlockedThreads != null) {
            threadDump.append("Monitor Deadlocked Threads:\n");
            for (ThreadInfo threadInfo : threadMXBean.getThreadInfo(monitorDeadlockedThreads)) {
                threadDump.append(MsgUtil.threadInfoToString(threadInfo));
            }
        }
        log.info(threadDump.toString());
        this.registerBanWaveTimer();
        Main.getGuiManager().createNotification(Level.WARN, TextManager.tlUI(Lang.BAN_WAVE_WATCH_DOG_TITLE, new Object[0]), TextManager.tlUI(Lang.BAN_WAVE_WATCH_DOG_DESCRIPTION, new Object[0]));
    }

    @Override
    public void setGlobalPaused(boolean globalPaused) {
        this.globalPaused = globalPaused;
        if (globalPaused) {
            ExchangeMap.GUI_DISPLAY_FLAGS.add(new ExchangeMap.DisplayFlag("global-paused", 20, TextManager.tlUI(Lang.STATUS_BAR_GLOBAL_PAUSED, new Object[0])));
        } else {
            ExchangeMap.GUI_DISPLAY_FLAGS.removeIf(f -> "global-paused".equals(f.getId()));
        }
    }

    @Override
    @Generated
    public DualIPv4v6Tries getIgnoreAddresses() {
        return this.ignoreAddresses;
    }

    @Override
    @Generated
    public long getBanDuration() {
        return this.banDuration;
    }

    @Override
    @Generated
    public boolean isHideFinishLogs() {
        return this.hideFinishLogs;
    }

    @Override
    @Generated
    public AtomicBoolean getNeedReApplyBanList() {
        return this.needReApplyBanList;
    }

    @Override
    @Generated
    public boolean isGlobalPaused() {
        return this.globalPaused;
    }

    private record ScheduledBanListOperation(boolean ban, Object object) {
    }

    public record ScheduledPeerBanning(Downloader downloader, BanDetail detail) {
    }

    public record BanDetail(Torrent torrent, Peer peer, CheckResult result, long banDuration) {
    }
}

