/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.btn.ability.impl;

import com.ghostchu.peerbanhelper.btn.BtnNetwork;
import com.ghostchu.peerbanhelper.btn.ability.AbstractBtnAbility;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.URLUtil;
import com.ghostchu.peerbanhelper.util.json.JsonUtil;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BtnAbilityIpQuery
extends AbstractBtnAbility {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BtnAbilityIpQuery.class);
    private final BtnNetwork btnNetwork;
    private final String endpoint;
    private final boolean powCaptcha;
    private final String iframeEndpoint;

    public BtnAbilityIpQuery(BtnNetwork btnNetwork, JsonObject ability) {
        this.btnNetwork = btnNetwork;
        this.endpoint = ability.get("endpoint").getAsString();
        this.powCaptcha = ability.has("pow_captcha") && ability.get("pow_captcha").getAsBoolean();
        this.iframeEndpoint = ability.has("iframe_endpoint") ? ability.get("iframe_endpoint").getAsString() : null;
    }

    @Override
    public String getName() {
        return "BtnAbilityIpQuery";
    }

    @Override
    public TranslationComponent getDisplayName() {
        return new TranslationComponent(Lang.BTN_ABILITY_IP_QUERY_TITLE);
    }

    @Override
    public TranslationComponent getDescription() {
        return new TranslationComponent(Lang.BTN_ABILITY_IP_QUERY_DESCRIPTION);
    }

    @Override
    public void load() {
        this.setLastStatus(true, new TranslationComponent(Lang.BTN_STAND_BY));
    }

    @Nullable
    public IpQueryResult query(@NotNull String address) throws IOException {
        String url = URLUtil.appendUrl(this.endpoint, Map.of("ip", URLEncoder.encode(address, StandardCharsets.UTF_8)));
        Request.Builder request = new Request.Builder().url(url).get();
        if (this.powCaptcha) {
            this.btnNetwork.gatherAndSolveCaptchaBlocking(request, "ip_query");
        }
        try (Response response = this.btnNetwork.getHttpClient().newCall(request.build()).execute();){
            String responseBody = response.body().string();
            if (!response.isSuccessful()) {
                log.error(TextManager.tlUI(Lang.BTN_REQUEST_FAILS, response.code() + " - " + responseBody));
                this.setLastStatus(false, new TranslationComponent(Lang.BTN_HTTP_ERROR, response.code(), responseBody));
                throw new IOException("Unable perform query: " + response.code() + " - " + responseBody);
            }
            IpQueryResult result = (IpQueryResult)JsonUtil.getGson().fromJson(responseBody, IpQueryResult.class);
            this.setLastStatus(true, new TranslationComponent(Lang.BTN_ABILITY_IP_QUERY_STATUS_OK, address));
            IpQueryResult ipQueryResult = result;
            return ipQueryResult;
        }
    }

    @Override
    public void unload() {
    }

    @Generated
    public String getIframeEndpoint() {
        return this.iframeEndpoint;
    }

    public static class IpQueryResult {
        @SerializedName(value="color")
        private String color;
        @SerializedName(value="labels")
        private List<String> labels = Collections.emptyList();
        @SerializedName(value="bans")
        private IpQueryResultBans bans;
        @SerializedName(value="swarms")
        private IpQueryResultSwarms swarms;
        @SerializedName(value="traffic")
        private IpQueryTraffic traffic;
        @SerializedName(value="torrents")
        private IpQueryTorrents torrents;

        @Generated
        public IpQueryResult(String color, List<String> labels, IpQueryResultBans bans, IpQueryResultSwarms swarms, IpQueryTraffic traffic, IpQueryTorrents torrents) {
            this.color = color;
            this.labels = labels;
            this.bans = bans;
            this.swarms = swarms;
            this.traffic = traffic;
            this.torrents = torrents;
        }

        @Generated
        public IpQueryResult() {
        }

        @Generated
        public String getColor() {
            return this.color;
        }

        @Generated
        public List<String> getLabels() {
            return this.labels;
        }

        @Generated
        public IpQueryResultBans getBans() {
            return this.bans;
        }

        @Generated
        public IpQueryResultSwarms getSwarms() {
            return this.swarms;
        }

        @Generated
        public IpQueryTraffic getTraffic() {
            return this.traffic;
        }

        @Generated
        public IpQueryTorrents getTorrents() {
            return this.torrents;
        }

        @Generated
        public void setColor(String color) {
            this.color = color;
        }

        @Generated
        public void setLabels(List<String> labels) {
            this.labels = labels;
        }

        @Generated
        public void setBans(IpQueryResultBans bans) {
            this.bans = bans;
        }

        @Generated
        public void setSwarms(IpQueryResultSwarms swarms) {
            this.swarms = swarms;
        }

        @Generated
        public void setTraffic(IpQueryTraffic traffic) {
            this.traffic = traffic;
        }

        @Generated
        public void setTorrents(IpQueryTorrents torrents) {
            this.torrents = torrents;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IpQueryResult)) {
                return false;
            }
            IpQueryResult other = (IpQueryResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$color = this.getColor();
            String other$color = other.getColor();
            if (this$color == null ? other$color != null : !this$color.equals(other$color)) {
                return false;
            }
            List<String> this$labels = this.getLabels();
            List<String> other$labels = other.getLabels();
            if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
                return false;
            }
            IpQueryResultBans this$bans = this.getBans();
            IpQueryResultBans other$bans = other.getBans();
            if (this$bans == null ? other$bans != null : !((Object)this$bans).equals(other$bans)) {
                return false;
            }
            IpQueryResultSwarms this$swarms = this.getSwarms();
            IpQueryResultSwarms other$swarms = other.getSwarms();
            if (this$swarms == null ? other$swarms != null : !((Object)this$swarms).equals(other$swarms)) {
                return false;
            }
            IpQueryTraffic this$traffic = this.getTraffic();
            IpQueryTraffic other$traffic = other.getTraffic();
            if (this$traffic == null ? other$traffic != null : !((Object)this$traffic).equals(other$traffic)) {
                return false;
            }
            IpQueryTorrents this$torrents = this.getTorrents();
            IpQueryTorrents other$torrents = other.getTorrents();
            return !(this$torrents == null ? other$torrents != null : !((Object)this$torrents).equals(other$torrents));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof IpQueryResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $color = this.getColor();
            result = result * 59 + ($color == null ? 43 : $color.hashCode());
            List<String> $labels = this.getLabels();
            result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
            IpQueryResultBans $bans = this.getBans();
            result = result * 59 + ($bans == null ? 43 : ((Object)$bans).hashCode());
            IpQueryResultSwarms $swarms = this.getSwarms();
            result = result * 59 + ($swarms == null ? 43 : ((Object)$swarms).hashCode());
            IpQueryTraffic $traffic = this.getTraffic();
            result = result * 59 + ($traffic == null ? 43 : ((Object)$traffic).hashCode());
            IpQueryTorrents $torrents = this.getTorrents();
            result = result * 59 + ($torrents == null ? 43 : ((Object)$torrents).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BtnAbilityIpQuery.IpQueryResult(color=" + this.getColor() + ", labels=" + String.valueOf(this.getLabels()) + ", bans=" + String.valueOf(this.getBans()) + ", swarms=" + String.valueOf(this.getSwarms()) + ", traffic=" + String.valueOf(this.getTraffic()) + ", torrents=" + String.valueOf(this.getTorrents()) + ")";
        }

        public static class IpQueryResultBans {
            @SerializedName(value="duration")
            private long duration;
            @SerializedName(value="total")
            private long total;
            @SerializedName(value="records")
            private List<BanHistoryDto> records;

            @Generated
            public IpQueryResultBans(long duration, long total, List<BanHistoryDto> records) {
                this.duration = duration;
                this.total = total;
                this.records = records;
            }

            @Generated
            public IpQueryResultBans() {
            }

            @Generated
            public long getDuration() {
                return this.duration;
            }

            @Generated
            public long getTotal() {
                return this.total;
            }

            @Generated
            public List<BanHistoryDto> getRecords() {
                return this.records;
            }

            @Generated
            public void setDuration(long duration) {
                this.duration = duration;
            }

            @Generated
            public void setTotal(long total) {
                this.total = total;
            }

            @Generated
            public void setRecords(List<BanHistoryDto> records) {
                this.records = records;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof IpQueryResultBans)) {
                    return false;
                }
                IpQueryResultBans other = (IpQueryResultBans)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.getDuration() != other.getDuration()) {
                    return false;
                }
                if (this.getTotal() != other.getTotal()) {
                    return false;
                }
                List<BanHistoryDto> this$records = this.getRecords();
                List<BanHistoryDto> other$records = other.getRecords();
                return !(this$records == null ? other$records != null : !((Object)this$records).equals(other$records));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof IpQueryResultBans;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                long $duration = this.getDuration();
                result = result * 59 + (int)($duration >>> 32 ^ $duration);
                long $total = this.getTotal();
                result = result * 59 + (int)($total >>> 32 ^ $total);
                List<BanHistoryDto> $records = this.getRecords();
                result = result * 59 + ($records == null ? 43 : ((Object)$records).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "BtnAbilityIpQuery.IpQueryResult.IpQueryResultBans(duration=" + this.getDuration() + ", total=" + this.getTotal() + ", records=" + String.valueOf(this.getRecords()) + ")";
            }
        }

        public static class IpQueryResultSwarms {
            @SerializedName(value="duration")
            private long duration;
            @SerializedName(value="total")
            private long total;
            @SerializedName(value="records")
            private List<SwarmTrackerDto> records;
            @SerializedName(value="concurrent_download_torrents_count")
            private long concurrentDownloadTorrentsCount;
            @SerializedName(value="concurrent_seeding_torrents_count")
            private long concurrentSeedingTorrentsCount;

            @Generated
            public IpQueryResultSwarms(long duration, long total, List<SwarmTrackerDto> records, long concurrentDownloadTorrentsCount, long concurrentSeedingTorrentsCount) {
                this.duration = duration;
                this.total = total;
                this.records = records;
                this.concurrentDownloadTorrentsCount = concurrentDownloadTorrentsCount;
                this.concurrentSeedingTorrentsCount = concurrentSeedingTorrentsCount;
            }

            @Generated
            public IpQueryResultSwarms() {
            }

            @Generated
            public long getDuration() {
                return this.duration;
            }

            @Generated
            public long getTotal() {
                return this.total;
            }

            @Generated
            public List<SwarmTrackerDto> getRecords() {
                return this.records;
            }

            @Generated
            public long getConcurrentDownloadTorrentsCount() {
                return this.concurrentDownloadTorrentsCount;
            }

            @Generated
            public long getConcurrentSeedingTorrentsCount() {
                return this.concurrentSeedingTorrentsCount;
            }

            @Generated
            public void setDuration(long duration) {
                this.duration = duration;
            }

            @Generated
            public void setTotal(long total) {
                this.total = total;
            }

            @Generated
            public void setRecords(List<SwarmTrackerDto> records) {
                this.records = records;
            }

            @Generated
            public void setConcurrentDownloadTorrentsCount(long concurrentDownloadTorrentsCount) {
                this.concurrentDownloadTorrentsCount = concurrentDownloadTorrentsCount;
            }

            @Generated
            public void setConcurrentSeedingTorrentsCount(long concurrentSeedingTorrentsCount) {
                this.concurrentSeedingTorrentsCount = concurrentSeedingTorrentsCount;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof IpQueryResultSwarms)) {
                    return false;
                }
                IpQueryResultSwarms other = (IpQueryResultSwarms)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.getDuration() != other.getDuration()) {
                    return false;
                }
                if (this.getTotal() != other.getTotal()) {
                    return false;
                }
                if (this.getConcurrentDownloadTorrentsCount() != other.getConcurrentDownloadTorrentsCount()) {
                    return false;
                }
                if (this.getConcurrentSeedingTorrentsCount() != other.getConcurrentSeedingTorrentsCount()) {
                    return false;
                }
                List<SwarmTrackerDto> this$records = this.getRecords();
                List<SwarmTrackerDto> other$records = other.getRecords();
                return !(this$records == null ? other$records != null : !((Object)this$records).equals(other$records));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof IpQueryResultSwarms;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                long $duration = this.getDuration();
                result = result * 59 + (int)($duration >>> 32 ^ $duration);
                long $total = this.getTotal();
                result = result * 59 + (int)($total >>> 32 ^ $total);
                long $concurrentDownloadTorrentsCount = this.getConcurrentDownloadTorrentsCount();
                result = result * 59 + (int)($concurrentDownloadTorrentsCount >>> 32 ^ $concurrentDownloadTorrentsCount);
                long $concurrentSeedingTorrentsCount = this.getConcurrentSeedingTorrentsCount();
                result = result * 59 + (int)($concurrentSeedingTorrentsCount >>> 32 ^ $concurrentSeedingTorrentsCount);
                List<SwarmTrackerDto> $records = this.getRecords();
                result = result * 59 + ($records == null ? 43 : ((Object)$records).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "BtnAbilityIpQuery.IpQueryResult.IpQueryResultSwarms(duration=" + this.getDuration() + ", total=" + this.getTotal() + ", records=" + String.valueOf(this.getRecords()) + ", concurrentDownloadTorrentsCount=" + this.getConcurrentDownloadTorrentsCount() + ", concurrentSeedingTorrentsCount=" + this.getConcurrentSeedingTorrentsCount() + ")";
            }
        }

        public static class IpQueryTraffic {
            @SerializedName(value="duration")
            private long duration;
            @SerializedName(value="to_peer_traffic")
            private long toPeerTraffic;
            @SerializedName(value="from_peer_traffic")
            private long fromPeerTraffic;
            @SerializedName(value="share_ratio")
            private double shareRatio;

            @Generated
            public IpQueryTraffic(long duration, long toPeerTraffic, long fromPeerTraffic, double shareRatio) {
                this.duration = duration;
                this.toPeerTraffic = toPeerTraffic;
                this.fromPeerTraffic = fromPeerTraffic;
                this.shareRatio = shareRatio;
            }

            @Generated
            public IpQueryTraffic() {
            }

            @Generated
            public long getDuration() {
                return this.duration;
            }

            @Generated
            public long getToPeerTraffic() {
                return this.toPeerTraffic;
            }

            @Generated
            public long getFromPeerTraffic() {
                return this.fromPeerTraffic;
            }

            @Generated
            public double getShareRatio() {
                return this.shareRatio;
            }

            @Generated
            public void setDuration(long duration) {
                this.duration = duration;
            }

            @Generated
            public void setToPeerTraffic(long toPeerTraffic) {
                this.toPeerTraffic = toPeerTraffic;
            }

            @Generated
            public void setFromPeerTraffic(long fromPeerTraffic) {
                this.fromPeerTraffic = fromPeerTraffic;
            }

            @Generated
            public void setShareRatio(double shareRatio) {
                this.shareRatio = shareRatio;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof IpQueryTraffic)) {
                    return false;
                }
                IpQueryTraffic other = (IpQueryTraffic)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.getDuration() != other.getDuration()) {
                    return false;
                }
                if (this.getToPeerTraffic() != other.getToPeerTraffic()) {
                    return false;
                }
                if (this.getFromPeerTraffic() != other.getFromPeerTraffic()) {
                    return false;
                }
                return Double.compare(this.getShareRatio(), other.getShareRatio()) == 0;
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof IpQueryTraffic;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                long $duration = this.getDuration();
                result = result * 59 + (int)($duration >>> 32 ^ $duration);
                long $toPeerTraffic = this.getToPeerTraffic();
                result = result * 59 + (int)($toPeerTraffic >>> 32 ^ $toPeerTraffic);
                long $fromPeerTraffic = this.getFromPeerTraffic();
                result = result * 59 + (int)($fromPeerTraffic >>> 32 ^ $fromPeerTraffic);
                long $shareRatio = Double.doubleToLongBits(this.getShareRatio());
                result = result * 59 + (int)($shareRatio >>> 32 ^ $shareRatio);
                return result;
            }

            @Generated
            public String toString() {
                return "BtnAbilityIpQuery.IpQueryResult.IpQueryTraffic(duration=" + this.getDuration() + ", toPeerTraffic=" + this.getToPeerTraffic() + ", fromPeerTraffic=" + this.getFromPeerTraffic() + ", shareRatio=" + this.getShareRatio() + ")";
            }
        }

        public static class IpQueryTorrents {
            @SerializedName(value="duration")
            private long duration;
            @SerializedName(value="count")
            private long count;

            @Generated
            public IpQueryTorrents(long duration, long count) {
                this.duration = duration;
                this.count = count;
            }

            @Generated
            public IpQueryTorrents() {
            }

            @Generated
            public long getDuration() {
                return this.duration;
            }

            @Generated
            public long getCount() {
                return this.count;
            }

            @Generated
            public void setDuration(long duration) {
                this.duration = duration;
            }

            @Generated
            public void setCount(long count) {
                this.count = count;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof IpQueryTorrents)) {
                    return false;
                }
                IpQueryTorrents other = (IpQueryTorrents)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.getDuration() != other.getDuration()) {
                    return false;
                }
                return this.getCount() == other.getCount();
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof IpQueryTorrents;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                long $duration = this.getDuration();
                result = result * 59 + (int)($duration >>> 32 ^ $duration);
                long $count = this.getCount();
                result = result * 59 + (int)($count >>> 32 ^ $count);
                return result;
            }

            @Generated
            public String toString() {
                return "BtnAbilityIpQuery.IpQueryResult.IpQueryTorrents(duration=" + this.getDuration() + ", count=" + this.getCount() + ")";
            }
        }
    }

    public static class SwarmTrackerDto {
        @SerializedName(value="torrent")
        private String torrent;
        @SerializedName(value="peer_ip")
        private String peerIp;
        @SerializedName(value="peer_port")
        private Integer peerPort;
        @SerializedName(value="peer_id")
        private String peerId;
        @SerializedName(value="peer_client_name")
        private String peerClientName;
        @SerializedName(value="peer_progress")
        private Double peerProgress;
        @SerializedName(value="from_peer_traffic")
        private Long fromPeerTraffic;
        @SerializedName(value="to_peer_traffic")
        private Long toPeerTraffic;
        @SerializedName(value="from_peer_traffic_offset")
        private Long fromPeerTrafficOffset;
        @SerializedName(value="to_peer_traffic_offset")
        private Long toPeerTrafficOffset;
        @SerializedName(value="flags")
        private String flags;
        @SerializedName(value="first_time_seen")
        private Long firstTimeSeen;
        @SerializedName(value="last_time_seen")
        private Long lastTimeSeen;
        @SerializedName(value="user_progress")
        private double userProgress;

        @Generated
        public SwarmTrackerDto(String torrent, String peerIp, Integer peerPort, String peerId, String peerClientName, Double peerProgress, Long fromPeerTraffic, Long toPeerTraffic, Long fromPeerTrafficOffset, Long toPeerTrafficOffset, String flags, Long firstTimeSeen, Long lastTimeSeen, double userProgress) {
            this.torrent = torrent;
            this.peerIp = peerIp;
            this.peerPort = peerPort;
            this.peerId = peerId;
            this.peerClientName = peerClientName;
            this.peerProgress = peerProgress;
            this.fromPeerTraffic = fromPeerTraffic;
            this.toPeerTraffic = toPeerTraffic;
            this.fromPeerTrafficOffset = fromPeerTrafficOffset;
            this.toPeerTrafficOffset = toPeerTrafficOffset;
            this.flags = flags;
            this.firstTimeSeen = firstTimeSeen;
            this.lastTimeSeen = lastTimeSeen;
            this.userProgress = userProgress;
        }

        @Generated
        public SwarmTrackerDto() {
        }

        @Generated
        public String getTorrent() {
            return this.torrent;
        }

        @Generated
        public String getPeerIp() {
            return this.peerIp;
        }

        @Generated
        public Integer getPeerPort() {
            return this.peerPort;
        }

        @Generated
        public String getPeerId() {
            return this.peerId;
        }

        @Generated
        public String getPeerClientName() {
            return this.peerClientName;
        }

        @Generated
        public Double getPeerProgress() {
            return this.peerProgress;
        }

        @Generated
        public Long getFromPeerTraffic() {
            return this.fromPeerTraffic;
        }

        @Generated
        public Long getToPeerTraffic() {
            return this.toPeerTraffic;
        }

        @Generated
        public Long getFromPeerTrafficOffset() {
            return this.fromPeerTrafficOffset;
        }

        @Generated
        public Long getToPeerTrafficOffset() {
            return this.toPeerTrafficOffset;
        }

        @Generated
        public String getFlags() {
            return this.flags;
        }

        @Generated
        public Long getFirstTimeSeen() {
            return this.firstTimeSeen;
        }

        @Generated
        public Long getLastTimeSeen() {
            return this.lastTimeSeen;
        }

        @Generated
        public double getUserProgress() {
            return this.userProgress;
        }

        @Generated
        public void setTorrent(String torrent) {
            this.torrent = torrent;
        }

        @Generated
        public void setPeerIp(String peerIp) {
            this.peerIp = peerIp;
        }

        @Generated
        public void setPeerPort(Integer peerPort) {
            this.peerPort = peerPort;
        }

        @Generated
        public void setPeerId(String peerId) {
            this.peerId = peerId;
        }

        @Generated
        public void setPeerClientName(String peerClientName) {
            this.peerClientName = peerClientName;
        }

        @Generated
        public void setPeerProgress(Double peerProgress) {
            this.peerProgress = peerProgress;
        }

        @Generated
        public void setFromPeerTraffic(Long fromPeerTraffic) {
            this.fromPeerTraffic = fromPeerTraffic;
        }

        @Generated
        public void setToPeerTraffic(Long toPeerTraffic) {
            this.toPeerTraffic = toPeerTraffic;
        }

        @Generated
        public void setFromPeerTrafficOffset(Long fromPeerTrafficOffset) {
            this.fromPeerTrafficOffset = fromPeerTrafficOffset;
        }

        @Generated
        public void setToPeerTrafficOffset(Long toPeerTrafficOffset) {
            this.toPeerTrafficOffset = toPeerTrafficOffset;
        }

        @Generated
        public void setFlags(String flags) {
            this.flags = flags;
        }

        @Generated
        public void setFirstTimeSeen(Long firstTimeSeen) {
            this.firstTimeSeen = firstTimeSeen;
        }

        @Generated
        public void setLastTimeSeen(Long lastTimeSeen) {
            this.lastTimeSeen = lastTimeSeen;
        }

        @Generated
        public void setUserProgress(double userProgress) {
            this.userProgress = userProgress;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SwarmTrackerDto)) {
                return false;
            }
            SwarmTrackerDto other = (SwarmTrackerDto)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getUserProgress(), other.getUserProgress()) != 0) {
                return false;
            }
            Integer this$peerPort = this.getPeerPort();
            Integer other$peerPort = other.getPeerPort();
            if (this$peerPort == null ? other$peerPort != null : !((Object)this$peerPort).equals(other$peerPort)) {
                return false;
            }
            Double this$peerProgress = this.getPeerProgress();
            Double other$peerProgress = other.getPeerProgress();
            if (this$peerProgress == null ? other$peerProgress != null : !((Object)this$peerProgress).equals(other$peerProgress)) {
                return false;
            }
            Long this$fromPeerTraffic = this.getFromPeerTraffic();
            Long other$fromPeerTraffic = other.getFromPeerTraffic();
            if (this$fromPeerTraffic == null ? other$fromPeerTraffic != null : !((Object)this$fromPeerTraffic).equals(other$fromPeerTraffic)) {
                return false;
            }
            Long this$toPeerTraffic = this.getToPeerTraffic();
            Long other$toPeerTraffic = other.getToPeerTraffic();
            if (this$toPeerTraffic == null ? other$toPeerTraffic != null : !((Object)this$toPeerTraffic).equals(other$toPeerTraffic)) {
                return false;
            }
            Long this$fromPeerTrafficOffset = this.getFromPeerTrafficOffset();
            Long other$fromPeerTrafficOffset = other.getFromPeerTrafficOffset();
            if (this$fromPeerTrafficOffset == null ? other$fromPeerTrafficOffset != null : !((Object)this$fromPeerTrafficOffset).equals(other$fromPeerTrafficOffset)) {
                return false;
            }
            Long this$toPeerTrafficOffset = this.getToPeerTrafficOffset();
            Long other$toPeerTrafficOffset = other.getToPeerTrafficOffset();
            if (this$toPeerTrafficOffset == null ? other$toPeerTrafficOffset != null : !((Object)this$toPeerTrafficOffset).equals(other$toPeerTrafficOffset)) {
                return false;
            }
            Long this$firstTimeSeen = this.getFirstTimeSeen();
            Long other$firstTimeSeen = other.getFirstTimeSeen();
            if (this$firstTimeSeen == null ? other$firstTimeSeen != null : !((Object)this$firstTimeSeen).equals(other$firstTimeSeen)) {
                return false;
            }
            Long this$lastTimeSeen = this.getLastTimeSeen();
            Long other$lastTimeSeen = other.getLastTimeSeen();
            if (this$lastTimeSeen == null ? other$lastTimeSeen != null : !((Object)this$lastTimeSeen).equals(other$lastTimeSeen)) {
                return false;
            }
            String this$torrent = this.getTorrent();
            String other$torrent = other.getTorrent();
            if (this$torrent == null ? other$torrent != null : !this$torrent.equals(other$torrent)) {
                return false;
            }
            String this$peerIp = this.getPeerIp();
            String other$peerIp = other.getPeerIp();
            if (this$peerIp == null ? other$peerIp != null : !this$peerIp.equals(other$peerIp)) {
                return false;
            }
            String this$peerId = this.getPeerId();
            String other$peerId = other.getPeerId();
            if (this$peerId == null ? other$peerId != null : !this$peerId.equals(other$peerId)) {
                return false;
            }
            String this$peerClientName = this.getPeerClientName();
            String other$peerClientName = other.getPeerClientName();
            if (this$peerClientName == null ? other$peerClientName != null : !this$peerClientName.equals(other$peerClientName)) {
                return false;
            }
            String this$flags = this.getFlags();
            String other$flags = other.getFlags();
            return !(this$flags == null ? other$flags != null : !this$flags.equals(other$flags));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SwarmTrackerDto;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $userProgress = Double.doubleToLongBits(this.getUserProgress());
            result = result * 59 + (int)($userProgress >>> 32 ^ $userProgress);
            Integer $peerPort = this.getPeerPort();
            result = result * 59 + ($peerPort == null ? 43 : ((Object)$peerPort).hashCode());
            Double $peerProgress = this.getPeerProgress();
            result = result * 59 + ($peerProgress == null ? 43 : ((Object)$peerProgress).hashCode());
            Long $fromPeerTraffic = this.getFromPeerTraffic();
            result = result * 59 + ($fromPeerTraffic == null ? 43 : ((Object)$fromPeerTraffic).hashCode());
            Long $toPeerTraffic = this.getToPeerTraffic();
            result = result * 59 + ($toPeerTraffic == null ? 43 : ((Object)$toPeerTraffic).hashCode());
            Long $fromPeerTrafficOffset = this.getFromPeerTrafficOffset();
            result = result * 59 + ($fromPeerTrafficOffset == null ? 43 : ((Object)$fromPeerTrafficOffset).hashCode());
            Long $toPeerTrafficOffset = this.getToPeerTrafficOffset();
            result = result * 59 + ($toPeerTrafficOffset == null ? 43 : ((Object)$toPeerTrafficOffset).hashCode());
            Long $firstTimeSeen = this.getFirstTimeSeen();
            result = result * 59 + ($firstTimeSeen == null ? 43 : ((Object)$firstTimeSeen).hashCode());
            Long $lastTimeSeen = this.getLastTimeSeen();
            result = result * 59 + ($lastTimeSeen == null ? 43 : ((Object)$lastTimeSeen).hashCode());
            String $torrent = this.getTorrent();
            result = result * 59 + ($torrent == null ? 43 : $torrent.hashCode());
            String $peerIp = this.getPeerIp();
            result = result * 59 + ($peerIp == null ? 43 : $peerIp.hashCode());
            String $peerId = this.getPeerId();
            result = result * 59 + ($peerId == null ? 43 : $peerId.hashCode());
            String $peerClientName = this.getPeerClientName();
            result = result * 59 + ($peerClientName == null ? 43 : $peerClientName.hashCode());
            String $flags = this.getFlags();
            result = result * 59 + ($flags == null ? 43 : $flags.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BtnAbilityIpQuery.SwarmTrackerDto(torrent=" + this.getTorrent() + ", peerIp=" + this.getPeerIp() + ", peerPort=" + this.getPeerPort() + ", peerId=" + this.getPeerId() + ", peerClientName=" + this.getPeerClientName() + ", peerProgress=" + this.getPeerProgress() + ", fromPeerTraffic=" + this.getFromPeerTraffic() + ", toPeerTraffic=" + this.getToPeerTraffic() + ", fromPeerTrafficOffset=" + this.getFromPeerTrafficOffset() + ", toPeerTrafficOffset=" + this.getToPeerTrafficOffset() + ", flags=" + this.getFlags() + ", firstTimeSeen=" + this.getFirstTimeSeen() + ", lastTimeSeen=" + this.getLastTimeSeen() + ", userProgress=" + this.getUserProgress() + ")";
        }
    }

    public static class BanHistoryDto {
        @SerializedName(value="populate_time")
        private Long populateTime;
        @SerializedName(value="torrent")
        private String torrent;
        @SerializedName(value="peer_ip")
        private String peerIp;
        @SerializedName(value="peer_port")
        private Integer peerPort;
        @SerializedName(value="peer_id")
        private String peerId;
        @SerializedName(value="peer_client_name")
        private String peerClientName;
        @SerializedName(value="peer_progress")
        private Double peerProgress;
        @SerializedName(value="peer_flags")
        private String peerFlags;
        @SerializedName(value="reporter_progress")
        private Double reporterProgress;
        @SerializedName(value="to_peer_traffic")
        private Long toPeerTraffic;
        @SerializedName(value="from_peer_traffic")
        private Long fromPeerTraffic;
        @SerializedName(value="module_name")
        private String moduleName;
        @SerializedName(value="rule")
        private String rule;
        @SerializedName(value="description")
        private String description;
        @SerializedName(value="structured_data")
        private Map<String, Object> structuredData;

        @Generated
        public BanHistoryDto(Long populateTime, String torrent, String peerIp, Integer peerPort, String peerId, String peerClientName, Double peerProgress, String peerFlags, Double reporterProgress, Long toPeerTraffic, Long fromPeerTraffic, String moduleName, String rule, String description, Map<String, Object> structuredData) {
            this.populateTime = populateTime;
            this.torrent = torrent;
            this.peerIp = peerIp;
            this.peerPort = peerPort;
            this.peerId = peerId;
            this.peerClientName = peerClientName;
            this.peerProgress = peerProgress;
            this.peerFlags = peerFlags;
            this.reporterProgress = reporterProgress;
            this.toPeerTraffic = toPeerTraffic;
            this.fromPeerTraffic = fromPeerTraffic;
            this.moduleName = moduleName;
            this.rule = rule;
            this.description = description;
            this.structuredData = structuredData;
        }

        @Generated
        public BanHistoryDto() {
        }

        @Generated
        public Long getPopulateTime() {
            return this.populateTime;
        }

        @Generated
        public String getTorrent() {
            return this.torrent;
        }

        @Generated
        public String getPeerIp() {
            return this.peerIp;
        }

        @Generated
        public Integer getPeerPort() {
            return this.peerPort;
        }

        @Generated
        public String getPeerId() {
            return this.peerId;
        }

        @Generated
        public String getPeerClientName() {
            return this.peerClientName;
        }

        @Generated
        public Double getPeerProgress() {
            return this.peerProgress;
        }

        @Generated
        public String getPeerFlags() {
            return this.peerFlags;
        }

        @Generated
        public Double getReporterProgress() {
            return this.reporterProgress;
        }

        @Generated
        public Long getToPeerTraffic() {
            return this.toPeerTraffic;
        }

        @Generated
        public Long getFromPeerTraffic() {
            return this.fromPeerTraffic;
        }

        @Generated
        public String getModuleName() {
            return this.moduleName;
        }

        @Generated
        public String getRule() {
            return this.rule;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public Map<String, Object> getStructuredData() {
            return this.structuredData;
        }

        @Generated
        public void setPopulateTime(Long populateTime) {
            this.populateTime = populateTime;
        }

        @Generated
        public void setTorrent(String torrent) {
            this.torrent = torrent;
        }

        @Generated
        public void setPeerIp(String peerIp) {
            this.peerIp = peerIp;
        }

        @Generated
        public void setPeerPort(Integer peerPort) {
            this.peerPort = peerPort;
        }

        @Generated
        public void setPeerId(String peerId) {
            this.peerId = peerId;
        }

        @Generated
        public void setPeerClientName(String peerClientName) {
            this.peerClientName = peerClientName;
        }

        @Generated
        public void setPeerProgress(Double peerProgress) {
            this.peerProgress = peerProgress;
        }

        @Generated
        public void setPeerFlags(String peerFlags) {
            this.peerFlags = peerFlags;
        }

        @Generated
        public void setReporterProgress(Double reporterProgress) {
            this.reporterProgress = reporterProgress;
        }

        @Generated
        public void setToPeerTraffic(Long toPeerTraffic) {
            this.toPeerTraffic = toPeerTraffic;
        }

        @Generated
        public void setFromPeerTraffic(Long fromPeerTraffic) {
            this.fromPeerTraffic = fromPeerTraffic;
        }

        @Generated
        public void setModuleName(String moduleName) {
            this.moduleName = moduleName;
        }

        @Generated
        public void setRule(String rule) {
            this.rule = rule;
        }

        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @Generated
        public void setStructuredData(Map<String, Object> structuredData) {
            this.structuredData = structuredData;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BanHistoryDto)) {
                return false;
            }
            BanHistoryDto other = (BanHistoryDto)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$populateTime = this.getPopulateTime();
            Long other$populateTime = other.getPopulateTime();
            if (this$populateTime == null ? other$populateTime != null : !((Object)this$populateTime).equals(other$populateTime)) {
                return false;
            }
            Integer this$peerPort = this.getPeerPort();
            Integer other$peerPort = other.getPeerPort();
            if (this$peerPort == null ? other$peerPort != null : !((Object)this$peerPort).equals(other$peerPort)) {
                return false;
            }
            Double this$peerProgress = this.getPeerProgress();
            Double other$peerProgress = other.getPeerProgress();
            if (this$peerProgress == null ? other$peerProgress != null : !((Object)this$peerProgress).equals(other$peerProgress)) {
                return false;
            }
            Double this$reporterProgress = this.getReporterProgress();
            Double other$reporterProgress = other.getReporterProgress();
            if (this$reporterProgress == null ? other$reporterProgress != null : !((Object)this$reporterProgress).equals(other$reporterProgress)) {
                return false;
            }
            Long this$toPeerTraffic = this.getToPeerTraffic();
            Long other$toPeerTraffic = other.getToPeerTraffic();
            if (this$toPeerTraffic == null ? other$toPeerTraffic != null : !((Object)this$toPeerTraffic).equals(other$toPeerTraffic)) {
                return false;
            }
            Long this$fromPeerTraffic = this.getFromPeerTraffic();
            Long other$fromPeerTraffic = other.getFromPeerTraffic();
            if (this$fromPeerTraffic == null ? other$fromPeerTraffic != null : !((Object)this$fromPeerTraffic).equals(other$fromPeerTraffic)) {
                return false;
            }
            String this$torrent = this.getTorrent();
            String other$torrent = other.getTorrent();
            if (this$torrent == null ? other$torrent != null : !this$torrent.equals(other$torrent)) {
                return false;
            }
            String this$peerIp = this.getPeerIp();
            String other$peerIp = other.getPeerIp();
            if (this$peerIp == null ? other$peerIp != null : !this$peerIp.equals(other$peerIp)) {
                return false;
            }
            String this$peerId = this.getPeerId();
            String other$peerId = other.getPeerId();
            if (this$peerId == null ? other$peerId != null : !this$peerId.equals(other$peerId)) {
                return false;
            }
            String this$peerClientName = this.getPeerClientName();
            String other$peerClientName = other.getPeerClientName();
            if (this$peerClientName == null ? other$peerClientName != null : !this$peerClientName.equals(other$peerClientName)) {
                return false;
            }
            String this$peerFlags = this.getPeerFlags();
            String other$peerFlags = other.getPeerFlags();
            if (this$peerFlags == null ? other$peerFlags != null : !this$peerFlags.equals(other$peerFlags)) {
                return false;
            }
            String this$moduleName = this.getModuleName();
            String other$moduleName = other.getModuleName();
            if (this$moduleName == null ? other$moduleName != null : !this$moduleName.equals(other$moduleName)) {
                return false;
            }
            String this$rule = this.getRule();
            String other$rule = other.getRule();
            if (this$rule == null ? other$rule != null : !this$rule.equals(other$rule)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            Map<String, Object> this$structuredData = this.getStructuredData();
            Map<String, Object> other$structuredData = other.getStructuredData();
            return !(this$structuredData == null ? other$structuredData != null : !((Object)this$structuredData).equals(other$structuredData));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BanHistoryDto;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $populateTime = this.getPopulateTime();
            result = result * 59 + ($populateTime == null ? 43 : ((Object)$populateTime).hashCode());
            Integer $peerPort = this.getPeerPort();
            result = result * 59 + ($peerPort == null ? 43 : ((Object)$peerPort).hashCode());
            Double $peerProgress = this.getPeerProgress();
            result = result * 59 + ($peerProgress == null ? 43 : ((Object)$peerProgress).hashCode());
            Double $reporterProgress = this.getReporterProgress();
            result = result * 59 + ($reporterProgress == null ? 43 : ((Object)$reporterProgress).hashCode());
            Long $toPeerTraffic = this.getToPeerTraffic();
            result = result * 59 + ($toPeerTraffic == null ? 43 : ((Object)$toPeerTraffic).hashCode());
            Long $fromPeerTraffic = this.getFromPeerTraffic();
            result = result * 59 + ($fromPeerTraffic == null ? 43 : ((Object)$fromPeerTraffic).hashCode());
            String $torrent = this.getTorrent();
            result = result * 59 + ($torrent == null ? 43 : $torrent.hashCode());
            String $peerIp = this.getPeerIp();
            result = result * 59 + ($peerIp == null ? 43 : $peerIp.hashCode());
            String $peerId = this.getPeerId();
            result = result * 59 + ($peerId == null ? 43 : $peerId.hashCode());
            String $peerClientName = this.getPeerClientName();
            result = result * 59 + ($peerClientName == null ? 43 : $peerClientName.hashCode());
            String $peerFlags = this.getPeerFlags();
            result = result * 59 + ($peerFlags == null ? 43 : $peerFlags.hashCode());
            String $moduleName = this.getModuleName();
            result = result * 59 + ($moduleName == null ? 43 : $moduleName.hashCode());
            String $rule = this.getRule();
            result = result * 59 + ($rule == null ? 43 : $rule.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            Map<String, Object> $structuredData = this.getStructuredData();
            result = result * 59 + ($structuredData == null ? 43 : ((Object)$structuredData).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BtnAbilityIpQuery.BanHistoryDto(populateTime=" + this.getPopulateTime() + ", torrent=" + this.getTorrent() + ", peerIp=" + this.getPeerIp() + ", peerPort=" + this.getPeerPort() + ", peerId=" + this.getPeerId() + ", peerClientName=" + this.getPeerClientName() + ", peerProgress=" + this.getPeerProgress() + ", peerFlags=" + this.getPeerFlags() + ", reporterProgress=" + this.getReporterProgress() + ", toPeerTraffic=" + this.getToPeerTraffic() + ", fromPeerTraffic=" + this.getFromPeerTraffic() + ", moduleName=" + this.getModuleName() + ", rule=" + this.getRule() + ", description=" + this.getDescription() + ", structuredData=" + String.valueOf(this.getStructuredData()) + ")";
        }
    }
}

