/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.btn.legacy;

import com.ghostchu.peerbanhelper.btn.legacy.LegacyBtnExceptionRule;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.IPAddressUtil;
import com.ghostchu.peerbanhelper.util.rule.AbstractMatcher;
import com.ghostchu.peerbanhelper.util.rule.MatchResult;
import com.ghostchu.peerbanhelper.util.rule.MatchResultEnum;
import com.ghostchu.peerbanhelper.util.rule.Rule;
import com.ghostchu.peerbanhelper.util.rule.RuleParser;
import com.ghostchu.peerbanhelper.util.rule.matcher.IPMatcher;
import inet.ipaddr.format.util.DualIPv4v6AssociativeTries;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public final class LegacyBtnExceptionRuleParsed {
    private String version;
    private Map<String, List<Rule>> peerIdRules;
    private Map<String, List<Rule>> clientNameRules;
    private Map<String, List<Rule>> ipRules;
    private Map<String, List<Rule>> portRules;

    public LegacyBtnExceptionRuleParsed(LegacyBtnExceptionRule btnRule) {
        this.version = btnRule.getVersion();
        this.ipRules = this.parseIPRule(btnRule.getIpRules());
        this.portRules = this.parsePortRule(btnRule.getPortRules());
        this.peerIdRules = this.parseRule(btnRule.getPeerIdRules());
        this.clientNameRules = this.parseRule(btnRule.getClientNameRules());
    }

    private Map<String, List<Rule>> parsePortRule(Map<String, List<Integer>> portRules) {
        HashMap<String, List<Rule>> rules = new HashMap<String, List<Rule>>();
        portRules.forEach((k, v) -> {
            ArrayList<1> addresses = new ArrayList<1>();
            Iterator i$ = v.iterator();
            while (i$.hasNext()) {
                final int s = (Integer)i$.next();
                addresses.add(new AbstractMatcher(this){
                    final /* synthetic */ LegacyBtnExceptionRuleParsed this$0;
                    {
                        LegacyBtnExceptionRuleParsed legacyBtnExceptionRuleParsed = this$0;
                        Objects.requireNonNull(legacyBtnExceptionRuleParsed);
                        this.this$0 = legacyBtnExceptionRuleParsed;
                    }

                    @Override
                    @NotNull
                    public MatchResult match0(@NotNull String content) {
                        boolean hit = Integer.parseInt(content) == s;
                        return hit ? new MatchResult(MatchResultEnum.TRUE, new TranslationComponent(Lang.MATCH_CONDITION_PORT_MATCH)) : new MatchResult(MatchResultEnum.DEFAULT, new TranslationComponent("Port seems OK"));
                    }

                    @Override
                    public String metadata() {
                        return String.valueOf(s);
                    }

                    @Override
                    public TranslationComponent matcherName() {
                        return new TranslationComponent(Lang.BTN_PORT_RULE, this.this$0.version);
                    }

                    @Override
                    public String matcherIdentifier() {
                        return "btn-exception:port";
                    }
                });
            }
            rules.put((String)k, (List<Rule>)addresses);
        });
        return rules;
    }

    public Map<String, List<Rule>> parseIPRule(Map<String, List<String>> raw) {
        HashMap<String, List<Rule>> rules = new HashMap<String, List<Rule>>();
        raw.forEach((k, v) -> {
            DualIPv4v6AssociativeTries tries = new DualIPv4v6AssociativeTries();
            v.stream().map(IPAddressUtil::getIPAddress).forEach(arg_0 -> ((DualIPv4v6AssociativeTries)tries).add(arg_0));
            rules.put((String)k, (List<Rule>)List.of(new BtnRuleIpMatcher(this.version, (String)k, (String)k, List.of(tries))));
        });
        return rules;
    }

    public Map<String, List<Rule>> parseRule(Map<String, List<String>> raw) {
        HashMap<String, List<Rule>> rules = new HashMap<String, List<Rule>>();
        raw.forEach((k, v) -> rules.put((String)k, RuleParser.parse(v)));
        return rules;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public Map<String, List<Rule>> getPeerIdRules() {
        return this.peerIdRules;
    }

    @Generated
    public Map<String, List<Rule>> getClientNameRules() {
        return this.clientNameRules;
    }

    @Generated
    public Map<String, List<Rule>> getIpRules() {
        return this.ipRules;
    }

    @Generated
    public Map<String, List<Rule>> getPortRules() {
        return this.portRules;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setPeerIdRules(Map<String, List<Rule>> peerIdRules) {
        this.peerIdRules = peerIdRules;
    }

    @Generated
    public void setClientNameRules(Map<String, List<Rule>> clientNameRules) {
        this.clientNameRules = clientNameRules;
    }

    @Generated
    public void setIpRules(Map<String, List<Rule>> ipRules) {
        this.ipRules = ipRules;
    }

    @Generated
    public void setPortRules(Map<String, List<Rule>> portRules) {
        this.portRules = portRules;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LegacyBtnExceptionRuleParsed)) {
            return false;
        }
        LegacyBtnExceptionRuleParsed other = (LegacyBtnExceptionRuleParsed)o;
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        Map<String, List<Rule>> this$peerIdRules = this.getPeerIdRules();
        Map<String, List<Rule>> other$peerIdRules = other.getPeerIdRules();
        if (this$peerIdRules == null ? other$peerIdRules != null : !((Object)this$peerIdRules).equals(other$peerIdRules)) {
            return false;
        }
        Map<String, List<Rule>> this$clientNameRules = this.getClientNameRules();
        Map<String, List<Rule>> other$clientNameRules = other.getClientNameRules();
        if (this$clientNameRules == null ? other$clientNameRules != null : !((Object)this$clientNameRules).equals(other$clientNameRules)) {
            return false;
        }
        Map<String, List<Rule>> this$ipRules = this.getIpRules();
        Map<String, List<Rule>> other$ipRules = other.getIpRules();
        if (this$ipRules == null ? other$ipRules != null : !((Object)this$ipRules).equals(other$ipRules)) {
            return false;
        }
        Map<String, List<Rule>> this$portRules = this.getPortRules();
        Map<String, List<Rule>> other$portRules = other.getPortRules();
        return !(this$portRules == null ? other$portRules != null : !((Object)this$portRules).equals(other$portRules));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        Map<String, List<Rule>> $peerIdRules = this.getPeerIdRules();
        result = result * 59 + ($peerIdRules == null ? 43 : ((Object)$peerIdRules).hashCode());
        Map<String, List<Rule>> $clientNameRules = this.getClientNameRules();
        result = result * 59 + ($clientNameRules == null ? 43 : ((Object)$clientNameRules).hashCode());
        Map<String, List<Rule>> $ipRules = this.getIpRules();
        result = result * 59 + ($ipRules == null ? 43 : ((Object)$ipRules).hashCode());
        Map<String, List<Rule>> $portRules = this.getPortRules();
        result = result * 59 + ($portRules == null ? 43 : ((Object)$portRules).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LegacyBtnExceptionRuleParsed(version=" + this.getVersion() + ", peerIdRules=" + String.valueOf(this.getPeerIdRules()) + ", clientNameRules=" + String.valueOf(this.getClientNameRules()) + ", ipRules=" + String.valueOf(this.getIpRules()) + ", portRules=" + String.valueOf(this.getPortRules()) + ")";
    }

    public static class BtnRuleIpMatcher
    extends IPMatcher {
        private final String version;

        public BtnRuleIpMatcher(String version, String ruleId, String ruleName, List<DualIPv4v6AssociativeTries<String>> ruleData) {
            super(ruleId, ruleName, ruleData);
            this.version = version;
        }

        @Override
        @NotNull
        public TranslationComponent matcherName() {
            return new TranslationComponent(Lang.BTN_IP_RULE, this.version);
        }

        @Override
        public String matcherIdentifier() {
            return "btn-exception:ip";
        }
    }
}

