/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.driver.common;

import com.ghostchu.peerbanhelper.util.IPAddressUtil;
import inet.ipaddr.IPAddress;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import lombok.Generated;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MappedTypes(value={IPAddress.class})
public class BasicIPAddressTypeHandler
extends BaseTypeHandler<IPAddress> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BasicIPAddressTypeHandler.class);

    public void setNonNullParameter(PreparedStatement ps, int i, IPAddress parameter, JdbcType jdbcType) throws SQLException {
        ps.setString(i, parameter.toNormalizedString());
    }

    public IPAddress getNullableResult(ResultSet rs, String columnName) throws SQLException {
        String inetString = rs.getString(columnName);
        return this.parseInetAddress(inetString);
    }

    public IPAddress getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        String inetString = rs.getString(columnIndex);
        return this.parseInetAddress(inetString);
    }

    public IPAddress getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        String inetString = cs.getString(columnIndex);
        return this.parseInetAddress(inetString);
    }

    private IPAddress parseInetAddress(String inetString) {
        if (inetString == null) {
            return null;
        }
        try {
            return IPAddressUtil.getIPAddress(inetString);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid inet address: " + inetString, e);
        }
    }
}

