/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.driver.mysql;

import com.ghostchu.peerbanhelper.databasent.DatabaseType;
import com.ghostchu.peerbanhelper.databasent.driver.AbstractDatabaseDriver;
import java.io.IOException;
import javax.sql.DataSource;
import org.bspfsystems.yamlconfiguration.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.stone.beecp.BeeDataSource;

public class MySQLDatabaseDriver
extends AbstractDatabaseDriver {
    private final ConfigurationSection section;
    private final BeeDataSource dataSource;

    public MySQLDatabaseDriver(@NotNull ConfigurationSection section) throws IOException {
        this.section = section;
        String host = section.getString("host");
        int port = section.getInt("port");
        String database = section.getString("database");
        String username = section.getString("username");
        String password = section.getString("password");
        BeeDataSource beeDataSource = new BeeDataSource();
        beeDataSource.setJdbcUrl("jdbc:mysql://" + host + ":" + port + "/" + database + "?useSSL=false&serverTimezone=UTC&allowPublicKeyRetrieval=true");
        beeDataSource.setUsername(username);
        beeDataSource.setPassword(password);
        beeDataSource.setDriverClassName("com.mysql.cj.jdbc.Driver");
        beeDataSource.setMaxActive(10);
        beeDataSource.setMaxWait(30000L);
        beeDataSource.setIntervalOfClearTimeout(600000L);
        beeDataSource.setAliveTestSql("SELECT 1");
        beeDataSource.setFairMode(true);
        beeDataSource.addConnectionFactoryProperty("cachePrepStmts", (Object)"true");
        beeDataSource.addConnectionFactoryProperty("prepStmtCacheSize", (Object)"250");
        beeDataSource.addConnectionFactoryProperty("prepStmtCacheSqlLimit", (Object)"2048");
        this.dataSource = beeDataSource;
    }

    @Override
    @NotNull
    public DatabaseType getType() {
        return DatabaseType.MYSQL;
    }

    @Override
    @NotNull
    protected DataSource createReadDataSource() {
        return this.dataSource;
    }

    @Override
    @NotNull
    protected DataSource createWriteDataSource() {
        return this.dataSource;
    }
}

