/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.migration;

import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import io.sentry.Sentry;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLiteSchemaUpgrader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SQLiteSchemaUpgrader.class);
    private final Connection connection;

    public SQLiteSchemaUpgrader(Connection connection) {
        this.connection = connection;
    }

    public int getCurrentVersion() throws SQLException {
        try (Statement stmt = this.connection.createStatement();){
            stmt.execute("CREATE TABLE IF NOT EXISTS metadata (\"key\" VARCHAR PRIMARY KEY, \"value\" VARCHAR)");
        }
        String versionQuery = "SELECT value FROM metadata WHERE \"key\" = 'version'";
        try (Statement stmt = this.connection.createStatement();){
            int n;
            block23: {
                ResultSet rs;
                block21: {
                    int n2;
                    block22: {
                        rs = stmt.executeQuery(versionQuery);
                        try {
                            if (!rs.next()) break block21;
                            n2 = Integer.parseInt(rs.getString(1));
                            if (rs == null) break block22;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return n2;
                }
                n = this.detectInitialVersion();
                if (rs == null) break block23;
                rs.close();
            }
            return n;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private int detectInitialVersion() {
        try (Statement stmt = this.connection.createStatement();){
            int n;
            block15: {
                ResultSet rs = stmt.executeQuery("PRAGMA table_info(history)");
                try {
                    boolean hasDownloader = false;
                    while (rs.next()) {
                        String columnName = rs.getString("name");
                        if (!"downloader".equals(columnName)) continue;
                        hasDownloader = true;
                        break;
                    }
                    int n2 = n = hasDownloader ? 3 : 2;
                    if (rs == null) break block15;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return n;
        }
        catch (SQLException e) {
            return 20;
        }
    }

    public void upgradeToLatest() throws SQLException {
        int currentVersion = this.getCurrentVersion();
        if (currentVersion >= 20) {
            return;
        }
        log.info(TextManager.tlUI(Lang.DBNT_MIGRATOR_LEGACY_UPGRADE_PROCESS, currentVersion));
        int v = currentVersion;
        if (v < 3) {
            this.upgradeToV3();
            v = 3;
        }
        if (v < 6) {
            v = 6;
        }
        if (v == 6) {
            this.upgradeToV7();
            v = 7;
        }
        if (v == 7) {
            this.upgradeToV8();
            v = 8;
        }
        if (v == 8) {
            this.upgradeToV9();
            v = 9;
        }
        if (v == 9) {
            this.upgradeToV10();
            v = 10;
        }
        if (v == 10) {
            this.upgradeToV11();
            v = 11;
        }
        if (v <= 14) {
            this.upgradeToV15();
            v = 15;
        }
        if (v == 15) {
            this.upgradeToV16();
            v = 16;
        }
        if (v == 16) {
            v = 17;
        }
        if (v <= 18) {
            this.upgradeToV19();
            v = 19;
        }
        if (v <= 19) {
            this.upgradeToV20();
            v = 20;
        }
        this.updateVersion(v);
        log.info("SQLite schema upgrade completed to version {}", (Object)v);
    }

    private void upgradeToV3() {
        log.info("Upgrading to v3: Adding downloader column to history table");
        try (Statement stmt = this.connection.createStatement();){
            stmt.executeUpdate("ALTER TABLE history ADD COLUMN downloader VARCHAR DEFAULT ''");
        }
        catch (SQLException e) {
            log.warn("Failed to add downloader column (may already exist): {}", (Object)e.getMessage());
        }
    }

    private void upgradeToV7() {
        log.info("Upgrading to v7: Recreating alert table");
        try (Statement stmt = this.connection.createStatement();){
            stmt.executeUpdate("DROP TABLE IF EXISTS alert");
            stmt.executeUpdate("CREATE TABLE alert (id INTEGER PRIMARY KEY AUTOINCREMENT, createAt TIMESTAMP NOT NULL, readAt TIMESTAMP, level VARCHAR NOT NULL, identifier VARCHAR NOT NULL, title VARCHAR NOT NULL, content VARCHAR NOT NULL)");
        }
        catch (SQLException e) {
            log.error("Failed to recreate alert table: {}", (Object)e.getMessage());
            Sentry.captureException((Throwable)e);
        }
    }

    private void upgradeToV8() throws SQLException {
        log.info("Upgrading to v8: Recreating alert table again");
        this.upgradeToV7();
    }

    private void upgradeToV9() {
        log.info("Upgrading to v9: Adding privateTorrent column to torrents table");
        try (Statement stmt = this.connection.createStatement();){
            stmt.executeUpdate("ALTER TABLE torrents ADD COLUMN privateTorrent BOOLEAN NULL");
        }
        catch (SQLException e) {
            log.warn("Failed to add privateTorrent column (may already exist): {}", (Object)e.getMessage());
        }
    }

    private void upgradeToV10() {
        log.info("Upgrading to v10: Adding downloaderProgress column to history table");
        try (Statement stmt = this.connection.createStatement();){
            stmt.executeUpdate("ALTER TABLE history ADD COLUMN downloaderProgress DOUBLE NULL");
        }
        catch (SQLException e) {
            log.warn("Failed to add downloaderProgress column (may already exist): {}", (Object)e.getMessage());
        }
    }

    private void upgradeToV11() {
        log.info("Upgrading to v11: Adding speed columns to peer_records table");
        try (Statement stmt = this.connection.createStatement();){
            stmt.executeUpdate("ALTER TABLE peer_records ADD COLUMN uploadSpeed BIGINT NOT NULL DEFAULT 0");
            stmt.executeUpdate("ALTER TABLE peer_records ADD COLUMN downloadSpeed BIGINT NOT NULL DEFAULT 0");
        }
        catch (SQLException e) {
            log.warn("Failed to add speed columns (may already exist): {}", (Object)e.getMessage());
        }
    }

    private void upgradeToV15() {
        log.info("Upgrading to v15: Adding structuredData column to history table");
        try (Statement stmt = this.connection.createStatement();){
            stmt.executeUpdate("ALTER TABLE history ADD COLUMN structuredData TEXT NOT NULL DEFAULT '{}'");
        }
        catch (SQLException e) {
            log.warn("Failed to add structuredData column (may already exist): {}", (Object)e.getMessage());
        }
    }

    private void upgradeToV16() {
        log.info("Upgrading to v16: DownloaderName conversion (handled during migration)");
    }

    private void upgradeToV19() {
        log.info("Upgrading to v19: Clearing banlist for IPAddress format change");
        try (Statement stmt = this.connection.createStatement();){
            stmt.executeUpdate("DELETE FROM banlist");
        }
        catch (SQLException e) {
            log.warn("Failed to clear banlist: {}", (Object)e.getMessage());
        }
    }

    private void upgradeToV20() {
        log.info("Upgrading to v20: Adding port column to peer_records table");
        try (Statement stmt = this.connection.createStatement();){
            stmt.executeUpdate("ALTER TABLE peer_records ADD COLUMN port INT NOT NULL DEFAULT 0");
        }
        catch (SQLException e) {
            log.warn("Failed to add port column (may already exist): {}", (Object)e.getMessage());
        }
    }

    private void updateVersion(int version) throws SQLException {
        try (Statement stmt = this.connection.createStatement();){
            stmt.executeUpdate(String.format("INSERT OR REPLACE INTO metadata (\"key\", \"value\") VALUES ('version', '%d')", version));
        }
    }

    public boolean tableExists(String tableName) throws SQLException {
        String query = "SELECT name FROM sqlite_master WHERE type='table' AND name='" + tableName + "'";
        try (Statement stmt = this.connection.createStatement();){
            boolean bl;
            block12: {
                ResultSet rs = stmt.executeQuery(query);
                try {
                    bl = rs.next();
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
    }
}

