/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.migration.migrators;

import com.ghostchu.peerbanhelper.databasent.migration.MigrationContext;
import com.ghostchu.peerbanhelper.databasent.migration.TableMigrator;
import com.ghostchu.peerbanhelper.databasent.service.BanListService;
import com.ghostchu.peerbanhelper.databasent.table.BanListEntity;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BanListMigrator
implements TableMigrator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BanListMigrator.class);
    private final BanListService banListService;

    public BanListMigrator(BanListService banListService) {
        this.banListService = banListService;
    }

    @Override
    public String getTableName() {
        return "banlist";
    }

    @Override
    public int getMigrationOrder() {
        return 120;
    }

    @Override
    public boolean isTableAvailable(Connection sqliteConnection) throws Exception {
        String query = "SELECT name FROM sqlite_master WHERE type='table' AND name='banlist'";
        try (Statement stmt = sqliteConnection.createStatement();){
            boolean bl;
            block12: {
                ResultSet rs = stmt.executeQuery(query);
                try {
                    bl = rs.next();
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
    }

    @Override
    public long migrate(Connection sqliteConnection, MigrationContext context) throws Exception {
        String selectQuery = "SELECT address, metadata FROM banlist";
        long count = 0L;
        long totalCount = this.getTotalCount(sqliteConnection);
        long lastLogged = 0L;
        try (PreparedStatement ps = sqliteConnection.prepareStatement(selectQuery);
             ResultSet rs = ps.executeQuery();){
            ArrayList<BanListEntity> batch = new ArrayList<BanListEntity>();
            while (rs.next()) {
                try {
                    BanListEntity entity = new BanListEntity();
                    entity.setAddress(rs.getString("address"));
                    entity.setMetadata(rs.getString("metadata"));
                    batch.add(entity);
                    if (batch.size() < context.getBatchSize()) continue;
                    this.banListService.getBaseMapper().insertOrUpdate(batch);
                    batch.clear();
                    if (!MigrationContext.shouldLogProgress(count += (long)batch.size(), totalCount, lastLogged)) continue;
                    log.info(TextManager.tlUI(Lang.DBNT_MIGRATOR_MIGRATING_PROGRESS, count, totalCount, "banlist", MigrationContext.formatProgress(count, totalCount)));
                    lastLogged = count;
                }
                catch (Exception e) {
                    log.error("Failed to migrate banlist record: {}", (Object)e.getMessage());
                }
            }
            if (!batch.isEmpty()) {
                this.banListService.getBaseMapper().insertOrUpdate(batch);
                count += (long)batch.size();
            }
        }
        log.info(TextManager.tlUI(Lang.DBNT_MIGRATOR_MIGRATING_COMPLETED, count, "banlist"));
        context.incrementTotalRecords(count);
        return count;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getTotalCount(Connection sqliteConnection) {
        try (Statement stmt = sqliteConnection.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT COUNT(*) FROM banlist");){
            if (!rs.next()) return 0L;
            long l = rs.getLong(1);
            return l;
        }
        catch (Exception e) {
            log.warn("Failed to get total count for banlist table", (Throwable)e);
        }
        return 0L;
    }
}

