/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.migration.migrators;

import com.ghostchu.peerbanhelper.databasent.migration.MigrationContext;
import com.ghostchu.peerbanhelper.databasent.migration.TableMigrator;
import com.ghostchu.peerbanhelper.databasent.service.PeerRecordService;
import com.ghostchu.peerbanhelper.databasent.table.PeerRecordEntity;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.util.ipdb.IPDBManager;
import com.ghostchu.peerbanhelper.util.ipdb.IPGeoData;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerRecordMigrator
implements TableMigrator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PeerRecordMigrator.class);
    private final PeerRecordService peerRecordService;

    public PeerRecordMigrator(PeerRecordService peerRecordService) {
        this.peerRecordService = peerRecordService;
    }

    @Override
    public String getTableName() {
        return "peer_records";
    }

    @Override
    public int getMigrationOrder() {
        return 60;
    }

    @Override
    public boolean isTableAvailable(Connection sqliteConnection) throws Exception {
        String query = "SELECT name FROM sqlite_master WHERE type='table' AND name='peer_records'";
        try (Statement stmt = sqliteConnection.createStatement();){
            boolean bl;
            block12: {
                ResultSet rs = stmt.executeQuery(query);
                try {
                    bl = rs.next();
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
    }

    @Override
    public long migrate(Connection sqliteConnection, MigrationContext context) throws Exception {
        String selectQuery = "SELECT address, port, torrent_id, downloader, peerId, clientName,\n       uploaded, uploadedOffset, uploadSpeed, downloaded, downloadedOffset, downloadSpeed,\n       lastFlags, firstTimeSeen, lastTimeSeen\nFROM peer_records\nORDER BY id\n";
        long count = 0L;
        long totalCount = this.getTotalCount(sqliteConnection);
        try (PreparedStatement ps = sqliteConnection.prepareStatement(selectQuery);
             ResultSet rs = ps.executeQuery();){
            ArrayList<PeerRecordEntity> batch = new ArrayList<PeerRecordEntity>();
            while (rs.next()) {
                try {
                    PeerRecordEntity entity = this.mapResultSetToEntity(rs, context);
                    batch.add(entity);
                    if (batch.size() < context.getBatchSize()) continue;
                    this.saveBatch(batch);
                    batch.clear();
                    log.info(TextManager.tlUI(Lang.DBNT_MIGRATOR_MIGRATING_PROGRESS, count += (long)batch.size(), totalCount, "peer_records", MigrationContext.formatProgress(count, totalCount)));
                }
                catch (Exception e) {
                    log.error("Failed to migrate peer_record: {}", (Object)e.getMessage());
                }
            }
            if (!batch.isEmpty()) {
                this.saveBatch(batch);
                count += (long)batch.size();
            }
        }
        log.info(TextManager.tlUI(Lang.DBNT_MIGRATOR_MIGRATING_COMPLETED, count, "peer_records"));
        context.incrementTotalRecords(count);
        return count;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getTotalCount(Connection sqliteConnection) {
        try (Statement stmt = sqliteConnection.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT COUNT(*) FROM peer_records");){
            if (!rs.next()) return 0L;
            long l = rs.getLong(1);
            return l;
        }
        catch (Exception e) {
            log.warn("Failed to get total count for peer_records table", (Throwable)e);
        }
        return 0L;
    }

    private PeerRecordEntity mapResultSetToEntity(ResultSet rs, MigrationContext context) throws Exception {
        PeerRecordEntity entity = new PeerRecordEntity();
        String addressStr = rs.getString("address");
        InetAddress address = InetAddress.getByName(addressStr);
        entity.setAddress(address);
        entity.setPort(rs.getInt("port"));
        entity.setTorrentId(rs.getLong("torrent_id"));
        entity.setDownloader(rs.getString("downloader"));
        entity.setPeerId(rs.getString("peerId"));
        entity.setClientName(rs.getString("clientName"));
        entity.setUploaded(rs.getLong("uploaded"));
        entity.setUploadedOffset(rs.getLong("uploadedOffset"));
        entity.setUploadSpeed(rs.getLong("uploadSpeed"));
        entity.setDownloaded(rs.getLong("downloaded"));
        entity.setDownloadedOffset(rs.getLong("downloadedOffset"));
        entity.setDownloadSpeed(rs.getLong("downloadSpeed"));
        entity.setLastFlags(rs.getString("lastFlags"));
        Timestamp firstTimeSeen = rs.getTimestamp("firstTimeSeen");
        Timestamp lastTimeSeen = rs.getTimestamp("lastTimeSeen");
        entity.setFirstTimeSeen(firstTimeSeen != null ? OffsetDateTime.ofInstant(firstTimeSeen.toInstant(), ZoneId.systemDefault()) : null);
        entity.setLastTimeSeen(lastTimeSeen != null ? OffsetDateTime.ofInstant(lastTimeSeen.toInstant(), ZoneId.systemDefault()) : null);
        if (!context.isSkipGeoIP() && context.getIpdbManager() != null) {
            try {
                IPDBManager.IPDBResponse ipdbResponse = context.getIpdbManager().queryIPDB(address);
                if (ipdbResponse != null && ipdbResponse.geoData() != null) {
                    IPGeoData geoData = ipdbResponse.geoData().get();
                    entity.setPeerGeoIp(geoData);
                }
            }
            catch (Exception e) {
                log.debug("Failed to generate GeoIP for IP {}: {}", (Object)addressStr, (Object)e.getMessage());
            }
        }
        return entity;
    }

    private void saveBatch(List<PeerRecordEntity> batch) {
        this.peerRecordService.getBaseMapper().insertOrUpdate(batch);
    }
}

