/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.routing;

import com.ghostchu.peerbanhelper.databasent.routing.DataSourceContext;
import com.ghostchu.peerbanhelper.databasent.routing.DataSourceType;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class WriteTransactionTemplate
extends TransactionTemplate {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WriteTransactionTemplate.class);

    public WriteTransactionTemplate(@NotNull PlatformTransactionManager transactionManager) {
        super(transactionManager);
        this.setReadOnly(false);
        this.setPropagationBehavior(0);
    }

    public <T> T execute(@NotNull TransactionCallback<T> action) {
        DataSourceType effectiveType = DataSourceType.WRITE;
        if (DataSourceContext.isBound() && DataSourceContext.getDataSourceType() == DataSourceType.WRITE) {
            return (T)super.execute(action);
        }
        if (log.isDebugEnabled()) {
            log.debug("WriteTransactionTemplate executing with WRITE datasource");
        }
        try {
            return (T)ScopedValue.where(DataSourceContext.getScopedValue(), effectiveType).call(() -> WriteTransactionTemplate.super.execute(action));
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Transaction execution failed", e);
        }
    }
}

