/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.service.impl.common;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ghostchu.peerbanhelper.databasent.mapper.java.AlertMapper;
import com.ghostchu.peerbanhelper.databasent.routing.WriteTransactionTemplate;
import com.ghostchu.peerbanhelper.databasent.service.AlertService;
import com.ghostchu.peerbanhelper.databasent.table.AlertEntity;
import java.time.OffsetDateTime;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AlertServiceImpl
extends ServiceImpl<AlertMapper, AlertEntity>
implements AlertService {
    @Autowired
    private WriteTransactionTemplate writeTransactionTemplate;

    @Override
    @NotNull
    public List<AlertEntity> getUnreadAlerts() {
        return ((AlertMapper)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().isNull(AlertEntity::getReadAt)).orderByDesc(AlertEntity::getCreateAt));
    }

    @Override
    public boolean identifierAlertExists(@NotNull String identifier) {
        return ((AlertMapper)this.baseMapper).exists((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(AlertEntity::getIdentifier, (Object)identifier)).isNull(AlertEntity::getReadAt));
    }

    @Override
    public boolean identifierAlertExistsIncludeRead(@NotNull String identifier) {
        return ((AlertMapper)this.baseMapper).exists((Wrapper)new LambdaQueryWrapper().eq(AlertEntity::getIdentifier, (Object)identifier));
    }

    @Override
    public int deleteOldAlerts(@NotNull OffsetDateTime before) {
        Integer changes;
        int deleted = 0;
        while ((changes = (Integer)this.writeTransactionTemplate.execute(status -> ((AlertMapper)this.baseMapper).delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().le(AlertEntity::getCreateAt, (Object)before)).last("LIMIT 150")))) != null && changes > 0) {
            deleted += changes.intValue();
        }
        return deleted;
    }

    @Override
    public void markAllAsRead() {
        ((AlertMapper)this.baseMapper).markAllAsRead(OffsetDateTime.now());
    }

    @Override
    public void markAsRead(@NotNull String identifier) {
        ((AlertMapper)this.baseMapper).markAsRead(identifier, OffsetDateTime.now());
    }
}

