/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.databasent.service.impl.common;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ghostchu.peerbanhelper.ExternalSwitch;
import com.ghostchu.peerbanhelper.bittorrent.peer.Peer;
import com.ghostchu.peerbanhelper.bittorrent.torrent.Torrent;
import com.ghostchu.peerbanhelper.databasent.mapper.java.TrackedSwarmMapper;
import com.ghostchu.peerbanhelper.databasent.routing.WriteTransactionTemplate;
import com.ghostchu.peerbanhelper.databasent.service.TrackedSwarmService;
import com.ghostchu.peerbanhelper.databasent.table.tmp.TrackedSwarmEntity;
import com.ghostchu.peerbanhelper.downloader.Downloader;
import com.ghostchu.peerbanhelper.util.query.Pageable;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.net.InetAddress;
import java.time.OffsetDateTime;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TrackedSwarmServiceImpl
extends ServiceImpl<TrackedSwarmMapper, TrackedSwarmEntity>
implements TrackedSwarmService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TrackedSwarmServiceImpl.class);
    @Autowired
    private WriteTransactionTemplate transactionTemplate;
    private final Cache<@NotNull CacheKey, @NotNull TrackedSwarmEntity> cache = CacheBuilder.newBuilder().maximumSize((long)ExternalSwitch.parseInt("pbh.module.swarm-tracking-module.cache-size", 1000)).expireAfterAccess(3L, TimeUnit.MINUTES).removalListener(notification -> {
        TrackedSwarmEntity v = (TrackedSwarmEntity)notification.getValue();
        if (v != null) {
            ((TrackedSwarmMapper)this.baseMapper).upsert(v);
        }
    }).softValues().build();

    @Override
    @NotNull
    public Page<TrackedSwarmEntity> getPendingSubmitTrackedPeers(@NotNull Pageable pageable, long idAfterThan) {
        return (Page)((TrackedSwarmMapper)this.baseMapper).selectPage((IPage)pageable.toPage(), (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().gt(TrackedSwarmEntity::getId, (Object)idAfterThan)).orderByAsc(TrackedSwarmEntity::getId));
    }

    @Override
    public void syncPeers(@NotNull Downloader downloader, @NotNull Torrent torrent, @NotNull Peer peer) throws ExecutionException {
        CacheKey cacheKey = new CacheKey(peer.getPeerAddress().getAddress().toNormalizedString(), peer.getPeerAddress().getPort(), torrent.getHash(), downloader.getId());
        TrackedSwarmEntity cachedEntity = (TrackedSwarmEntity)this.cache.get((Object)cacheKey, () -> {
            TrackedSwarmEntity lastData = (TrackedSwarmEntity)((TrackedSwarmMapper)this.baseMapper).selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TrackedSwarmEntity::getIp, (Object)InetAddress.getByName(cacheKey.ip))).eq(TrackedSwarmEntity::getPort, (Object)cacheKey.port)).eq(TrackedSwarmEntity::getInfoHash, (Object)cacheKey.infoHash)).eq(TrackedSwarmEntity::getDownloader, (Object)cacheKey.downloader)).orderByDesc(TrackedSwarmEntity::getId)).last("LIMIT 1"));
            if (lastData != null) {
                lastData.setLastTimeSeen(OffsetDateTime.now());
                return lastData;
            }
            return new TrackedSwarmEntity(null, peer.getPeerAddress().getAddress().toInetAddress(), peer.getPeerAddress().getPort(), torrent.getHash(), torrent.isPrivate(), torrent.getSize(), downloader.getId(), torrent.getProgress(), peer.getPeerId(), peer.getClientName(), peer.getProgress(), 0L, 0L, peer.getUploadSpeed(), 0L, 0L, peer.getDownloadSpeed(), peer.getFlags() == null ? "" : peer.getFlags().getLtStdString(), OffsetDateTime.now(), OffsetDateTime.now(), peer.getDownloadSpeed(), peer.getUploadSpeed());
        });
        long newDownloaded = peer.getDownloaded() >= cachedEntity.getDownloadedOffset() ? peer.getDownloaded() - cachedEntity.getDownloadedOffset() : peer.getDownloaded();
        long newUploaded = peer.getUploaded() >= cachedEntity.getUploadedOffset() ? peer.getUploaded() - cachedEntity.getUploadedOffset() : peer.getUploaded();
        cachedEntity.setDownloaded(cachedEntity.getDownloaded() + newDownloaded);
        cachedEntity.setUploaded(cachedEntity.getUploaded() + newUploaded);
        cachedEntity.setDownloadedOffset(peer.getDownloaded());
        cachedEntity.setUploadedOffset(peer.getUploaded());
        cachedEntity.setClientName(peer.getClientName());
        cachedEntity.setPeerId(peer.getPeerId());
        cachedEntity.setLastFlags(peer.getFlags() == null ? "" : peer.getFlags().getLtStdString());
        cachedEntity.setLastTimeSeen(OffsetDateTime.now());
        cachedEntity.setDownloadSpeedMax(Math.max(peer.getDownloadSpeed(), cachedEntity.getDownloadSpeedMax()));
        cachedEntity.setUploadSpeedMax(Math.max(peer.getUploadSpeed(), cachedEntity.getUploadSpeedMax()));
    }

    @Override
    public void flushAll() {
        this.transactionTemplate.execute(transactionStatus -> {
            for (TrackedSwarmEntity entity : this.cache.asMap().values()) {
                ((TrackedSwarmMapper)this.baseMapper).upsert(entity);
            }
            return null;
        });
    }

    @Override
    public void resetTable() {
        ((TrackedSwarmMapper)this.baseMapper).resetTable();
    }

    record CacheKey(String ip, int port, String infoHash, String downloader) {
    }
}

