/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.downloader;

import com.ghostchu.peerbanhelper.ExternalSwitch;
import com.ghostchu.peerbanhelper.alert.AlertLevel;
import com.ghostchu.peerbanhelper.alert.AlertManager;
import com.ghostchu.peerbanhelper.downloader.Downloader;
import com.ghostchu.peerbanhelper.downloader.DownloaderFeatureFlag;
import com.ghostchu.peerbanhelper.downloader.DownloaderLastStatus;
import com.ghostchu.peerbanhelper.downloader.DownloaderLoginResult;
import com.ghostchu.peerbanhelper.downloader.DownloaderStatistics;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.IPAddressUtil;
import com.ghostchu.peerbanhelper.util.MsgUtil;
import com.ghostchu.peerbanhelper.util.traversal.NatAddressProvider;
import com.ghostchu.peerbanhelper.wrapper.PeerAddress;
import inet.ipaddr.IPAddress;
import io.sentry.Sentry;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDownloader
implements Downloader {
    public final AlertManager alertManager;
    protected final String id;
    private final NatAddressProvider natAddressProvider;
    private DownloaderLastStatus lastStatus = DownloaderLastStatus.UNKNOWN;
    private TranslationComponent statusMessage = new TranslationComponent(Lang.STATUS_TEXT_UNKNOWN);
    private int failedLoginAttempts = 0;
    private long nextLoginTry = 0L;

    public AbstractDownloader(String id, AlertManager alertManager, NatAddressProvider natAddressProvider) {
        this.id = id;
        this.alertManager = alertManager;
        this.natAddressProvider = natAddressProvider;
    }

    @NotNull
    public PeerAddress natTranslate(PeerAddress peerAddress) {
        InetSocketAddress inetSocketAddress = new InetSocketAddress(peerAddress.getIp(), peerAddress.getPort());
        InetSocketAddress translate = this.natAddressProvider.translate(inetSocketAddress);
        if (translate == null) {
            return peerAddress;
        }
        return peerAddress.setNat(translate.getHostString(), translate.getPort());
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    public int getFailedLoginAttempts() {
        return this.failedLoginAttempts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public DownloaderLoginResult login() {
        if (this.isPaused()) {
            this.lastStatus = DownloaderLastStatus.PAUSED;
            this.statusMessage = new TranslationComponent(Lang.STATUS_TEXT_PAUSED);
            return new DownloaderLoginResult(DownloaderLoginResult.Status.PAUSED, new TranslationComponent(Lang.DOWNLOADER_PAUSED));
        }
        if (this.nextLoginTry >= System.currentTimeMillis()) {
            this.alertManager.publishAlert(true, AlertLevel.WARN, "downloader-too-many-failed-attempt-" + this.getId(), new TranslationComponent(Lang.DOWNLOADER_ALERT_TOO_MANY_FAILED_ATTEMPT_TITLE, this.getName()), new TranslationComponent(Lang.DOWNLOADER_ALERT_TOO_MANY_FAILED_ATTEMPT_DESCRIPTION, new Object[]{this.getName(), this.getLastStatus(), this.getLastStatusMessage()}));
            return new DownloaderLoginResult(DownloaderLoginResult.Status.REQUIRE_TAKE_ACTIONS, new TranslationComponent(Lang.TOO_MANY_FAILED_ATTEMPT, MsgUtil.getDateFormatter().format(new Date(this.nextLoginTry))));
        }
        try {
            DownloaderLoginResult result = this.login0();
            if (result.success()) {
                this.failedLoginAttempts = 0;
                DownloaderLoginResult downloaderLoginResult = result;
                return downloaderLoginResult;
            }
            if (result.status() == DownloaderLoginResult.Status.INCORRECT_CREDENTIAL) {
                ++this.failedLoginAttempts;
            }
            DownloaderLoginResult downloaderLoginResult = result;
            return downloaderLoginResult;
        }
        catch (IOException e) {
            ++this.failedLoginAttempts;
            DownloaderLoginResult downloaderLoginResult = new DownloaderLoginResult(DownloaderLoginResult.Status.EXCEPTION, new TranslationComponent(e.getMessage()));
            return downloaderLoginResult;
        }
        catch (Throwable e) {
            ++this.failedLoginAttempts;
            Sentry.captureException((Throwable)e);
            DownloaderLoginResult downloaderLoginResult = new DownloaderLoginResult(DownloaderLoginResult.Status.EXCEPTION, new TranslationComponent(e.getMessage()));
            return downloaderLoginResult;
        }
        finally {
            if (this.failedLoginAttempts >= 15) {
                this.nextLoginTry = System.currentTimeMillis() + 1800000L;
                this.failedLoginAttempts = 0;
            }
        }
    }

    @Override
    public synchronized void setPaused(boolean paused) {
        if (paused) {
            this.lastStatus = DownloaderLastStatus.PAUSED;
            this.statusMessage = new TranslationComponent(Lang.STATUS_TEXT_PAUSED);
        } else {
            this.lastStatus = DownloaderLastStatus.UNKNOWN;
            this.statusMessage = null;
        }
    }

    public abstract DownloaderLoginResult login0() throws Exception;

    @Override
    @NotNull
    public DownloaderLastStatus getLastStatus() {
        return this.lastStatus;
    }

    @Override
    public void setLastStatus(@NotNull DownloaderLastStatus lastStatus, @NotNull TranslationComponent statusMessage) {
        this.lastStatus = lastStatus;
        this.statusMessage = statusMessage;
    }

    @Override
    @NotNull
    public TranslationComponent getLastStatusMessage() {
        return this.statusMessage;
    }

    @Override
    @NotNull
    public DownloaderStatistics getStatistics() {
        return new DownloaderStatistics(0L, 0L);
    }

    @Override
    @NotNull
    public List<DownloaderFeatureFlag> getFeatureFlags() {
        return List.of(DownloaderFeatureFlag.UNBAN_IP);
    }

    @Override
    public int getMaxConcurrentPeerRequestSlots() {
        return ExternalSwitch.parseInt("pbh.downloader.AbstractDownloader.maxConcurrentPeerRequestSlots", 16);
    }

    @NotNull
    public IPAddress remapBanListAddress(@NotNull IPAddress banAddress) {
        return IPAddressUtil.remapBanListAddress(banAddress);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractDownloader that = (AbstractDownloader)obj;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

