/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module.impl.webapi;

import com.ghostchu.peerbanhelper.module.AbstractWebSocketFeatureModule;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.BackgroundTaskDTO;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.BackgroundTaskEvent;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.BackgroundTaskEventType;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.backgroundtask.BackgroundTask;
import com.ghostchu.peerbanhelper.util.backgroundtask.BackgroundTaskManager;
import com.ghostchu.peerbanhelper.web.JavalinWebContainer;
import com.ghostchu.peerbanhelper.web.Role;
import io.javalin.security.RouteRole;
import io.javalin.websocket.WsConfig;
import io.javalin.websocket.WsContext;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u000eH\u0016J\b\u0010\u0016\u001a\u00020\u000eH\u0016J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\rH\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\b8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\n8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u0002`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/ghostchu/peerbanhelper/module/impl/webapi/PBHBackgroundTaskController;", "Lcom/ghostchu/peerbanhelper/module/AbstractWebSocketFeatureModule;", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "webContainer", "Lcom/ghostchu/peerbanhelper/web/JavalinWebContainer;", "backgroundTaskManager", "Lcom/ghostchu/peerbanhelper/util/backgroundtask/BackgroundTaskManager;", "statusListener", "Lkotlin/Function1;", "Lcom/ghostchu/peerbanhelper/util/backgroundtask/BackgroundTask;", "", "Lcom/ghostchu/peerbanhelper/util/backgroundtask/TaskStatusListener;", "isConfigurable", "", "getName", "", "getConfigName", "onEnable", "onDisable", "handleTaskStream", "wsConfig", "Lio/javalin/websocket/WsConfig;", "sendCurrentTasks", "ctx", "Lio/javalin/websocket/WsContext;", "broadcastTaskUpdate", "task", "peerbanhelper"})
public final class PBHBackgroundTaskController
extends AbstractWebSocketFeatureModule {
    private final Logger logger = LoggerFactory.getLogger(PBHBackgroundTaskController.class);
    @Autowired
    private JavalinWebContainer webContainer;
    @Autowired
    private BackgroundTaskManager backgroundTaskManager;
    @NotNull
    private final Function1<BackgroundTask, Unit> statusListener = arg_0 -> PBHBackgroundTaskController.statusListener$lambda$0(this, arg_0);

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    @NotNull
    public String getName() {
        return "WebAPI - Background Tasks";
    }

    @Override
    @NotNull
    public String getConfigName() {
        return "webapi-background-tasks";
    }

    @Override
    public void onEnable() {
        JavalinWebContainer javalinWebContainer = this.webContainer;
        if (javalinWebContainer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webContainer");
            javalinWebContainer = null;
        }
        RouteRole[] routeRoleArray = new RouteRole[]{Role.USER_READ};
        javalinWebContainer.javalin().ws("/api/tasks/stream", this::handleTaskStream, routeRoleArray);
        BackgroundTaskManager backgroundTaskManager = this.backgroundTaskManager;
        if (backgroundTaskManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"backgroundTaskManager");
            backgroundTaskManager = null;
        }
        backgroundTaskManager.addStatusListener(this.statusListener);
    }

    @Override
    public void onDisable() {
        BackgroundTaskManager backgroundTaskManager = this.backgroundTaskManager;
        if (backgroundTaskManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"backgroundTaskManager");
            backgroundTaskManager = null;
        }
        backgroundTaskManager.removeStatusListener(this.statusListener);
    }

    private final void handleTaskStream(WsConfig wsConfig) {
        this.acceptWebSocket(wsConfig, arg_0 -> PBHBackgroundTaskController.handleTaskStream$lambda$0(this, arg_0));
    }

    private final void sendCurrentTasks(WsContext ctx) {
        String lang = this.locale(AbstractWebSocketFeatureModule.getContextFromWsContext(ctx));
        BackgroundTaskManager backgroundTaskManager = this.backgroundTaskManager;
        if (backgroundTaskManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"backgroundTaskManager");
            backgroundTaskManager = null;
        }
        for (BackgroundTask task : backgroundTaskManager.getTaskList()) {
            try {
                String string = task.getId();
                String string2 = TextManager.tl(lang, task.getTitle());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"tl(...)");
                ctx.send((Object)new BackgroundTaskEvent(BackgroundTaskEventType.UPDATED, new BackgroundTaskDTO(string, string2, TextManager.tl(lang, task.getStatusText()), task.getStatus(), task.getBarType(), task.getProgress(), task.getCurrent(), task.getMax())));
            }
            catch (Exception e) {
                this.logger.error("Failed to send task status to WebSocket client", (Throwable)e);
            }
        }
    }

    private final void broadcastTaskUpdate(BackgroundTask task) {
        for (WsContext session : this.wsSessions) {
            try {
                String string;
                String lang = this.locale(AbstractWebSocketFeatureModule.getContextFromWsContext(session));
                String string2 = task.getId();
                String string3 = TextManager.tl(lang, task.getTitle());
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"tl(...)");
                if (task.getStatusText() != null) {
                    TranslationComponent translationComponent = task.getStatusText();
                    Intrinsics.checkNotNull((Object)translationComponent);
                    string = TextManager.tl(lang, translationComponent);
                } else {
                    string = null;
                }
                BackgroundTaskEvent response = new BackgroundTaskEvent(BackgroundTaskEventType.UPDATED, new BackgroundTaskDTO(string2, string3, string, task.getStatus(), task.getBarType(), task.getProgress(), task.getCurrent(), task.getMax()));
                session.send((Object)response);
            }
            catch (Exception e) {
                this.logger.debug("Failed to send task update to WebSocket client", (Throwable)e);
            }
        }
    }

    private static final Unit statusListener$lambda$0(PBHBackgroundTaskController this$0, BackgroundTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this$0.broadcastTaskUpdate(task);
        return Unit.INSTANCE;
    }

    private static final void handleTaskStream$lambda$0(PBHBackgroundTaskController this$0, WsContext ctx) {
        Intrinsics.checkNotNull((Object)ctx);
        this$0.sendCurrentTasks(ctx);
    }
}

