/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module.impl.webapi;

import com.ghostchu.peerbanhelper.module.AbstractFeatureModule;
import com.ghostchu.peerbanhelper.module.impl.webapi.body.EnabledConfigBody;
import com.ghostchu.peerbanhelper.module.impl.webapi.body.ExperimentPutBody;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.ExperimentRecordDTO;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.util.lab.Experiments;
import com.ghostchu.peerbanhelper.util.lab.Laboratory;
import com.ghostchu.peerbanhelper.web.JavalinWebContainer;
import com.ghostchu.peerbanhelper.web.Role;
import com.ghostchu.peerbanhelper.web.wrapper.StdResp;
import io.javalin.Javalin;
import io.javalin.http.Context;
import io.javalin.security.RouteRole;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public final class PBHLabController
extends AbstractFeatureModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PBHLabController.class);
    private final JavalinWebContainer javalinWebContainer;
    private final Laboratory laboratory;

    public PBHLabController(JavalinWebContainer javalinWebContainer, Laboratory laboratory) {
        this.javalinWebContainer = javalinWebContainer;
        this.laboratory = laboratory;
    }

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    @NotNull
    public String getName() {
        return "WebAPI - Laboratory";
    }

    @Override
    @NotNull
    public String getConfigName() {
        return "webapi-laboratory";
    }

    @Override
    public void onEnable() {
        ((Javalin)((Javalin)((Javalin)((Javalin)this.javalinWebContainer.javalin().post("/api/laboratory/config", this::handleConfig, new RouteRole[]{Role.USER_WRITE})).get("/api/laboratory/config", this::handleConfigGet, new RouteRole[]{Role.USER_WRITE})).get("/api/laboratory/experiments", this::handleExperiments, new RouteRole[]{Role.USER_READ})).get("/api/laboratory/isExperimentActivated", this::handleExperimentActivated, new RouteRole[]{Role.USER_READ})).put("/api/laboratory/experiment/{id}", this::handleExperimentSet, new RouteRole[]{Role.USER_WRITE});
    }

    private void handleConfigGet(Context context) {
        context.json((Object)new StdResp(true, null, new EnabledConfigBody(this.laboratory.isEnabled())));
    }

    private void handleConfig(Context context) {
        EnabledConfigBody configBody = (EnabledConfigBody)context.bodyAsClass(EnabledConfigBody.class);
        this.laboratory.setEnabled(configBody.isEnabled());
        context.json((Object)new StdResp(true, null, configBody.isEnabled()));
    }

    private void handleExperimentSet(@NotNull Context context) {
        String id = context.pathParam("id");
        ExperimentPutBody activated = (ExperimentPutBody)context.bodyAsClass(ExperimentPutBody.class);
        Boolean bool = null;
        if ("true".equalsIgnoreCase(activated.getStatus())) {
            bool = true;
        } else if ("false".equalsIgnoreCase(activated.getStatus())) {
            bool = false;
        }
        this.laboratory.setExperimentActivated(id, bool);
        context.json((Object)new StdResp(true, null, activated.getStatus()));
    }

    private void handleExperimentActivated(@NotNull Context context) {
        String id = context.queryParam("id");
        for (Experiments value : Experiments.values()) {
            if (!value.getExperiment().id().equalsIgnoreCase(id)) continue;
            context.json((Object)new StdResp(true, null, this.laboratory.isExperimentActivated(value.getExperiment())));
            return;
        }
        context.json((Object)new StdResp(false, "Experiment not found", null));
    }

    private void handleExperiments(@NotNull Context context) {
        ArrayList<ExperimentRecordDTO> availableExperiments = new ArrayList<ExperimentRecordDTO>();
        for (Experiments value : Experiments.values()) {
            ExperimentRecordDTO record = new ExperimentRecordDTO(value.getExperiment().id(), this.laboratory.isExperimentActivated(value.getExperiment()), value.getExperiment().group(), TextManager.tl(this.locale(context), value.getExperiment().title()), TextManager.tl(this.locale(context), value.getExperiment().description()));
            availableExperiments.add(record);
        }
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("experiments", availableExperiments);
        map.put("mygroup", Integer.valueOf(this.laboratory.getExperimentalGroup()));
        map.put("labEnabled", Boolean.valueOf(this.laboratory.isEnabled()));
        context.json((Object)new StdResp(true, null, map));
    }

    @Override
    public void onDisable() {
    }
}

