/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module.impl.webapi;

import com.ghostchu.peerbanhelper.BuildMeta;
import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.module.AbstractFeatureModule;
import com.ghostchu.peerbanhelper.module.FeatureModule;
import com.ghostchu.peerbanhelper.module.ModuleManagerImpl;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.ModuleRecordDTO;
import com.ghostchu.peerbanhelper.web.JavalinWebContainer;
import com.ghostchu.peerbanhelper.web.Role;
import com.ghostchu.peerbanhelper.web.wrapper.StdResp;
import io.javalin.http.Context;
import io.javalin.security.RouteRole;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class PBHMetadataController
extends AbstractFeatureModule {
    @Autowired
    private JavalinWebContainer webContainer;
    @Autowired
    private BuildMeta buildMeta;
    @Autowired
    private ModuleManagerImpl moduleManager;

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    @NotNull
    public String getName() {
        return "WebAPI - Metadata";
    }

    @Override
    @NotNull
    public String getConfigName() {
        return "webapi-metadata";
    }

    @Override
    public void onEnable() {
        this.webContainer.javalin().get("/api/metadata/manifest", this::handleManifest, new RouteRole[]{Role.ANYONE});
    }

    private void handleManifest(Context ctx) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("version", this.buildMeta);
        data.put("modules", this.moduleManager.getModules().stream().filter(FeatureModule::isModuleEnabled).map(f -> new ModuleRecordDTO(f.getClass().getName(), f.getConfigName())).toList());
        data.put("installationId", Main.getMainConfig().getString("installation-id", "not-initialized"));
        data.put("analytics", Main.getMainConfig().getBoolean("privacy.analytics"));
        ctx.json((Object)new StdResp(true, null, data));
    }

    @Override
    public void onDisable() {
    }
}

