/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module.impl.webapi;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ghostchu.peerbanhelper.btn.BtnNetwork;
import com.ghostchu.peerbanhelper.btn.ability.BtnAbility;
import com.ghostchu.peerbanhelper.btn.ability.impl.BtnAbilityIpQuery;
import com.ghostchu.peerbanhelper.databasent.dto.IPAddressTimeSeen;
import com.ghostchu.peerbanhelper.databasent.dto.IPAddressTotalTraffic;
import com.ghostchu.peerbanhelper.databasent.service.HistoryService;
import com.ghostchu.peerbanhelper.databasent.service.PeerRecordService;
import com.ghostchu.peerbanhelper.databasent.service.TorrentService;
import com.ghostchu.peerbanhelper.databasent.table.HistoryEntity;
import com.ghostchu.peerbanhelper.databasent.table.PeerRecordEntity;
import com.ghostchu.peerbanhelper.databasent.table.TorrentEntity;
import com.ghostchu.peerbanhelper.downloader.DownloaderManagerImpl;
import com.ghostchu.peerbanhelper.module.AbstractFeatureModule;
import com.ghostchu.peerbanhelper.module.impl.monitor.ActiveMonitoringModule;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.AccessHistoryDTO;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.BanHistoryDTO;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.PeerInfoDTO;
import com.ghostchu.peerbanhelper.module.impl.webapi.dto.TorrentEntityDTO;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.util.IPAddressUtil;
import com.ghostchu.peerbanhelper.util.URLUtil;
import com.ghostchu.peerbanhelper.util.dns.DNSLookup;
import com.ghostchu.peerbanhelper.util.ipdb.IPDB;
import com.ghostchu.peerbanhelper.util.ipdb.IPDBManager;
import com.ghostchu.peerbanhelper.util.ipdb.IPGeoData;
import com.ghostchu.peerbanhelper.util.lab.Laboratory;
import com.ghostchu.peerbanhelper.util.query.Orderable;
import com.ghostchu.peerbanhelper.util.query.PBHPage;
import com.ghostchu.peerbanhelper.util.query.Pageable;
import com.ghostchu.peerbanhelper.web.JavalinWebContainer;
import com.ghostchu.peerbanhelper.web.Role;
import com.ghostchu.peerbanhelper.web.wrapper.StdResp;
import com.google.common.net.HostAndPort;
import inet.ipaddr.IPAddress;
import io.javalin.Javalin;
import io.javalin.http.Context;
import io.javalin.security.RouteRole;
import java.io.IOException;
import java.net.InetAddress;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class PBHPeerController
extends AbstractFeatureModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PBHPeerController.class);
    private final JavalinWebContainer javalinWebContainer;
    private final HistoryService historyDao;
    private final PeerRecordService peerRecordDao;
    private final ActiveMonitoringModule activeMonitoringModule;
    private final Laboratory laboratory;
    private final DNSLookup dnsLookup;
    private final DownloaderManagerImpl downloaderManager;
    private final TorrentService torrentDao;
    private final IPDBManager iPDBManager;
    private final BtnNetwork btnNetwork;

    public PBHPeerController(JavalinWebContainer javalinWebContainer, HistoryService historyDao, PeerRecordService peerRecordDao, ActiveMonitoringModule activeMonitoringModule, Laboratory laboratory, DNSLookup dnsLookup, DownloaderManagerImpl downloaderManager, TorrentService torrentDao, IPDBManager iPDBManager, @Autowired(required=false) BtnNetwork btnNetwork) {
        this.javalinWebContainer = javalinWebContainer;
        this.historyDao = historyDao;
        this.peerRecordDao = peerRecordDao;
        this.activeMonitoringModule = activeMonitoringModule;
        this.laboratory = laboratory;
        this.dnsLookup = dnsLookup;
        this.downloaderManager = downloaderManager;
        this.torrentDao = torrentDao;
        this.iPDBManager = iPDBManager;
        this.btnNetwork = btnNetwork;
    }

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    @NotNull
    public String getName() {
        return "Peer Controller";
    }

    @Override
    @NotNull
    public String getConfigName() {
        return "peer-controller";
    }

    @Override
    public void onEnable() {
        ((Javalin)((Javalin)((Javalin)((Javalin)this.javalinWebContainer.javalin().get("/api/peer/{ip}", this::handleInfo, new RouteRole[]{Role.USER_READ})).get("/api/peer/{ip}/accessHistory", this::handleAccessHistory, new RouteRole[]{Role.USER_READ, Role.PBH_PLUS})).get("/api/peer/{ip}/banHistory", this::handleBanHistory, new RouteRole[]{Role.USER_READ, Role.PBH_PLUS})).get("/api/peer/{ip}/btnQuery", this::handleBtnQuery, new RouteRole[]{Role.USER_READ})).get("/api/peer/{ip}/btnQueryIframe", this::handleBtnQueryIFrame, new RouteRole[]{Role.USER_READ});
    }

    private void handleBtnQueryIFrame(@NotNull Context ctx) {
        HostAndPort hostAndPort = HostAndPort.fromString((String)ctx.pathParam("ip"));
        IPAddress ipAddress = IPAddressUtil.getIPAddress(hostAndPort.getHost());
        String ip = ipAddress.toNormalizedString();
        if (this.btnNetwork == null) {
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.BTN_NETWORK_NOT_ENABLED, new Object[0]), null));
            return;
        }
        BtnAbility ability = this.btnNetwork.getAbilities().get(BtnAbilityIpQuery.class);
        if (ability == null) {
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.BTN_ABILITY_IP_QUERY_NOT_PROVIDED, new Object[0]), null));
            return;
        }
        BtnAbilityIpQuery queryAbility = (BtnAbilityIpQuery)ability;
        String url = URLUtil.appendUrl(queryAbility.getIframeEndpoint(), Map.of("ip", ip, "appId", this.btnNetwork.getAppId(), "appSecret", this.btnNetwork.getAppSecret(), "hardwareId", this.btnNetwork.getBtnHardwareId(), "installationId", this.btnNetwork.getInstallationId()));
        ctx.json((Object)new StdResp(true, null, url));
    }

    private void handleBtnQuery(@NotNull Context ctx) throws IOException {
        HostAndPort hostAndPort = HostAndPort.fromString((String)ctx.pathParam("ip"));
        IPAddress ipAddress = IPAddressUtil.getIPAddress(hostAndPort.getHost());
        String ip = ipAddress.toNormalizedString();
        if (this.btnNetwork == null) {
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.BTN_NETWORK_NOT_ENABLED, new Object[0]), null));
            return;
        }
        BtnAbility ability = this.btnNetwork.getAbilities().get(BtnAbilityIpQuery.class);
        if (ability == null) {
            ctx.json((Object)new StdResp(false, TextManager.tl(this.locale(ctx), Lang.BTN_ABILITY_IP_QUERY_NOT_PROVIDED, new Object[0]), null));
            return;
        }
        BtnAbilityIpQuery queryAbility = (BtnAbilityIpQuery)ability;
        BtnAbilityIpQuery.IpQueryResult query = queryAbility.query(ip);
        ctx.json((Object)new StdResp(true, null, query));
    }

    private void handleInfo(Context ctx) {
        BtnAbility ability;
        HostAndPort hostAndPort = HostAndPort.fromString((String)ctx.pathParam("ip"));
        IPAddress ipAddress = IPAddressUtil.getIPAddress(hostAndPort.getHost());
        InetAddress inet = ipAddress.toInetAddress();
        long banCount = this.historyDao.countHistoriesByIp(inet);
        long torrentAccessCount = this.peerRecordDao.countRecordsByIp(inet);
        IPAddressTotalTraffic upDownResult = this.peerRecordDao.queryAddressTotalTraffic(inet);
        long uploadedToPeer = upDownResult.getTotalUploaded();
        long downloadedFromPeer = upDownResult.getTotalDownloaded();
        IPAddressTimeSeen timeSeen = this.peerRecordDao.queryAddressTimeSeen(inet);
        OffsetDateTime firstTimeSeen = timeSeen.getFirstTimeSeen();
        OffsetDateTime lastTimeSeen = timeSeen.getLastTimeSeen();
        IPDB ipdb = this.iPDBManager.getIpdb();
        IPGeoData geoIP = null;
        try {
            if (ipdb != null) {
                geoIP = ipdb.query(ipAddress.toInetAddress());
            }
        }
        catch (Exception e) {
            log.warn("Unable to perform GeoIP query for ip {}", (Object)inet);
        }
        String ptrLookup = null;
        try {
            ptrLookup = this.dnsLookup.ptr(inet.getHostAddress()).get(3L, TimeUnit.SECONDS).orElse(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean btnQueryAvailable = false;
        if (this.btnNetwork != null && (ability = this.btnNetwork.getAbilities().get(BtnAbilityIpQuery.class)) != null) {
            btnQueryAvailable = true;
        }
        PeerInfoDTO info = new PeerInfoDTO(banCount > 0L || torrentAccessCount > 0L, inet.getHostAddress(), firstTimeSeen, lastTimeSeen, banCount, torrentAccessCount, uploadedToPeer, downloadedFromPeer, geoIP, ptrLookup, btnQueryAvailable);
        ctx.json((Object)new StdResp(true, null, info));
    }

    private void handleBanHistory(Context ctx) {
        InetAddress ip = IPAddressUtil.getIPAddress(ctx.pathParam("ip")).toInetAddress();
        Pageable pageable = new Pageable(ctx);
        Orderable orderBy = new Orderable(Map.of("ban_at", false), ctx).addRemapping("banAt", "ban_at").addRemapping("unbanAt", "unban_at").addRemapping("peerIp", "ip").addRemapping("peerPort", "port").addRemapping("peerId", "peer_id").addRemapping("peerClientName", "peer_client_name").addRemapping("peerUploaded", "peer_uploaded").addRemapping("peerDownloaded", "peer_downloaded").addRemapping("peerProgress", "peer_progress").addRemapping("torrentInfoHash", "torrent_info_hash").addRemapping("module", "module_name").addRemapping("rule", "rule_name").addRemapping("description", "description");
        IPage<HistoryEntity> page = this.historyDao.queryBanHistoryByIp(pageable.toPage(), ip, orderBy);
        page.convert(entity -> {
            TorrentEntityDTO torrentEntityDTO = TorrentEntityDTO.from((TorrentEntity)this.torrentDao.getById(entity.getTorrentId()));
            return new BanHistoryDTO(entity.getBanAt(), entity.getUnbanAt(), entity.getIp().getHostAddress(), entity.getPort(), entity.getPeerId(), entity.getPeerClientName(), entity.getPeerUploaded(), entity.getPeerDownloaded(), entity.getPeerProgress(), torrentEntityDTO.infoHash(), torrentEntityDTO.name(), torrentEntityDTO.size(), entity.getModuleName(), TextManager.tl(this.locale(ctx), entity.getRuleName()), TextManager.tl(this.locale(ctx), entity.getDescription()), this.downloaderManager.getDownloadInfo(entity.getDownloader()));
        });
        ctx.json((Object)new StdResp(true, null, PBHPage.from(page)));
    }

    private void handleAccessHistory(Context ctx) {
        InetAddress ip = IPAddressUtil.getIPAddress(ctx.pathParam("ip")).toInetAddress();
        Pageable pageable = new Pageable(ctx);
        Orderable orderBy = new Orderable(Map.of("last_time_seen", false, "address", false, "port", true), ctx).addRemapping("peerId", "peer_id").addRemapping("clientName", "client_name").addRemapping("firstTimeSeen", "first_time_seen").addRemapping("lastTimeSeen", "last_time_seen");
        IPage<PeerRecordEntity> page = this.peerRecordDao.queryAccessHistoryByIp(pageable.toPage(), ip, orderBy);
        IPage accessHistoryDTOIPage = page.convert(entity -> new AccessHistoryDTO(entity.getId(), entity.getAddress().getHostAddress(), entity.getPort(), TorrentEntityDTO.from((TorrentEntity)this.torrentDao.getById(entity.getTorrentId())), this.downloaderManager.getDownloadInfo(entity.getDownloader()), entity.getPeerId(), entity.getClientName(), entity.getUploaded(), entity.getUploadedOffset(), entity.getUploadSpeed(), entity.getDownloaded(), entity.getDownloadedOffset(), entity.getDownloadSpeed(), entity.getLastFlags(), entity.getFirstTimeSeen(), entity.getLastTimeSeen()));
        ctx.json((Object)new StdResp(true, null, PBHPage.from(accessHistoryDTOIPage)));
    }

    @Override
    public void onDisable() {
    }
}

