/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.backgroundtask;

import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.backgroundtask.BackgroundTaskProgressBarType;
import com.ghostchu.peerbanhelper.util.backgroundtask.BackgroundTaskStatus;
import java.time.OffsetDateTime;
import java.util.UUID;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u00101\u001a\u0002022\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u000004H&J\u0006\u00105\u001a\u000202J\u0006\u00106\u001a\u000202R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0007\"\u0004\b\u000e\u0010\u0005R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0012\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010%\"\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010+\"\u0004\b0\u0010-R\u0011\u00107\u001a\u0002088F\u00a2\u0006\u0006\u001a\u0004\b9\u0010:\u00a8\u0006;"}, d2={"Lcom/ghostchu/peerbanhelper/util/backgroundtask/BackgroundTask;", "", "title", "Lcom/ghostchu/peerbanhelper/text/TranslationComponent;", "<init>", "(Lcom/ghostchu/peerbanhelper/text/TranslationComponent;)V", "getTitle", "()Lcom/ghostchu/peerbanhelper/text/TranslationComponent;", "id", "", "getId", "()Ljava/lang/String;", "statusText", "getStatusText", "setStatusText", "startAt", "Ljava/time/OffsetDateTime;", "getStartAt", "()Ljava/time/OffsetDateTime;", "finishedAt", "getFinishedAt", "setFinishedAt", "(Ljava/time/OffsetDateTime;)V", "status", "Lcom/ghostchu/peerbanhelper/util/backgroundtask/BackgroundTaskStatus;", "getStatus", "()Lcom/ghostchu/peerbanhelper/util/backgroundtask/BackgroundTaskStatus;", "setStatus", "(Lcom/ghostchu/peerbanhelper/util/backgroundtask/BackgroundTaskStatus;)V", "barType", "Lcom/ghostchu/peerbanhelper/util/backgroundtask/BackgroundTaskProgressBarType;", "getBarType", "()Lcom/ghostchu/peerbanhelper/util/backgroundtask/BackgroundTaskProgressBarType;", "setBarType", "(Lcom/ghostchu/peerbanhelper/util/backgroundtask/BackgroundTaskProgressBarType;)V", "isDisposalImmediatelyAfterComplete", "", "()Z", "setDisposalImmediatelyAfterComplete", "(Z)V", "max", "", "getMax", "()J", "setMax", "(J)V", "current", "getCurrent", "setCurrent", "start", "", "callback", "Ljava/util/function/Consumer;", "complete", "fail", "progress", "", "getProgress", "()D", "peerbanhelper"})
public abstract class BackgroundTask {
    @NotNull
    private final TranslationComponent title;
    @NotNull
    private final String id;
    @Nullable
    private TranslationComponent statusText;
    @NotNull
    private final OffsetDateTime startAt;
    @Nullable
    private OffsetDateTime finishedAt;
    @NotNull
    private BackgroundTaskStatus status;
    @NotNull
    private BackgroundTaskProgressBarType barType;
    private boolean isDisposalImmediatelyAfterComplete;
    private long max;
    private long current;

    public BackgroundTask(@NotNull TranslationComponent title) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        this.title = title;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.id = string;
        OffsetDateTime offsetDateTime = OffsetDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime, (String)"now(...)");
        this.startAt = offsetDateTime;
        this.status = BackgroundTaskStatus.QUEUED;
        this.barType = BackgroundTaskProgressBarType.INDETERMINATE;
    }

    @NotNull
    public final TranslationComponent getTitle() {
        return this.title;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @Nullable
    public final TranslationComponent getStatusText() {
        return this.statusText;
    }

    public final void setStatusText(@Nullable TranslationComponent translationComponent) {
        this.statusText = translationComponent;
    }

    @NotNull
    public final OffsetDateTime getStartAt() {
        return this.startAt;
    }

    @Nullable
    public final OffsetDateTime getFinishedAt() {
        return this.finishedAt;
    }

    public final void setFinishedAt(@Nullable OffsetDateTime offsetDateTime) {
        this.finishedAt = offsetDateTime;
    }

    @NotNull
    public final BackgroundTaskStatus getStatus() {
        return this.status;
    }

    public final void setStatus(@NotNull BackgroundTaskStatus backgroundTaskStatus) {
        Intrinsics.checkNotNullParameter((Object)((Object)backgroundTaskStatus), (String)"<set-?>");
        this.status = backgroundTaskStatus;
    }

    @NotNull
    public final BackgroundTaskProgressBarType getBarType() {
        return this.barType;
    }

    public final void setBarType(@NotNull BackgroundTaskProgressBarType backgroundTaskProgressBarType) {
        Intrinsics.checkNotNullParameter((Object)((Object)backgroundTaskProgressBarType), (String)"<set-?>");
        this.barType = backgroundTaskProgressBarType;
    }

    public final boolean isDisposalImmediatelyAfterComplete() {
        return this.isDisposalImmediatelyAfterComplete;
    }

    public final void setDisposalImmediatelyAfterComplete(boolean bl) {
        this.isDisposalImmediatelyAfterComplete = bl;
    }

    public final long getMax() {
        return this.max;
    }

    public final void setMax(long l) {
        this.max = l;
    }

    public final long getCurrent() {
        return this.current;
    }

    public final void setCurrent(long l) {
        this.current = l;
    }

    public abstract void start(@NotNull Consumer<BackgroundTask> var1);

    public final void complete() {
        this.finishedAt = OffsetDateTime.now();
        if (this.status == BackgroundTaskStatus.QUEUED || this.status == BackgroundTaskStatus.RUNNING) {
            this.status = BackgroundTaskStatus.COMPLETED;
        }
    }

    public final void fail() {
        this.finishedAt = OffsetDateTime.now();
        this.status = BackgroundTaskStatus.FAILED;
    }

    public final double getProgress() {
        return this.max == 0L ? 0.0 : (double)this.current / (double)this.max;
    }
}

