/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.dns;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.util.dns.DNSLookup;
import com.ghostchu.simplereloadlib.ReloadResult;
import com.ghostchu.simplereloadlib.Reloadable;
import io.sentry.Sentry;
import java.net.UnknownHostException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.xbill.DNS.DohResolver;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.PTRRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TextParseException;
import oshi.SystemInfo;

@Component
public final class DNSLookupImpl
implements Reloadable,
DNSLookup {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DNSLookupImpl.class);
    private final SystemInfo systemInfo;
    private volatile ExtendedResolver resolver;
    private volatile boolean bootComplete = false;

    public DNSLookupImpl(SystemInfo systemInfo) {
        this.systemInfo = systemInfo;
        this.reloadConfig();
        Main.getReloadManager().register((Reloadable)this);
    }

    public ReloadResult reloadModule() throws Exception {
        this.reloadConfig();
        return super.reloadModule();
    }

    private void reloadConfig() {
        try {
            this.resolver = new ExtendedResolver();
            String[] dnsServers = this.systemInfo.getOperatingSystem().getNetworkParams().getDnsServers();
            List dns = Main.getMainConfig().getStringList("resolvers.servers");
            if (Main.getMainConfig().getBoolean("resolvers.use-system", true)) {
                dns.addAll(Arrays.asList(dnsServers));
            }
            this.applyDnsServers(dns);
            this.bootComplete = true;
        }
        catch (Throwable e) {
            log.error("Unable to complete oshi DNS Servers lookup, DNSJAVA functions may not work properly", e);
            Sentry.captureException((Throwable)e);
            this.bootComplete = false;
        }
    }

    private void applyDnsServers(List<String> servers) {
        ArrayList<Object> resolvers = new ArrayList<Object>();
        for (String dns : servers) {
            if (dns.startsWith("http")) {
                resolvers.add(new DohResolver(dns));
                log.debug("Added DoH resolver: {}", (Object)dns);
                continue;
            }
            try {
                resolvers.add(new SimpleResolver(dns));
                log.debug("Added resolver: {}", (Object)dns);
            }
            catch (UnknownHostException e) {
                log.warn("Failed to add resolver: {}", (Object)dns, (Object)e);
            }
        }
        ExtendedResolver replace = new ExtendedResolver(resolvers.toArray(new Resolver[0]));
        replace.setLoadBalance(true);
        replace.setTimeout(Duration.of(3L, ChronoUnit.SECONDS));
        this.resolver = replace;
    }

    @Override
    public CompletableFuture<Optional<String>> ptr(String query) {
        if (!this.bootComplete) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                Lookup lookup = new Lookup(query, 12);
                lookup.setResolver((Resolver)this.resolver);
                lookup.run();
                if (lookup.getResult() == 0) {
                    Record[] records;
                    for (Record record : records = lookup.getAnswers()) {
                        if (!(record instanceof PTRRecord)) continue;
                        PTRRecord ptr = (PTRRecord)record;
                        return Optional.of(ptr.getTarget().toString());
                    }
                    return Optional.empty();
                }
                return Optional.empty();
            }
            catch (TextParseException e) {
                log.debug("PTR lookup failed for {}: {}", (Object)query, (Object)e.getMessage());
                return Optional.empty();
            }
        }, Executors.newVirtualThreadPerTaskExecutor());
    }
}

