/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.scriptengine;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.module.AbstractRuleFeatureModule;
import com.ghostchu.peerbanhelper.module.CheckResult;
import com.ghostchu.peerbanhelper.module.PeerAction;
import com.ghostchu.peerbanhelper.platform.Platform;
import com.ghostchu.peerbanhelper.platform.types.MalwareScanner;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.scriptengine.AVCompiledScript;
import com.ghostchu.peerbanhelper.util.scriptengine.CompiledScript;
import com.ghostchu.peerbanhelper.util.scriptengine.ScriptEngine;
import com.ghostchu.peerbanhelper.wrapper.StructuredData;
import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.Expression;
import java.io.BufferedReader;
import java.io.File;
import java.io.StringReader;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public final class AVScriptEngine
implements ScriptEngine {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AVScriptEngine.class);
    public static final CheckResult OK_CHECK_RESULT = new CheckResult(AbstractRuleFeatureModule.class, PeerAction.NO_ACTION, 0L, new TranslationComponent("N/A"), new TranslationComponent("Check passed"), StructuredData.create().add("status", "pass"));

    @Nullable
    public CheckResult handleResult(CompiledScript script, long banDuration, Object returns) {
        if (returns instanceof Boolean) {
            Boolean status = (Boolean)returns;
            if (status.booleanValue()) {
                return new CheckResult(this.getClass(), PeerAction.BAN, banDuration, new TranslationComponent(Lang.USER_SCRIPT_RULE), new TranslationComponent(Lang.USER_SCRIPT_RUN_RESULT, script.name(), "true"), StructuredData.create().add("script", script.name()));
            }
            return null;
        }
        if (returns instanceof Number) {
            Number number = (Number)returns;
            int i = number.intValue();
            if (i == 0) {
                return null;
            }
            if (i == 1) {
                return new CheckResult(this.getClass(), PeerAction.BAN, banDuration, new TranslationComponent(Lang.USER_SCRIPT_RULE), new TranslationComponent(Lang.USER_SCRIPT_RUN_RESULT, script.name(), String.valueOf(number)), StructuredData.create().add("script", script.name()));
            }
            if (i == 2) {
                return new CheckResult(this.getClass(), PeerAction.SKIP, banDuration, new TranslationComponent(Lang.USER_SCRIPT_RULE), new TranslationComponent(Lang.USER_SCRIPT_RUN_RESULT, script.name(), String.valueOf(number)), StructuredData.create().add("script", script.name()));
            }
            log.error(TextManager.tlUI(Lang.RULE_ENGINE_INVALID_RETURNS, script));
            return null;
        }
        if (returns instanceof PeerAction) {
            PeerAction action = (PeerAction)((Object)returns);
            return new CheckResult(this.getClass(), action, banDuration, new TranslationComponent(Lang.USER_SCRIPT_RULE), new TranslationComponent(Lang.USER_SCRIPT_RUN_RESULT, script.name(), action.name()), StructuredData.create().add("script", script.name()));
        }
        if (returns instanceof String) {
            String string = (String)returns;
            if (string.isBlank()) {
                return OK_CHECK_RESULT;
            }
            if (string.startsWith("@")) {
                return new CheckResult(this.getClass(), PeerAction.SKIP, banDuration, new TranslationComponent(Lang.USER_SCRIPT_RULE), new TranslationComponent(string.substring(1)), StructuredData.create().add("script", script.name()));
            }
            return new CheckResult(this.getClass(), PeerAction.BAN, banDuration, new TranslationComponent(Lang.USER_SCRIPT_RULE), new TranslationComponent(Lang.USER_SCRIPT_RUN_RESULT, script.name(), string), StructuredData.create().add("script", script.name()));
        }
        if (returns instanceof CheckResult) {
            CheckResult checkResult = (CheckResult)returns;
            return checkResult;
        }
        log.error(TextManager.tlUI(Lang.RULE_ENGINE_INVALID_RETURNS, script.name()));
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public CompiledScript compileScript(File file, String fallbackName, String scriptContent) {
        Platform platform = Main.getPlatform();
        if (platform != null) {
            try (MalwareScanner scanner = platform.getMalwareScanner();){
                if (scanner != null && scanner.isMalicious(scriptContent)) {
                    log.error(TextManager.tlUI(Lang.MALWARE_SCANNER_DETECTED, "UserScript", file != null ? file.getAbsolutePath() : "<memory script>"));
                    CompiledScript compiledScript = null;
                    return compiledScript;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try (BufferedReader reader = new BufferedReader(new StringReader(scriptContent));){
            String name = fallbackName;
            String author = "Unknown";
            String version = "null";
            boolean cacheable = true;
            boolean threadSafe = true;
            while (true) {
                String line;
                if ((line = reader.readLine()) == null) {
                    AviatorEvaluator.getInstance().validate(scriptContent);
                    Expression expression = AviatorEvaluator.getInstance().compile(scriptContent, true);
                    AVCompiledScript aVCompiledScript = new AVCompiledScript(file, name, author, cacheable, threadSafe, version, scriptContent, expression);
                    return aVCompiledScript;
                }
                if (!line.startsWith("#")) continue;
                if ((line = line.substring(2).trim()).startsWith("@NAME")) {
                    name = line.substring(5).trim();
                    continue;
                }
                if (line.startsWith("@AUTHOR")) {
                    author = line.substring(7).trim();
                    continue;
                }
                if (line.startsWith("@CACHEABLE")) {
                    cacheable = Boolean.parseBoolean(line.substring(10).trim());
                    continue;
                }
                if (line.startsWith("@VERSION")) {
                    version = line.substring(8).trim();
                    continue;
                }
                if (!line.startsWith("@THREADSAFE")) continue;
                threadSafe = Boolean.parseBoolean(line.substring(11).trim());
            }
        }
        catch (Exception e) {
            log.warn("Script Engine unable to compile the script: {}", (Object)fallbackName, (Object)e);
            return null;
        }
    }

    @Override
    public String getEngineName() {
        return "Aviator";
    }

    @Override
    public String getFileExtension() {
        return ".av";
    }
}

