/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.scriptengine;

import com.ghostchu.peerbanhelper.module.AbstractRuleFeatureModule;
import com.ghostchu.peerbanhelper.module.CheckResult;
import com.ghostchu.peerbanhelper.module.PeerAction;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.scriptengine.AVScriptEngine;
import com.ghostchu.peerbanhelper.util.scriptengine.CompiledScript;
import com.ghostchu.peerbanhelper.util.scriptengine.ScriptEngine;
import com.ghostchu.peerbanhelper.wrapper.StructuredData;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\bJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\bJ&\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\bJ\"\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001f"}, d2={"Lcom/ghostchu/peerbanhelper/util/scriptengine/ScriptEngineManager;", "", "avScriptEngine", "Lcom/ghostchu/peerbanhelper/util/scriptengine/AVScriptEngine;", "<init>", "(Lcom/ghostchu/peerbanhelper/util/scriptengine/AVScriptEngine;)V", "engineMap", "", "", "Lcom/ghostchu/peerbanhelper/util/scriptengine/ScriptEngine;", "supportedExtensions", "", "getSupportedExtensions", "()Ljava/util/List;", "getEngineByExtension", "extension", "getEngineByFileName", "fileName", "compileScript", "Lcom/ghostchu/peerbanhelper/util/scriptengine/CompiledScript;", "file", "Ljava/io/File;", "fallbackName", "scriptContent", "handleResult", "Lcom/ghostchu/peerbanhelper/module/CheckResult;", "script", "banDuration", "", "returns", "Companion", "peerbanhelper"})
public final class ScriptEngineManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, ScriptEngine> engineMap;
    private static final Logger log = LoggerFactory.getLogger(ScriptEngineManager.class);
    @NotNull
    private static final CheckResult OK_CHECK_RESULT = new CheckResult(AbstractRuleFeatureModule.class, PeerAction.NO_ACTION, 0L, new TranslationComponent("N/A"), new TranslationComponent("Check passed"), StructuredData.create().add("status", "pass"));

    public ScriptEngineManager(@NotNull AVScriptEngine avScriptEngine) {
        Intrinsics.checkNotNullParameter((Object)avScriptEngine, (String)"avScriptEngine");
        this.engineMap = new HashMap();
        this.engineMap.put(".av", avScriptEngine);
    }

    @NotNull
    public final List<String> getSupportedExtensions() {
        return CollectionsKt.toList((Iterable)this.engineMap.keySet());
    }

    @Nullable
    public final ScriptEngine getEngineByExtension(@NotNull String extension) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        String string = extension;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return this.engineMap.get(string2);
    }

    @Nullable
    public final ScriptEngine getEngineByFileName(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        for (Map.Entry<String, ScriptEngine> entry : this.engineMap.entrySet()) {
            if (!StringsKt.endsWith$default((String)fileName, (String)entry.getKey(), (boolean)false, (int)2, null)) continue;
            return entry.getValue();
        }
        return this.engineMap.get(".av");
    }

    @Nullable
    public final CompiledScript compileScript(@Nullable File file, @Nullable String fallbackName, @Nullable String scriptContent) {
        Object object = file;
        if ((object == null || (object = ((File)object).getName()) == null) && (object = fallbackName) == null) {
            return null;
        }
        Object fileName = object;
        ScriptEngine engine = this.getEngineByFileName((String)fileName);
        if (engine == null) {
            log.warn("No script engine found for file: {}", fileName);
            return null;
        }
        return engine.compileScript(file, fallbackName, scriptContent);
    }

    @Nullable
    public final CheckResult handleResult(@NotNull CompiledScript script, long banDuration, @Nullable Object returns) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        if (returns instanceof Boolean) {
            if (((Boolean)returns).booleanValue()) {
                Object[] objectArray = new Object[]{script.name(), "true"};
                return new CheckResult(this.getClass(), PeerAction.BAN, banDuration, new TranslationComponent(Lang.USER_SCRIPT_RULE), new TranslationComponent(Lang.USER_SCRIPT_RUN_RESULT, objectArray), StructuredData.create().add("script", script.name()));
            }
            return null;
        }
        if (returns instanceof Number) {
            int i = ((Number)returns).intValue();
            switch (i) {
                case 0: {
                    return null;
                }
                case 1: {
                    Object[] objectArray = new Object[]{script.name(), ((Number)returns).toString()};
                    return new CheckResult(this.getClass(), PeerAction.BAN, banDuration, new TranslationComponent(Lang.USER_SCRIPT_RULE), new TranslationComponent(Lang.USER_SCRIPT_RUN_RESULT, objectArray), StructuredData.create().add("script", script.name()));
                }
                case 2: {
                    Object[] objectArray = new Object[]{script.name(), ((Number)returns).toString()};
                    return new CheckResult(this.getClass(), PeerAction.SKIP, banDuration, new TranslationComponent(Lang.USER_SCRIPT_RULE), new TranslationComponent(Lang.USER_SCRIPT_RUN_RESULT, objectArray), StructuredData.create().add("script", script.name()));
                }
            }
            Object[] objectArray = new Object[]{script};
            log.error(TextManager.tlUI(Lang.RULE_ENGINE_INVALID_RETURNS, objectArray));
            return null;
        }
        if (returns instanceof PeerAction) {
            Object[] objectArray = new Object[]{script.name(), ((PeerAction)((Object)returns)).name()};
            return new CheckResult(this.getClass(), (PeerAction)((Object)returns), banDuration, new TranslationComponent(Lang.USER_SCRIPT_RULE), new TranslationComponent(Lang.USER_SCRIPT_RUN_RESULT, objectArray), StructuredData.create().add("script", script.name()));
        }
        if (returns instanceof String) {
            if (StringsKt.isBlank((CharSequence)((CharSequence)returns))) {
                return OK_CHECK_RESULT;
            }
            if (StringsKt.startsWith$default((String)((String)returns), (String)"@", (boolean)false, (int)2, null)) {
                Class<?> clazz = this.getClass();
                TranslationComponent translationComponent = new TranslationComponent(Lang.USER_SCRIPT_RULE);
                String string = ((String)returns).substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return new CheckResult(clazz, PeerAction.SKIP, banDuration, translationComponent, new TranslationComponent(string), StructuredData.create().add("script", script.name()));
            }
            Object[] objectArray = new Object[]{script.name(), returns};
            return new CheckResult(this.getClass(), PeerAction.BAN, banDuration, new TranslationComponent(Lang.USER_SCRIPT_RULE), new TranslationComponent(Lang.USER_SCRIPT_RUN_RESULT, objectArray), StructuredData.create().add("script", script.name()));
        }
        if (returns instanceof CheckResult) {
            return (CheckResult)returns;
        }
        Object[] objectArray = new Object[]{script.name()};
        log.error(TextManager.tlUI(Lang.RULE_ENGINE_INVALID_RETURNS, objectArray));
        return null;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/ghostchu/peerbanhelper/util/scriptengine/ScriptEngineManager$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "OK_CHECK_RESULT", "Lcom/ghostchu/peerbanhelper/module/CheckResult;", "getOK_CHECK_RESULT", "()Lcom/ghostchu/peerbanhelper/module/CheckResult;", "peerbanhelper"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CheckResult getOK_CHECK_RESULT() {
            return OK_CHECK_RESULT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

